/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.browser;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageFinder
implements ImageDisplayVisitor {
    private Set<ImageDisplay> imageNodes;
    private Set<ImageData> images = new HashSet<ImageData>();
    private List<ImageNode> visibleImageNodes;
    private Set<ImageData> visibleImages;

    public ImageFinder() {
        this.imageNodes = new HashSet<ImageDisplay>();
        this.visibleImages = new HashSet<ImageData>();
        this.visibleImageNodes = new ArrayList<ImageNode>();
    }

    public Set<ImageDisplay> getImageNodes() {
        return this.imageNodes;
    }

    public Set<ImageData> getImages() {
        return this.images;
    }

    public List<ImageNode> getVisibleImageNodes() {
        return this.visibleImageNodes;
    }

    public Set<ImageData> getVisibleImages() {
        return this.visibleImages;
    }

    @Override
    public void visit(ImageNode node) {
        this.imageNodes.add(node);
        Object ho = node.getHierarchyObject();
        if (ho instanceof ImageData) {
            this.images.add((ImageData)ho);
        }
    }

    @Override
    public void visit(ImageSet node) {
        if (node == null) {
            return;
        }
        JComponent desktop = node.getInternalDesktop();
        Component[] comps = desktop.getComponents();
        if (comps != null) {
            for (int i = 0; i < comps.length; ++i) {
                ImageNode n;
                Object ho;
                Component c = comps[i];
                if (!(c instanceof ImageNode) || !((ho = (n = (ImageNode)c).getHierarchyObject()) instanceof ImageData)) continue;
                this.visibleImages.add((ImageData)ho);
                this.visibleImageNodes.add(n);
            }
        }
    }
}

