/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.browser;

import java.awt.Cursor;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.dataBrowser.Colors;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.CellDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageFinder;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.RootDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.Layout;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.NodesFinder;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.ResetNodesVisitor;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.DataObject;
import pojos.ImageData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BrowserModel
extends AbstractComponent
implements Browser {
    private boolean mouseOver;
    private boolean rollOver;
    private boolean thumbSelected;
    private Point popupPoint;
    private RootDisplay rootDisplay;
    private Layout selectedLayout;
    private boolean multiSelection;
    private Set<ImageDisplay> selectedDisplays;
    private boolean titleBarVisible;
    private ImageDisplay rollOverNode;
    private Set<ImageDisplay> originalNodes;

    private void addToDesktop(ImageDisplay node) {
        if (node instanceof ImageNode) {
            return;
        }
        JComponent desktop = node.getInternalDesktop();
        Set children = node.getChildrenDisplay();
        if (children == null) {
            return;
        }
        for (ImageDisplay child : children) {
            if (!node.containsImages()) {
                this.addToDesktop(child);
                continue;
            }
            desktop.add(child);
        }
    }

    BrowserModel(RootDisplay view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.rootDisplay = view;
        this.selectedDisplays = new HashSet<ImageDisplay>();
        this.originalNodes = new HashSet<ImageDisplay>();
        this.titleBarVisible = true;
        Set nodes = this.rootDisplay.getChildrenDisplay();
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            this.originalNodes.add((ImageDisplay)i.next());
        }
    }

    void onNodeSelected(ImageDisplay newNode, Set nodes) {
        if (newNode == null) {
            return;
        }
        this.rootDisplay.setTitle(this.currentPathString(newNode));
        ArrayList<ImageDisplay> selected = new ArrayList<ImageDisplay>();
        selected.add(newNode);
        if (this.isMultiSelection() || nodes == null) {
            this.setNodesColor(selected, null);
        } else {
            this.setNodesColor(selected, nodes);
        }
    }

    void setSelectedDisplay(ImageDisplay node, boolean multiSelection, boolean fireProperty) {
        if (node instanceof CellDisplay) {
            return;
        }
        this.thumbSelected = false;
        this.popupPoint = null;
        this.multiSelection = multiSelection;
        HashSet<ImageDisplay> oldValue = new HashSet<ImageDisplay>(this.selectedDisplays.size());
        Iterator<ImageDisplay> i = this.selectedDisplays.iterator();
        while (i.hasNext()) {
            oldValue.add(i.next());
        }
        if (!multiSelection) {
            this.selectedDisplays.clear();
        }
        if (node != null) {
            this.selectedDisplays.add(node);
        }
        if (fireProperty) {
            this.onNodeSelected(node, oldValue);
            this.firePropertyChange("selectedDataBrowserNodeDisplay", oldValue, node);
        } else if (multiSelection) {
            Colors colors = Colors.getInstance();
            node.setHighlight(colors.getSelectedHighLight(node));
        } else {
            this.onNodeSelected(node, oldValue);
        }
    }

    String currentPathString(ImageDisplay parent) {
        StringBuffer buf = new StringBuffer();
        String title = "";
        while (parent != null && !(parent instanceof RootDisplay)) {
            if (parent instanceof CellDisplay) {
                int type = ((CellDisplay)parent).getType();
                title = type == 1 ? "column: " + parent.getTitle() : "row: " + parent.getTitle();
            } else if (parent instanceof WellImageSet) {
                WellImageSet wiNode = (WellImageSet)parent;
                title = "Well: " + wiNode.getRowDisplay();
                title = title + "-" + wiNode.getColumnDisplay();
            } else {
                title = parent.getTitle();
                if (title == null || title.length() == 0) {
                    title = "[..]";
                }
                if (parent instanceof ImageSet) {
                    buf.insert(0, " > ");
                }
            }
            buf.insert(0, title);
            parent = parent.getParentDisplay();
        }
        return buf.toString();
    }

    void setNodeForProperty(String propName, Object node) {
        this.firePropertyChange(propName, null, node);
    }

    void setRollOverNode(ImageNode newNode) {
        ImageDisplay previousNode = this.rollOverNode;
        this.rollOverNode = newNode;
        this.firePropertyChange("rollOver", previousNode, newNode);
    }

    void setNodesColor(Collection toSelect, Collection toDeselect) {
        Colors colors = Colors.getInstance();
        for (ImageDisplay node : toSelect) {
            node.setHighlight(colors.getSelectedHighLight(node));
        }
        if (toDeselect == null) {
            return;
        }
        for (ImageDisplay node : toDeselect) {
            if (node == null || toSelect.contains(node)) continue;
            node.setHighlight(colors.getDeselectedHighLight(node));
        }
    }

    @Override
    public Set getRootNodes() {
        return this.rootDisplay.getChildrenDisplay();
    }

    @Override
    public Collection getSelectedDisplays() {
        return this.selectedDisplays;
    }

    @Override
    public Collection getSelectedDataObjects() {
        if (this.selectedDisplays == null) {
            return null;
        }
        Iterator<ImageDisplay> i = this.selectedDisplays.iterator();
        ArrayList<DataObject> nodes = new ArrayList<DataObject>();
        while (i.hasNext()) {
            ImageDisplay o = i.next();
            Object ho = o.getHierarchyObject();
            if (!(ho instanceof DataObject)) continue;
            nodes.add((DataObject)ho);
        }
        return nodes;
    }

    @Override
    public ImageDisplay getLastSelectedDisplay() {
        Iterator<ImageDisplay> i = this.selectedDisplays.iterator();
        int index = 0;
        while (i.hasNext()) {
            if (index == this.selectedDisplays.size() - 1) {
                return i.next();
            }
            ++index;
        }
        return null;
    }

    @Override
    public void setThumbSelected(boolean selected, ImageNode node) {
        if (node == null) {
            throw new IllegalArgumentException("No node");
        }
        if (!selected) {
            return;
        }
        this.popupPoint = null;
        this.thumbSelected = selected;
        this.firePropertyChange("thumbSelected", null, node);
    }

    @Override
    public boolean isThumbSelected() {
        return this.thumbSelected;
    }

    @Override
    public void setPopupPoint(Point p) {
        this.thumbSelected = false;
        Point oldValue = this.popupPoint;
        this.popupPoint = p;
        this.firePropertyChange("popupPoint", oldValue, p);
    }

    @Override
    public Point getPopupPoint() {
        return this.popupPoint;
    }

    @Override
    public Set<ImageData> getImages() {
        ImageFinder finder = new ImageFinder();
        this.accept(finder, 0);
        return finder.getImages();
    }

    @Override
    public Set getImageNodes() {
        ImageFinder finder = new ImageFinder();
        this.accept(finder, 0);
        return finder.getImageNodes();
    }

    @Override
    public void accept(ImageDisplayVisitor visitor) {
        this.rootDisplay.accept(visitor, 2);
    }

    @Override
    public void accept(ImageDisplayVisitor visitor, int algoType) {
        this.rootDisplay.accept(visitor, algoType);
    }

    @Override
    public JComponent getUI() {
        return this.rootDisplay;
    }

    @Override
    public void setSelectedLayout(Layout layout) {
        if (layout == null) {
            return;
        }
        Layout oldLayout = this.selectedLayout;
        switch (layout.getIndex()) {
            case 1: 
            case 2: 
            case 3: {
                this.selectedLayout = layout;
            }
        }
        this.firePropertyChange("layout", oldLayout, this.selectedLayout);
    }

    @Override
    public Layout getSelectedLayout() {
        return this.selectedLayout;
    }

    @Override
    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    @Override
    public boolean isTitleBarVisible() {
        return this.titleBarVisible;
    }

    @Override
    public void setTitleBarVisible(boolean b) {
        this.titleBarVisible = b;
    }

    @Override
    public void setRollOver(boolean rollOver) {
        this.setRollOverNode(null);
        this.rollOver = rollOver;
    }

    @Override
    public boolean isRollOver() {
        return this.rollOver;
    }

    @Override
    public boolean isMouseOver() {
        return this.mouseOver;
    }

    @Override
    public void setMouseOver(boolean b) {
        this.mouseOver = b;
    }

    @Override
    public void resetChildDisplay() {
        this.rootDisplay.setCursor(Cursor.getPredefinedCursor(3));
        Set rootChildren = this.rootDisplay.getChildrenDisplay();
        JComponent desktop = this.rootDisplay.getInternalDesktop();
        desktop.removeAll();
        switch (this.selectedLayout.getIndex()) {
            case 1: {
                for (ImageDisplay child : rootChildren) {
                    desktop.add(child);
                    this.addToDesktop(child);
                }
                break;
            }
            case 2: {
                Iterator i = this.getImageNodes().iterator();
                while (i.hasNext()) {
                    desktop.add((ImageDisplay)i.next());
                }
                break;
            }
        }
        this.rootDisplay.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void setSelectedNodes(List<DataObject> nodes) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        NodesFinder finder = new NodesFinder(nodes);
        this.rootDisplay.accept(finder);
        List<ImageDisplay> found = finder.getFoundNodes();
        this.setNodesColor(found, this.getSelectedDisplays());
        boolean b = found.size() > 1;
        Iterator<ImageDisplay> i = found.iterator();
        ImageDisplay node = null;
        while (i.hasNext()) {
            node = i.next();
            this.setSelectedDisplay(node, b, false);
        }
    }

    @Override
    public void setFilterNodes(Collection<ImageDisplay> nodes) {
        ResetNodesVisitor visitor = new ResetNodesVisitor(nodes, true);
        this.rootDisplay.accept(visitor, 1);
    }

    @Override
    public void showAll() {
        this.setFilterNodes(this.getImageNodes());
    }

    @Override
    public Set<DataObject> getOriginal() {
        HashSet<DataObject> nodes = new HashSet<DataObject>();
        Iterator<ImageDisplay> i = this.originalNodes.iterator();
        while (i.hasNext()) {
            Object ho = i.next().getHierarchyObject();
            if (!(ho instanceof DataObject)) continue;
            nodes.add((DataObject)ho);
        }
        return nodes;
    }

    @Override
    public Set<ImageData> getVisibleImages() {
        ImageFinder finder = new ImageFinder();
        this.accept(finder, 1);
        return finder.getVisibleImages();
    }

    @Override
    public List<ImageNode> getVisibleImageNodes() {
        ImageFinder finder = new ImageFinder();
        this.accept(finder, 1);
        return finder.getVisibleImageNodes();
    }

    @Override
    public void setNodesSelection(List<ImageDisplay> nodes) {
        boolean multiSelection;
        if (nodes == null) {
            return;
        }
        this.setNodesColor(nodes, this.getSelectedDisplays());
        Iterator<ImageDisplay> i = nodes.iterator();
        boolean bl = multiSelection = nodes.size() > 1;
        while (i.hasNext()) {
            this.setSelectedDisplay(i.next(), multiSelection, true);
        }
    }

    @Override
    public void removeSelectedDisplay(ImageDisplay node) {
        if (node == null) {
            return;
        }
        Colors colors = Colors.getInstance();
        node.setHighlight(colors.getDeselectedHighLight(node));
        this.selectedDisplays.remove(node);
        this.firePropertyChange("unselectedDataBrowserNodeDisplay", null, node);
    }

    @Override
    public void viewDisplay(ImageDisplay node) {
        if (node == null) {
            return;
        }
        if (node instanceof ImageNode) {
            EventBus bus = DataBrowserAgent.getRegistry().getEventBus();
            Object uo = node.getHierarchyObject();
            if (uo instanceof ImageData) {
                bus.post(new ViewImage((ImageData)uo, null));
            } else if (uo instanceof WellSampleData) {
                bus.post(new ViewImage(((WellSampleData)uo).getImage(), null));
            }
        }
    }

    @Override
    public void setComponentTitle(String title) {
        this.rootDisplay.setTitle(title);
    }

    @Override
    public void refresh(Collection<ImageDisplay> nodes) {
        this.rootDisplay.removeAllChildrenDisplay();
        if (nodes == null) {
            return;
        }
        Iterator<ImageDisplay> i = nodes.iterator();
        while (i.hasNext()) {
            this.rootDisplay.addChildDisplay(i.next());
        }
    }

    @Override
    public void markUnmodifiedNodes(Class type, Collection<Long> ids) {
        Iterator<ImageDisplay> i = this.selectedDisplays.iterator();
        Colors colors = Colors.getInstance();
        while (i.hasNext()) {
            long id;
            ImageDisplay node = i.next();
            Object ho = node.getHierarchyObject();
            if (!ho.getClass().equals(type) || !(ho instanceof DataObject) || !ids.contains(id = ((DataObject)ho).getId())) continue;
            node.setHighlight(colors.getUnmodifiedHighLight(node));
        }
    }
}

