/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.browser;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.dataBrowser.Colors;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.RootDisplay;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import pojos.ImageData;

public class BrowserControl
implements MouseListener,
ImageDisplayVisitor,
PropertyChangeListener {
    private BrowserModel model;
    private RootDisplay view;
    private boolean popupTrigger;

    private ImageDisplay findParentDisplay(Object x) {
        while (true) {
            if (x instanceof ImageDisplay) {
                return (ImageDisplay)x;
            }
            if (!(x instanceof JComponent)) break;
            x = ((JComponent)x).getParent();
        }
        return null;
    }

    boolean isSelectionValid(ImageDisplay node) {
        if (!(node instanceof ImageNode)) {
            return true;
        }
        Object ho = node.getHierarchyObject();
        if (!(ho instanceof ImageData)) {
            return true;
        }
        ImageData img = (ImageData)ho;
        try {
            img.getDefaultPixels();
            return true;
        }
        catch (Exception e) {
            UserNotifier un = DataBrowserAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Image Not valid", "The selected image is not valid");
            node.setHighlight(Colors.getInstance().getDeselectedHighLight(node));
            return false;
        }
    }

    BrowserControl(BrowserModel model, RootDisplay view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        model.addPropertyChangeListener("selectedDataBrowserNodeDisplay", this);
        model.addPropertyChangeListener("rollOver", this);
        this.model = model;
        this.view = view;
        this.popupTrigger = false;
    }

    void initialize() {
        this.model.accept(this);
    }

    public void visit(ImageNode node) {
        node.addMouseListenerToComponents(this);
        node.addPropertyChangeListener("pinThumbnail", this);
    }

    public void visit(ImageSet node) {
        node.getTitleBar().addMouseListener(this);
        node.getInternalDesktop().addMouseListener(this);
        node.addPropertyChangeListener("endMoving", this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("classifyNode".equals(name)) {
            this.model.setNodeForProperty("classifiedNode", evt.getNewValue());
        } else if ("annotateNode".equals(name)) {
            this.model.setNodeForProperty("annotatedNode", evt.getNewValue());
        } else if ("rollOver".equals(name)) {
            ImageDisplay newNode = (ImageDisplay)evt.getNewValue();
            this.view.setTitle(this.model.currentPathString(newNode));
        } else if ("pinThumbnail".equals(name)) {
            ImageNode node = (ImageNode)evt.getNewValue();
            this.model.setThumbSelected(true, node);
        } else if ("endMoving".equals(name)) {
            // empty if block
        }
    }

    public void mousePressed(MouseEvent me) {
        boolean b;
        ImageDisplay d = this.findParentDisplay(me.getSource());
        d.moveToFront();
        ImageDisplay previousDisplay = this.model.getLastSelectedDisplay();
        boolean bl = b = me.isControlDown() || me.isMetaDown();
        if (me.isPopupTrigger()) {
            this.popupTrigger = true;
            return;
        }
        if (b) {
            ImageDisplay previous = this.model.getLastSelectedDisplay();
            if (previous == null) {
                return;
            }
            Object object = previous.getHierarchyObject();
            Class<?> ref = object.getClass();
            if (!ref.equals(d.getHierarchyObject().getClass())) {
                return;
            }
            Collection nodes = this.model.getSelectedDisplays();
            Iterator i = nodes.iterator();
            boolean remove = false;
            while (i.hasNext()) {
                ImageDisplay node = (ImageDisplay)i.next();
                if (!node.equals(d)) continue;
                remove = true;
                break;
            }
            if (remove) {
                this.model.removeSelectedDisplay(d);
            } else {
                this.model.setSelectedDisplay(d, true, true);
            }
        } else if (!d.equals(previousDisplay) && this.isSelectionValid(d)) {
            this.model.setSelectedDisplay(d, false, true);
        }
        if (me.isPopupTrigger()) {
            this.popupTrigger = true;
        }
    }

    public void mouseReleased(MouseEvent me) {
        if (this.popupTrigger || me.isPopupTrigger()) {
            this.model.setPopupPoint(me.getPoint());
        } else {
            Object src = me.getSource();
            ImageDisplay d = this.findParentDisplay(src);
            if (d instanceof ImageNode && d.getTitleBar() != src && me.getClickCount() == 2 && this.isSelectionValid(d)) {
                this.model.viewDisplay(d);
            }
        }
        this.popupTrigger = false;
    }

    public void mouseEntered(MouseEvent me) {
        boolean mo = this.model.isMouseOver();
        boolean ro = this.model.isRollOver();
        if (!mo && !ro) {
            return;
        }
        Object src = me.getSource();
        ImageDisplay d = this.findParentDisplay(src);
        if (mo) {
            if (d instanceof RootDisplay) {
                ImageDisplay lastSelected = this.model.getLastSelectedDisplay();
                if (lastSelected != null) {
                    this.view.setTitle(this.model.currentPathString(lastSelected));
                } else {
                    lastSelected = null;
                }
                this.model.setNodeForProperty("mouseOver", lastSelected);
                return;
            }
            if (!(d instanceof RootDisplay)) {
                this.view.setTitle(this.model.currentPathString(d));
            }
            this.model.setNodeForProperty("mouseOver", d);
        }
        if (!ro) {
            return;
        }
        if (d instanceof ImageNode && d.getTitleBar() != src) {
            this.model.setRollOverNode((ImageNode)d);
        } else {
            this.model.setRollOverNode(null);
        }
    }

    public void mouseExited(MouseEvent me) {
        this.model.setRollOverNode(null);
    }

    public void mouseClicked(MouseEvent me) {
    }
}

