/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.DataBrowserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ImageData;

public class ManageRndSettingsAction
extends DataBrowserAction
implements PropertyChangeListener {
    public static final int COPY = 0;
    public static final int PASTE = 1;
    public static final int RESET = 2;
    public static final int SET_ORIGINAL = 3;
    private static final String NAME_COPY = "Copy Settings";
    private static final String DESCRIPTION_COPY = "Copy the rendering settings.";
    private static final String NAME_PASTE = "Paste Settings";
    private static final String DESCRIPTION_PASTE = "Paste the rendering settings.";
    private static final String NAME_RESET = "Reset Settings";
    private static final String DESCRIPTION_RESET = "Reset the rendering settings.";
    private static final String NAME_SET_ORIGINAL = "Set Original Settings";
    private static final String DESCRIPTION_SET_ORIGINAL = "Set the original rendering settings.";
    private IconManager icons;
    private int index;

    private void checkIndex(int value) {
        switch (value) {
            case 0: {
                this.putValue("Name", NAME_COPY);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY));
                this.putValue("SmallIcon", this.icons.getIcon(27));
                break;
            }
            case 1: {
                this.putValue("Name", NAME_PASTE);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE));
                this.putValue("SmallIcon", this.icons.getIcon(28));
                break;
            }
            case 2: {
                this.putValue("Name", NAME_RESET);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_RESET));
                this.putValue("SmallIcon", this.icons.getIcon(32));
                break;
            }
            case 3: {
                this.putValue("Name", NAME_SET_ORIGINAL);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SET_ORIGINAL));
                this.putValue("SmallIcon", this.icons.getIcon(33));
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    protected void onStateChange() {
        Browser browser = this.model.getBrowser();
        if (browser != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }

    protected void onDisplayChange(ImageDisplay node) {
        Browser browser = this.model.getBrowser();
        if (node == null || browser == null) {
            this.setEnabled(false);
            return;
        }
        Collection nodes = browser.getSelectedDisplays();
        Object ho = node.getHierarchyObject();
        switch (this.index) {
            case 0: {
                if (nodes.size() > 1) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(ho instanceof ImageData);
                break;
            }
            case 1: {
                if (!this.model.hasRndSettings()) {
                    this.setEnabled(false);
                    return;
                }
                if (!(ho instanceof ImageData) && !(ho instanceof DatasetData)) {
                    this.setEnabled(false);
                    break;
                }
                if (nodes.size() > 1) {
                    this.setEnabled(ho instanceof ImageData);
                    break;
                }
                this.setEnabled(true);
                break;
            }
            case 2: {
                if (!(ho instanceof ImageData) && !(ho instanceof DatasetData)) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(true);
                break;
            }
            case 3: {
                if (!(ho instanceof ImageData) && !(ho instanceof DatasetData)) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(true);
            }
        }
    }

    public ManageRndSettingsAction(DataBrowser model, int index) {
        super(model);
        this.setEnabled(false);
        this.icons = IconManager.getInstance();
        this.checkIndex(index);
        this.index = index;
        model.addPropertyChangeListener("copyItems", this);
        model.addPropertyChangeListener("rndSettingToCopy", this);
    }

    public void actionPerformed(ActionEvent e) {
        switch (this.index) {
            case 0: {
                this.model.copyRndSettings();
                break;
            }
            case 1: {
                this.model.pasteRndSettings();
                break;
            }
            case 2: {
                this.model.resetRndSettings();
                break;
            }
            case 3: {
                this.model.setOriginalSettings();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Browser browser;
        String name = evt.getPropertyName();
        if (("copyItems".equals(name) || "rndSettingToCopy".equals(name) || "selectedDataBrowserNodeDisplay".equals(name)) && (browser = this.model.getBrowser()) != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }
}

