/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.DataBrowserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;

public class ManageObjectAction
extends DataBrowserAction
implements PropertyChangeListener {
    public static final int COPY = 0;
    public static final int PASTE = 1;
    public static final int REMOVE = 2;
    public static final int CUT = 3;
    private static final String NAME_COPY = "Copy";
    private static final String DESCRIPTION_COPY = "Copy the selected elements.";
    private static final String NAME_PASTE = "Paste";
    private static final String DESCRIPTION_PASTE = "Paste the selected elements.";
    private static final String NAME_REMOVE = "Delete";
    private static final String DESCRIPTION_REMOVE = "Delete the selected elements.";
    private static final String NAME_CUT = "Cut";
    private static final String DESCRIPTION_CUT = "Cut the selected elements.";
    private int index;
    private IconManager icons;

    private void checkIndex(int value) {
        switch (value) {
            case 0: {
                this.putValue("Name", NAME_COPY);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY));
                this.putValue("SmallIcon", this.icons.getIcon(27));
                break;
            }
            case 1: {
                this.putValue("Name", NAME_PASTE);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE));
                this.putValue("SmallIcon", this.icons.getIcon(28));
                break;
            }
            case 2: {
                this.putValue("Name", NAME_REMOVE);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_REMOVE));
                this.putValue("SmallIcon", this.icons.getIcon(29));
                break;
            }
            case 3: {
                this.putValue("Name", NAME_CUT);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CUT));
                this.putValue("SmallIcon", this.icons.getIcon(31));
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    protected void onStateChange() {
        Browser browser = this.model.getBrowser();
        if (browser != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }

    protected void onDisplayChange(ImageDisplay node) {
        if (node == null) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getBrowser();
        if (browser == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = node.getHierarchyObject();
        Class klass = this.model.hasDataToCopy();
        switch (this.index) {
            case 0: {
                if (ho instanceof DatasetData || ho instanceof ImageData || ho instanceof PlateData) {
                    this.setEnabled(this.model.isObjectWritable(ho));
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 1: {
                if (klass == null) {
                    this.setEnabled(false);
                    return;
                }
                if (ho instanceof ProjectData) {
                    if (DatasetData.class.equals((Object)klass)) {
                        this.setEnabled(this.model.isObjectWritable(ho));
                        break;
                    }
                    this.setEnabled(false);
                    break;
                }
                if (ho instanceof ScreenData) {
                    if (PlateData.class.equals((Object)klass)) {
                        this.setEnabled(this.model.isObjectWritable(ho));
                        break;
                    }
                    this.setEnabled(false);
                    break;
                }
                if (ho instanceof DatasetData) {
                    if (ImageData.class.equals((Object)klass)) {
                        this.setEnabled(this.model.isObjectWritable(ho));
                        break;
                    }
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 2: {
                if (ho instanceof ProjectData || ho instanceof DatasetData || ho instanceof ImageData || ho instanceof ScreenData || ho instanceof PlateData) {
                    this.setEnabled(this.model.isObjectWritable(ho));
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 3: {
                if (ho instanceof DatasetData || ho instanceof ImageData || ho instanceof PlateData) {
                    this.setEnabled(this.model.isObjectWritable(ho));
                    break;
                }
                this.setEnabled(false);
            }
        }
    }

    public ManageObjectAction(DataBrowser model, int index) {
        super(model);
        this.setEnabled(false);
        this.icons = IconManager.getInstance();
        this.checkIndex(index);
        this.index = index;
    }

    public void actionPerformed(ActionEvent e) {
        switch (this.index) {
            case 0: {
                this.model.copy();
                break;
            }
            case 1: {
                this.model.paste();
                break;
            }
            case 2: {
                this.model.remove();
                break;
            }
            case 3: {
                this.model.cut();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Browser browser;
        String name = evt.getPropertyName();
        if (("copyRndSettings".equals(name) || "itemsToCopy".equals(name) || "selectedDataBrowserNodeDisplay".equals(name)) && (browser = this.model.getBrowser()) != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }
}

