/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailProvider;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellImageSet;
import pojos.ImageData;

public class ThumbnailsManager {
    private int totalIDs;
    private Set<Long> processedIDs;
    private Map<Long, Set> thumbProviders;

    public ThumbnailsManager(Collection nodes, int totalIDs) {
        if (nodes == null) {
            throw new NullPointerException("No image nodes.");
        }
        this.totalIDs = totalIDs;
        this.processedIDs = new HashSet<Long>();
        this.thumbProviders = new HashMap<Long, Set>();
        Iterator i = nodes.iterator();
        ImageData is = null;
        Thumbnail thumb = null;
        while (i.hasNext()) {
            ImageDisplay node = (ImageDisplay)i.next();
            if (node instanceof WellImageSet) {
                is = ((WellImageSet)node).getSelectedImage();
                thumb = ((WellImageSet)node).getSelectedWellSample().getThumbnail();
            } else if (node instanceof ImageNode) {
                is = (ImageData)node.getHierarchyObject();
                thumb = ((ImageNode)node).getThumbnail();
            }
            if (is == null) continue;
            Long id = is.getId();
            HashSet<Thumbnail> providers = this.thumbProviders.get(id);
            if (providers == null) {
                providers = new HashSet<Thumbnail>();
                this.thumbProviders.put(id, providers);
            }
            providers.add(thumb);
        }
    }

    public void setThumbnail(long imageID, BufferedImage thumb) {
        if (thumb == null) {
            throw new NullPointerException("No thumbnail.");
        }
        Long id = imageID;
        Set providers = this.thumbProviders.get(id);
        if (providers != null) {
            Iterator p = providers.iterator();
            while (p.hasNext()) {
                ((ThumbnailProvider)p.next()).setFullScaleThumb(thumb);
            }
            this.processedIDs.add(id);
        }
    }

    public void setFullSizeImage(long imageID, BufferedImage thumb) {
        if (thumb == null) {
            throw new NullPointerException("No thumbnail.");
        }
        Long id = imageID;
        Set providers = this.thumbProviders.get(id);
        if (providers != null) {
            Iterator p = providers.iterator();
            while (p.hasNext()) {
                ((ThumbnailProvider)p.next()).setFullSizeImage(thumb);
            }
            this.processedIDs.add(id);
        }
    }

    public boolean isDone() {
        return this.processedIDs.size() == this.totalIDs;
    }
}

