/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.util.Collection;
import java.util.List;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailLoader
extends DataBrowserLoader {
    private int max;
    private Collection<ImageData> images;
    private boolean thumbnail;
    private CallHandle handle;

    public ThumbnailLoader(DataBrowser viewer, Collection<ImageData> images) {
        this(viewer, images, true);
    }

    public ThumbnailLoader(DataBrowser viewer, Collection<ImageData> images, boolean thumbnail) {
        super(viewer);
        if (images == null) {
            throw new IllegalArgumentException("Collection shouldn't be null.");
        }
        this.images = images;
        this.thumbnail = thumbnail;
        this.max = images.size();
    }

    @Override
    public void load() {
        long userID = DataBrowserAgent.getUserDetails().getId();
        this.handle = this.thumbnail ? this.hiBrwView.loadThumbnails(this.images, 96, 96, userID, this) : this.hiBrwView.loadThumbnails(this.images, 288, 288, userID, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        block7: {
            int percDone;
            String status;
            block6: {
                if (this.viewer.getState() == 5) {
                    return;
                }
                status = fe.getStatus();
                percDone = fe.getPercentDone();
                if (!this.thumbnail) break block6;
                if (status == null) {
                    status = percDone == 100 ? "Done" : "";
                }
                this.viewer.setStatus(status, percDone);
                List l = (List)fe.getPartialResult();
                if (l == null) break block7;
                for (ThumbnailData td : l) {
                    this.viewer.setThumbnail(td.getImageID(), td.getThumbnail(), this.max);
                }
                break block7;
            }
            if (status == null) {
                status = percDone == 100 ? "Done" : "";
            }
            this.viewer.setSlideViewStatus(status, percDone);
            List l = (List)fe.getPartialResult();
            if (l != null) {
                for (ThumbnailData td : l) {
                    this.viewer.setSlideViewImage(td.getImageID(), td.getThumbnail());
                }
            }
        }
    }

    @Override
    public void handleNullResult() {
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "Thumbnail Retrieval Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("Thumbnail Retrieval Failure", s, exc);
    }
}

