/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.DataHandlerView;
import org.openmicroscopy.shoola.env.data.views.HierarchyBrowsingView;
import org.openmicroscopy.shoola.env.data.views.MetadataHandlerView;
import org.openmicroscopy.shoola.env.log.LogMessage;

public abstract class DataBrowserLoader
extends DSCallAdapter {
    protected final DataBrowser viewer;
    protected final Registry registry;
    protected final HierarchyBrowsingView hiBrwView;
    protected final DataHandlerView dhView;
    protected final MetadataHandlerView mhView;

    protected DataBrowserLoader(DataBrowser viewer) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        this.viewer = viewer;
        this.registry = DataBrowserAgent.getRegistry();
        this.hiBrwView = (HierarchyBrowsingView)this.registry.getDataServicesView(HierarchyBrowsingView.class);
        this.dhView = (DataHandlerView)this.registry.getDataServicesView(DataHandlerView.class);
        this.mhView = (MetadataHandlerView)this.registry.getDataServicesView(MetadataHandlerView.class);
    }

    public void onEnd() {
        this.viewer.setStatus(null, -1);
    }

    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
        this.registry.getUserNotifier().notifyInfo("Data Retrieval Cancellation", info);
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
    }

    public abstract void load();

    public abstract void cancel();
}

