/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserFactory;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsCopied;
import org.openmicroscopy.shoola.agents.events.treeviewer.CopyItems;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import pojos.ExperimenterData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBrowserAgent
implements Agent,
AgentEventListener {
    private static Registry registry;

    public static Registry getRegistry() {
        return registry;
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)registry.lookup("/current_user/details");
    }

    public static ExperimenterData getExperimenter(long expID) {
        List l = (List)registry.lookup("/users/details");
        if (l == null) {
            return null;
        }
        for (ExperimenterData exp : l) {
            if (exp.getId() != expID) continue;
            return exp;
        }
        return null;
    }

    private void handleRndSettingsCopied(RndSettingsCopied evt) {
        Collection ids = evt.getPixelsIDs();
        DataBrowserFactory.refreshThumbnails(ids);
    }

    private void handleCopyRndSettings(CopyRndSettings evt) {
        DataBrowserFactory.setRndSettingsToCopy(evt.getImage() != null);
    }

    private void handleCopyItems(CopyItems evt) {
        DataBrowserFactory.setDataToCopy(evt.getType());
    }

    @Override
    public void activate() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = registry.getEventBus();
        bus.register((AgentEventListener)this, RndSettingsCopied.class);
        bus.register((AgentEventListener)this, CopyRndSettings.class);
        bus.register((AgentEventListener)this, CopyItems.class);
    }

    @Override
    public boolean canTerminate() {
        return true;
    }

    @Override
    public Map<String, Set> hasDataToSave() {
        return null;
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof RndSettingsCopied) {
            this.handleRndSettingsCopied((RndSettingsCopied)e);
        } else if (e instanceof CopyRndSettings) {
            this.handleCopyRndSettings((CopyRndSettings)e);
        } else if (e instanceof CopyItems) {
            this.handleCopyItems((CopyItems)e);
        }
    }
}

