/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.DataObject;
import pojos.TextualAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentsFilter
extends DataBrowserLoader {
    private List<Long> nodeIds;
    private Map<Long, DataObject> nodes;
    private Class nodeType;
    private List<String> comments;
    private CallHandle handle;

    public CommentsFilter(DataBrowser viewer, List<String> comments, Collection<DataObject> nodes) {
        super(viewer);
        if (nodes == null || nodes.size() == 0) {
            throw new IllegalArgumentException("No nodes to filter.");
        }
        this.comments = comments;
        this.nodes = new HashMap<Long, DataObject>();
        this.nodeIds = new ArrayList<Long>();
        for (DataObject data : nodes) {
            this.nodeIds.add(data.getId());
            this.nodeType = data.getClass();
            this.nodes.put(data.getId(), data);
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void load() {
        long userID = DataBrowserAgent.getUserDetails().getId();
        this.handle = this.mhView.filterByAnnotation(this.nodeType, this.nodeIds, TextualAnnotationData.class, this.comments, userID, this);
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 5) {
            return;
        }
        Collection l = (Collection)result;
        ArrayList<DataObject> filteredNodes = new ArrayList<DataObject>();
        if (l == null) {
            this.viewer.setFilteredNodes(filteredNodes);
            return;
        }
        Iterator i = l.iterator();
        while (i.hasNext()) {
            long id = (Long)i.next();
            filteredNodes.add(this.nodes.get(id));
        }
        this.viewer.setFilteredNodes(filteredNodes);
    }
}

