/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.env.config.Registry;

public class Colors {
    public static final int TITLE_BAR_HIGHLIGHT = 0;
    public static final int TITLE_BAR = 1;
    public static final int TITLE_BAR_UNMODIFIED = 2;
    private static Colors singleton;
    private Map<Integer, Color> colorsMap;
    private Registry registry;

    private Colors(Registry registry) {
        if (registry == null) {
            throw new NullPointerException("No registry.");
        }
        this.registry = registry;
        this.colorsMap = new HashMap<Integer, Color>();
        this.initializeColors();
    }

    private void initializeColors() {
        Color c = (Color)this.registry.lookup("/resources/colors/TitleBarHighlight");
        this.colorsMap.put(0, c);
        c = (Color)this.registry.lookup("/resources/colors/TitleBar");
        this.colorsMap.put(1, c);
        c = (Color)this.registry.lookup("/resources/colors/TitleBarUnmodified");
        this.colorsMap.put(2, c);
    }

    public static Colors getInstance() {
        if (singleton == null) {
            singleton = new Colors(DataBrowserAgent.getRegistry());
        }
        return singleton;
    }

    public Color getColor(int id) {
        if (id < 0 || this.colorsMap.size() <= id) {
            this.registry.getLogger().error((Object)this, "color id out of range: " + id + ".");
            return null;
        }
        return this.colorsMap.get(id);
    }

    public Color getDeselectedHighLight(ImageDisplay node) {
        if (node == null) {
            return this.getColor(1);
        }
        if (node.getParentDisplay() == null) {
            return this.getColor(1);
        }
        Color c = node.getHighlight();
        if (c == null) {
            return null;
        }
        if (c.equals(this.getColor(0)) || c.equals(this.getColor(2))) {
            c = null;
        }
        return c;
    }

    public Color getSelectedHighLight(ImageDisplay node) {
        if (node == null) {
            return this.getColor(1);
        }
        if (node.getParentDisplay() == null) {
            return this.getColor(1);
        }
        Color c = node.getHighlight();
        if (c == null || c.equals(this.getColor(2))) {
            c = this.getColor(0);
        }
        return c;
    }

    public Color getUnmodifiedHighLight(ImageDisplay node) {
        if (node == null) {
            return this.getColor(1);
        }
        if (node.getParentDisplay() == null) {
            return this.getColor(1);
        }
        return this.getColor(2);
    }
}

