/*
 * Decompiled with CFR 0.152.
 */
package omerojava.util;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ome.util.ImageUtil;
import omero.ServerError;
import omero.model.Dataset;
import omero.model.DatasetI;
import omero.model.DatasetImageLink;
import omero.model.Image;
import omero.model.Pixels;
import omero.model.PixelsI;
import omero.model.Project;
import omero.model.ProjectDatasetLink;
import omero.model.ProjectI;
import omerojava.util.BytesConverter;
import omerojava.util.DoubleConverter;
import omerojava.util.FloatConverter;
import omerojava.util.IntConverter;
import omerojava.util.PixelTypes;
import omerojava.util.Plane2D;
import omerojava.util.ReadOnlyByteArray;
import omerojava.util.UintConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatewayUtils {
    static final String INT_8 = "int8";
    static final String UINT_8 = "uint8";
    static final String INT_16 = "int16";
    static final String UINT_16 = "uint16";
    static final String INT_32 = "int32";
    static final String UINT_32 = "uint32";
    static final String FLOAT = "float";
    static final String DOUBLE = "double";

    public static BufferedImage toBufferedImage(PixelsI pixels, int[] rawImage) {
        return ImageUtil.createBufferedImage(rawImage, pixels.getSizeX().getValue(), pixels.getSizeX().getValue());
    }

    public static Plane2D getPlane2D(PixelsI pixels, byte[] rawPlane) throws ServerError {
        String type = pixels.getPixelsType().getValue().getValue();
        int bytesPerPixels = GatewayUtils.getBytesPerPixels(type);
        BytesConverter strategy = GatewayUtils.getConverter(type);
        return GatewayUtils.createPlane(pixels, rawPlane, bytesPerPixels, strategy);
    }

    public static List<Dataset> getDatasetsFromProject(Project project) throws ServerError {
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        Iterator iterator = ((ProjectI)project).iterateDatasetLinks();
        while (iterator.hasNext()) {
            datasets.add(((ProjectDatasetLink)iterator.next()).getChild());
        }
        return datasets;
    }

    public static List<Pixels> getPixelsFromProject(Project project) throws ServerError {
        List<Image> images = GatewayUtils.getImagesFromProject(project);
        return GatewayUtils.getPixelsFromImageList(images);
    }

    public static List<Pixels> getPixelsFromImageList(List<Image> images) {
        ArrayList<Pixels> pixelsList = new ArrayList<Pixels>();
        for (Image image : images) {
            for (Pixels pixels : image.copyPixels()) {
                pixelsList.add(pixels);
            }
        }
        return pixelsList;
    }

    public static Map<Long, Pixels> getPixelsImageMap(List<Image> images) {
        TreeMap<Long, Pixels> pixelsList = new TreeMap<Long, Pixels>();
        for (Image image : images) {
            for (Pixels pixels : image.copyPixels()) {
                pixelsList.put(image.getId().getValue(), pixels);
            }
        }
        return pixelsList;
    }

    public static List<Pixels> getPixelsFromDataset(Dataset dataset) throws ServerError {
        List<Image> images = GatewayUtils.getImagesFromDataset(dataset);
        return GatewayUtils.getPixelsFromImageList(images);
    }

    public static List<Image> getImagesFromDataset(Dataset dataset) throws ServerError {
        ArrayList<Image> images = new ArrayList<Image>();
        Iterator iterator = ((DatasetI)dataset).iterateImageLinks();
        while (iterator.hasNext()) {
            images.add(((DatasetImageLink)iterator.next()).getChild());
        }
        return images;
    }

    public static List<Image> getImagesFromProject(Project project) throws ServerError {
        ArrayList<Image> images = new ArrayList<Image>();
        List<Dataset> datasets = GatewayUtils.getDatasetsFromProject(project);
        for (Dataset dataset : datasets) {
            List<Image> datasetImages = GatewayUtils.getImagesFromDataset(dataset);
            for (Image image : datasetImages) {
                images.add(image);
            }
        }
        return images;
    }

    private static int getBytesPerPixels(String v) {
        if (INT_8.equals(v) || UINT_8.equals(v)) {
            return 1;
        }
        if (INT_16.equals(v) || UINT_16.equals(v)) {
            return 2;
        }
        if (INT_32.equals(v) || UINT_32.equals(v) || FLOAT.equals(v)) {
            return 4;
        }
        if (DOUBLE.equals(v)) {
            return 8;
        }
        return -1;
    }

    private static Plane2D createPlane(PixelsI pixels, byte[] rawPlane, int bytesPerPixels, BytesConverter strategy) throws ServerError {
        ReadOnlyByteArray array = new ReadOnlyByteArray(rawPlane, 0, rawPlane.length);
        return new Plane2D(array, pixels.getSizeX().getValue(), pixels.getSizeY().getValue(), bytesPerPixels, strategy);
    }

    public static byte[] convertClientToServer(Pixels pixels, double[][] data) {
        String pixelsType = pixels.getPixelsType().getValue().getValue();
        int pixelsSize = GatewayUtils.getPixelsSize(pixelsType);
        int sizex = pixels.getSizeX().getValue();
        int sizey = pixels.getSizeY().getValue();
        byte[] rawbytes = new byte[sizex * sizey * pixelsSize];
        for (int x = 0; x < sizex; ++x) {
            for (int y = 0; y < sizey; ++y) {
                int offset = GatewayUtils.calcOffset(pixelsSize, sizex, x, y);
                byte[] newBytes = GatewayUtils.convertValue(pixelsType, data[x][y]);
                for (int offsetLength = 0; offsetLength < newBytes.length; ++offsetLength) {
                    rawbytes[offset + offsetLength] = newBytes[offsetLength];
                }
            }
        }
        return rawbytes;
    }

    private static int calcOffset(int pixelSize, int sizex, int x, int y) {
        return pixelSize * (y * sizex + x);
    }

    private static int getPixelsSize(String pixelsType) {
        return PixelTypes.pixelMap.get(pixelsType);
    }

    private static byte[] mapToByteArray(byte v) {
        ByteBuffer bb = ByteBuffer.allocate(1);
        bb.put(v);
        return bb.array();
    }

    private static byte[] mapToByteArray(short v) {
        ByteBuffer bb = ByteBuffer.allocate(2);
        bb.putShort(v);
        return bb.array();
    }

    private static byte[] mapToByteArray(int v) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(v);
        return bb.array();
    }

    private static byte[] mapToByteArray(float v) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putFloat(v);
        return bb.array();
    }

    private static byte[] mapToByteArray(double v) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putDouble(v);
        return bb.array();
    }

    private static byte[] convertValue(String pixelsType, Double val) {
        if (pixelsType.equals(INT_8) || pixelsType.equals(UINT_8)) {
            return GatewayUtils.mapToByteArray(val.byteValue());
        }
        if (pixelsType.equals(INT_16) || pixelsType.equals(UINT_16)) {
            return GatewayUtils.mapToByteArray(val.shortValue());
        }
        if (pixelsType.equals(INT_32) || pixelsType.equals(UINT_32)) {
            return GatewayUtils.mapToByteArray(val.intValue());
        }
        if (pixelsType.equals(FLOAT)) {
            return GatewayUtils.mapToByteArray(val.floatValue());
        }
        return GatewayUtils.mapToByteArray(val);
    }

    static BytesConverter getConverter(String pixelsType) {
        if (UINT_8.equals(pixelsType) || UINT_16.equals(pixelsType) || UINT_32.equals(pixelsType)) {
            return new UintConverter();
        }
        if (INT_8.equals(pixelsType) || INT_16.equals(pixelsType) || INT_32.equals(pixelsType)) {
            return new IntConverter();
        }
        if (FLOAT.equals(pixelsType)) {
            return new FloatConverter();
        }
        if (DOUBLE.equals(pixelsType)) {
            return new DoubleConverter();
        }
        return null;
    }
}

