/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.List;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RDouble;
import omero.RInt;
import omero.RLong;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.LightSettings;
import omero.model.LightSource;
import omero.model.MicrobeamManipulation;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightSettingsI
extends LightSettings
implements ModelBased {
    public static final String ATTENUATION = "ome.model.acquisition.LightSettings_attenuation";
    public static final String WAVELENGTH = "ome.model.acquisition.LightSettings_wavelength";
    public static final String LIGHTSOURCE = "ome.model.acquisition.LightSettings_lightSource";
    public static final String MICROBEAMMANIPULATION = "ome.model.acquisition.LightSettings_microbeamManipulation";
    public static final String DETAILS = "ome.model.acquisition.LightSettings_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
    }

    public LightSettingsI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public LightSettingsI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public LightSettingsI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadAttenuation();
        this.unloadWavelength();
        this.unloadLightSource();
        this.unloadMicrobeamManipulation();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        LightSettingsI copy = new LightSettingsI();
        copy.id = this.id;
        copy.version = this.version;
        copy.attenuation = this.attenuation;
        copy.wavelength = this.wavelength;
        copy.lightSource = this.lightSource == null ? null : (LightSource)this.lightSource.proxy();
        copy.microbeamManipulation = this.microbeamManipulation == null ? null : (MicrobeamManipulation)this.microbeamManipulation.proxy();
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new LightSettingsI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadAttenuation() {
        this.attenuation = null;
    }

    @Override
    public RDouble getAttenuation(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.attenuation;
    }

    @Override
    public void setAttenuation(RDouble attenuation, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.attenuation = attenuation;
    }

    private void copyAttenuation(ome.model.acquisition.LightSettings source, IceMapper mapper) {
        this.attenuation = source.getAttenuation() == null ? null : rtypes.rdouble(source.getAttenuation());
    }

    private void fillAttenuation(ome.model.acquisition.LightSettings target, IceMapper mapper) {
        try {
            target.setAttenuation((Double)mapper.fromRType(this.getAttenuation()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadWavelength() {
        this.wavelength = null;
    }

    @Override
    public RInt getWavelength(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.wavelength;
    }

    @Override
    public void setWavelength(RInt wavelength, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.wavelength = wavelength;
    }

    private void copyWavelength(ome.model.acquisition.LightSettings source, IceMapper mapper) {
        this.wavelength = source.getWavelength() == null ? null : rtypes.rint(source.getWavelength());
    }

    private void fillWavelength(ome.model.acquisition.LightSettings target, IceMapper mapper) {
        try {
            target.setWavelength((Integer)mapper.fromRType(this.getWavelength()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadLightSource() {
        this.lightSource = null;
    }

    @Override
    public LightSource getLightSource(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.lightSource;
    }

    @Override
    public void setLightSource(LightSource lightSource, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.lightSource = lightSource;
    }

    private void copyLightSource(ome.model.acquisition.LightSettings source, IceMapper mapper) {
        this.lightSource = (LightSource)mapper.findTarget(source.getLightSource());
    }

    private void fillLightSource(ome.model.acquisition.LightSettings target, IceMapper mapper) {
        target.putAt(LIGHTSOURCE, (Object)mapper.reverse((ModelBased)((Object)this.getLightSource())));
    }

    public void unloadMicrobeamManipulation() {
        this.microbeamManipulation = null;
    }

    @Override
    public MicrobeamManipulation getMicrobeamManipulation(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.microbeamManipulation;
    }

    @Override
    public void setMicrobeamManipulation(MicrobeamManipulation microbeamManipulation, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.microbeamManipulation = microbeamManipulation;
    }

    private void copyMicrobeamManipulation(ome.model.acquisition.LightSettings source, IceMapper mapper) {
        this.microbeamManipulation = (MicrobeamManipulation)mapper.findTarget(source.getMicrobeamManipulation());
    }

    private void fillMicrobeamManipulation(ome.model.acquisition.LightSettings target, IceMapper mapper) {
        target.putAt(MICROBEAMMANIPULATION, (Object)mapper.reverse((ModelBased)((Object)this.getMicrobeamManipulation())));
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.acquisition.LightSettings) {
            ome.model.acquisition.LightSettings source = (ome.model.acquisition.LightSettings)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyAttenuation(source, mapper);
                this.copyWavelength(source, mapper);
                this.copyLightSource(source, mapper);
                this.copyMicrobeamManipulation(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("LightSettings cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.acquisition.LightSettings target = new ome.model.acquisition.LightSettings();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillAttenuation(target, mapper);
            this.fillWavelength(target, mapper);
            this.fillLightSource(target, mapper);
            this.fillMicrobeamManipulation(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<LightSettingsI> cast(List list) {
        return list;
    }
}

