/*
 * Decompiled with CFR 0.152.
 */
package ome.util;

import java.io.Serializable;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.MappingException;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.type.Type;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.orm.hibernate3.TransactionAwareDataSourceConnectionProvider;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class TableIdGenerator
extends TableGenerator {
    private static final Log log = LogFactory.getLog(TableIdGenerator.class);
    long value;
    long hiValue = -1L;
    SimpleJdbcTemplate jdbc = null;
    TransactionTemplate tt;

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        super.configure(type, params, dialect);
    }

    protected void init(SessionImplementor session) {
        TransactionAwareDataSourceProxy tadsp;
        TransactionAwareDataSourceConnectionProvider tadscp;
        ConnectionProvider cp = session.getJDBCContext().getConnectionManager().getFactory().getConnectionProvider();
        if (this.jdbc != null && this.tt != null) {
            return;
        }
        DataSource ds = null;
        if (cp instanceof TransactionAwareDataSourceConnectionProvider && (ds = (tadscp = (TransactionAwareDataSourceConnectionProvider)cp).getDataSource()) instanceof TransactionAwareDataSourceProxy && (ds = (tadsp = (TransactionAwareDataSourceProxy)ds).getTargetDataSource()) instanceof LazyConnectionDataSourceProxy) {
            LazyConnectionDataSourceProxy lcdsp = (LazyConnectionDataSourceProxy)ds;
            ds = lcdsp.getTargetDataSource();
            this.jdbc = new SimpleJdbcTemplate(ds);
            this.tt = new TransactionTemplate(new DataSourceTransactionManager(ds));
        }
        if (this.jdbc == null) {
            throw new RuntimeException("Unexpected ConnectionProvider found. Last datasource = " + ds);
        }
    }

    public synchronized Serializable generate(SessionImplementor session, Object obj) {
        this.init(session);
        if (this.hiValue < 0L || this.value >= this.hiValue) {
            this.tt.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus status) {
                    TableIdGenerator.this.hiValue = TableIdGenerator.this.jdbc.queryForLong("select ome_nextval(?,?)", TableIdGenerator.this.getSegmentValue(), TableIdGenerator.this.getIncrementSize());
                    if (log.isDebugEnabled()) {
                        log.debug("Loaded new hiValue " + TableIdGenerator.this.hiValue + " for " + TableIdGenerator.this.getSegmentValue());
                    }
                    return null;
                }
            });
            this.value = this.hiValue - (long)this.getIncrementSize();
        }
        ++this.value;
        return Long.valueOf(this.value);
    }
}

