/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.AdapterAlreadyActiveException;
import Ice.AdapterNotFoundException;
import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.Endpoint;
import Ice.EndpointParseException;
import Ice.Identity;
import Ice.IllegalIdentityException;
import Ice.InitializationException;
import Ice.InvalidReplicaGroupIdException;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.LocatorRegistryPrx;
import Ice.NotRegisteredException;
import Ice.Object;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterIdInUseException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.ProcessPrxHelper;
import Ice.Properties;
import Ice.ProxyParseException;
import Ice.RouterPrx;
import Ice.RouterPrxHelper;
import Ice.ServantLocator;
import Ice.ServerNotFoundException;
import Ice.Util;
import IceInternal.EndpointI;
import IceInternal.IncomingConnectionFactory;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.ObjectAdapterFactory;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.ProcessI;
import IceInternal.PropertyNames;
import IceInternal.Reference;
import IceInternal.RouterInfo;
import IceInternal.ServantManager;
import IceInternal.ThreadPool;
import IceInternal.TraceLevels;
import IceUtilInternal.Assert;
import IceUtilInternal.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectAdapterI
implements ObjectAdapter {
    private static String[] _suffixes = new String[]{"AdapterId", "Endpoints", "Locator", "PublishedEndpoints", "RegisterProcess", "ReplicaGroupId", "Router", "ProxyOptions", "ThreadPool.Size", "ThreadPool.SizeMax", "ThreadPool.SizeWarn", "ThreadPool.StackSize", "ThreadPool.Serialize"};
    private boolean _deactivated = false;
    private Instance _instance;
    private Communicator _communicator;
    private ObjectAdapterFactory _objectAdapterFactory;
    private ThreadPool _threadPool;
    private ServantManager _servantManager;
    private boolean _activateOneOffDone;
    private final String _name;
    private final String _id;
    private final String _replicaGroupId;
    private Reference _reference;
    private List<IncomingConnectionFactory> _incomingConnectionFactories = new ArrayList<IncomingConnectionFactory>();
    private List<EndpointI> _routerEndpoints = new ArrayList<EndpointI>();
    private RouterInfo _routerInfo = null;
    private List<EndpointI> _publishedEndpoints = new ArrayList<EndpointI>();
    private LocatorInfo _locatorInfo;
    private int _directCount;
    private boolean _waitForActivate;
    private boolean _destroying;
    private boolean _destroyed;
    private boolean _noConfig;
    private Identity _processId = null;

    @Override
    public String getName() {
        return this._noConfig ? "" : this._name;
    }

    @Override
    public synchronized Communicator getCommunicator() {
        this.checkForDeactivation();
        return this._communicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate() {
        java.lang.Object properties;
        LocatorInfo locatorInfo = null;
        boolean registerProcess = false;
        boolean printAdapterReady = false;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            this.checkForDeactivation();
            if (this._activateOneOffDone) {
                int sz = this._incomingConnectionFactories.size();
                for (int i = 0; i < sz; ++i) {
                    IncomingConnectionFactory factory = this._incomingConnectionFactories.get(i);
                    factory.activate();
                }
                return;
            }
            this._waitForActivate = true;
            locatorInfo = this._locatorInfo;
            if (!this._noConfig) {
                properties = this._instance.initializationData().properties;
                registerProcess = properties.getPropertyAsInt(this._name + ".RegisterProcess") > 0;
                printAdapterReady = properties.getPropertyAsInt("Ice.PrintAdapterReady") > 0;
            }
        }
        try {
            Identity dummy = new Identity();
            dummy.name = "dummy";
            this.updateLocatorRegistry(locatorInfo, this.createDirectProxy(dummy), registerProcess);
        }
        catch (LocalException ex) {
            properties = this;
            synchronized (properties) {
                this._waitForActivate = false;
                this.notifyAll();
            }
            throw ex;
        }
        if (printAdapterReady) {
            System.out.println(this._name + " ready");
        }
        objectAdapterI = this;
        synchronized (objectAdapterI) {
            assert (!this._deactivated);
            this._waitForActivate = false;
            this.notifyAll();
            this._activateOneOffDone = true;
            int sz = this._incomingConnectionFactories.size();
            for (int i = 0; i < sz; ++i) {
                IncomingConnectionFactory factory = this._incomingConnectionFactories.get(i);
                factory.activate();
            }
        }
    }

    @Override
    public synchronized void hold() {
        this.checkForDeactivation();
        int sz = this._incomingConnectionFactories.size();
        for (int i = 0; i < sz; ++i) {
            IncomingConnectionFactory factory = this._incomingConnectionFactories.get(i);
            factory.hold();
        }
    }

    @Override
    public synchronized void waitForHold() {
        this.checkForDeactivation();
        int sz = this._incomingConnectionFactories.size();
        for (int i = 0; i < sz; ++i) {
            IncomingConnectionFactory factory = this._incomingConnectionFactories.get(i);
            factory.waitUntilHolding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate() {
        LocatorInfo locatorInfo;
        OutgoingConnectionFactory outgoingConnectionFactory;
        ArrayList<IncomingConnectionFactory> incomingConnectionFactories;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            if (this._deactivated) {
                return;
            }
            while (this._waitForActivate) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this._routerInfo != null) {
                this._instance.routerManager().erase(this._routerInfo.getRouter());
                this._routerInfo.setAdapter(null);
            }
            incomingConnectionFactories = new ArrayList<IncomingConnectionFactory>(this._incomingConnectionFactories);
            outgoingConnectionFactory = this._instance.outgoingConnectionFactory();
            locatorInfo = this._locatorInfo;
            this._deactivated = true;
            this.notifyAll();
        }
        try {
            this.updateLocatorRegistry(locatorInfo, null, false);
        }
        catch (LocalException ex) {
            // empty catch block
        }
        int sz = incomingConnectionFactories.size();
        for (int i = 0; i < sz; ++i) {
            IncomingConnectionFactory factory = (IncomingConnectionFactory)incomingConnectionFactories.get(i);
            factory.destroy();
        }
        outgoingConnectionFactory.removeAdapter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForDeactivate() {
        IncomingConnectionFactory[] incomingConnectionFactories;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            if (this._destroyed) {
                return;
            }
            while (!this._deactivated || this._directCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            incomingConnectionFactories = this._incomingConnectionFactories.toArray(new IncomingConnectionFactory[0]);
        }
        for (int i = 0; i < incomingConnectionFactories.length; ++i) {
            incomingConnectionFactories[i].waitUntilFinished();
        }
    }

    @Override
    public synchronized boolean isDeactivated() {
        return this._deactivated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ObjectAdapterFactory objectAdapterFactory;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            while (this._destroying) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this._destroyed) {
                return;
            }
            this._destroying = true;
        }
        this.deactivate();
        this.waitForDeactivate();
        this._servantManager.destroy();
        if (this._threadPool != null) {
            this._threadPool.destroy();
            this._threadPool.joinWithAllThreads();
        }
        ObjectAdapterI objectAdapterI2 = this;
        synchronized (objectAdapterI2) {
            this._destroying = false;
            this._destroyed = true;
            this.notifyAll();
            this._incomingConnectionFactories = null;
            this._instance = null;
            this._threadPool = null;
            this._communicator = null;
            this._routerEndpoints = null;
            this._routerInfo = null;
            this._publishedEndpoints = null;
            this._locatorInfo = null;
            this._reference = null;
            objectAdapterFactory = this._objectAdapterFactory;
            this._objectAdapterFactory = null;
        }
        if (objectAdapterFactory != null) {
            objectAdapterFactory.removeObjectAdapter(this._name);
        }
    }

    @Override
    public ObjectPrx add(Object object, Identity ident) {
        return this.addFacet(object, ident, "");
    }

    @Override
    public synchronized ObjectPrx addFacet(Object object, Identity ident, String facet) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        Identity id = new Identity();
        id.category = ident.category;
        id.name = ident.name;
        this._servantManager.addServant(object, id, facet);
        return this.newProxy(id, facet);
    }

    @Override
    public ObjectPrx addWithUUID(Object object) {
        return this.addFacetWithUUID(object, "");
    }

    @Override
    public ObjectPrx addFacetWithUUID(Object object, String facet) {
        Identity ident = new Identity();
        ident.category = "";
        ident.name = Util.generateUUID();
        return this.addFacet(object, ident, facet);
    }

    @Override
    public Object remove(Identity ident) {
        return this.removeFacet(ident, "");
    }

    @Override
    public synchronized Object removeFacet(Identity ident, String facet) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.removeServant(ident, facet);
    }

    public synchronized Map removeAllFacets(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.removeAllFacets(ident);
    }

    @Override
    public Object find(Identity ident) {
        return this.findFacet(ident, "");
    }

    @Override
    public synchronized Object findFacet(Identity ident, String facet) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.findServant(ident, facet);
    }

    public synchronized Map findAllFacets(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.findAllFacets(ident);
    }

    @Override
    public synchronized Object findByProxy(ObjectPrx proxy) {
        this.checkForDeactivation();
        Reference ref = ((ObjectPrxHelperBase)proxy).__reference();
        return this.findFacet(ref.getIdentity(), ref.getFacet());
    }

    @Override
    public synchronized void addServantLocator(ServantLocator locator, String prefix) {
        this.checkForDeactivation();
        this._servantManager.addServantLocator(locator, prefix);
    }

    @Override
    public synchronized ServantLocator findServantLocator(String prefix) {
        this.checkForDeactivation();
        return this._servantManager.findServantLocator(prefix);
    }

    @Override
    public synchronized ObjectPrx createProxy(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this.newProxy(ident, "");
    }

    @Override
    public synchronized ObjectPrx createDirectProxy(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this.newDirectProxy(ident, "");
    }

    @Override
    public synchronized ObjectPrx createIndirectProxy(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this.newIndirectProxy(ident, "", this._id);
    }

    @Override
    public synchronized void setLocator(LocatorPrx locator) {
        this.checkForDeactivation();
        this._locatorInfo = this._instance.locatorManager().get(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshPublishedEndpoints() {
        List<EndpointI> oldPublishedEndpoints;
        LocatorInfo locatorInfo = null;
        boolean registerProcess = false;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            this.checkForDeactivation();
            oldPublishedEndpoints = this._publishedEndpoints;
            this._publishedEndpoints = this.parsePublishedEndpoints();
            locatorInfo = this._locatorInfo;
            if (!this._noConfig) {
                registerProcess = this._instance.initializationData().properties.getPropertyAsInt(this._name + ".RegisterProcess") > 0;
            }
        }
        try {
            Identity dummy = new Identity();
            dummy.name = "dummy";
            this.updateLocatorRegistry(locatorInfo, this.createDirectProxy(dummy), registerProcess);
        }
        catch (LocalException ex) {
            ObjectAdapterI objectAdapterI2 = this;
            synchronized (objectAdapterI2) {
                this._publishedEndpoints = oldPublishedEndpoints;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocal(ObjectPrx proxy) {
        Reference ref = ((ObjectPrxHelperBase)proxy).__reference();
        if (ref.isWellKnown()) {
            return this._servantManager.hasServant(ref.getIdentity());
        }
        if (ref.isIndirect()) {
            return ref.getAdapterId().equals(this._id) || ref.getAdapterId().equals(this._replicaGroupId);
        }
        EndpointI[] endpoints = ref.getEndpoints();
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            Iterator<EndpointI> p;
            int i;
            this.checkForDeactivation();
            for (i = 0; i < endpoints.length; ++i) {
                p = this._publishedEndpoints.iterator();
                while (p.hasNext()) {
                    if (!endpoints[i].equivalent(p.next())) continue;
                    return true;
                }
                Iterator<IncomingConnectionFactory> q = this._incomingConnectionFactories.iterator();
                while (q.hasNext()) {
                    if (!endpoints[i].equivalent(q.next().endpoint())) continue;
                    return true;
                }
            }
            if (this._routerInfo != null && this._routerInfo.getRouter().equals(proxy.ice_getRouter())) {
                for (i = 0; i < endpoints.length; ++i) {
                    p = this._routerEndpoints.iterator();
                    while (p.hasNext()) {
                        if (!endpoints[i].equivalent(p.next())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        ArrayList<IncomingConnectionFactory> f;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            f = new ArrayList<IncomingConnectionFactory>(this._incomingConnectionFactories);
        }
        Iterator i = f.iterator();
        while (i.hasNext()) {
            ((IncomingConnectionFactory)i.next()).flushBatchRequests();
        }
    }

    public synchronized void incDirectCount() {
        this.checkForDeactivation();
        assert (this._directCount >= 0);
        ++this._directCount;
    }

    public synchronized void decDirectCount() {
        assert (this._instance != null);
        assert (this._directCount > 0);
        if (--this._directCount == 0) {
            this.notifyAll();
        }
    }

    public ThreadPool getThreadPool() {
        assert (this._instance != null);
        if (this._threadPool != null) {
            return this._threadPool;
        }
        return this._instance.serverThreadPool();
    }

    public ServantManager getServantManager() {
        return this._servantManager;
    }

    public ObjectAdapterI(Instance instance, Communicator communicator, ObjectAdapterFactory objectAdapterFactory, String name, String endpointInfo, RouterPrx router, boolean noConfig) {
        this._instance = instance;
        this._communicator = communicator;
        this._objectAdapterFactory = objectAdapterFactory;
        this._servantManager = new ServantManager(instance, name);
        this._activateOneOffDone = false;
        this._name = name;
        this._directCount = 0;
        this._waitForActivate = false;
        this._destroying = false;
        this._destroyed = false;
        this._noConfig = noConfig;
        if (this._noConfig) {
            this._id = "";
            this._replicaGroupId = "";
            this._reference = this._instance.referenceFactory().create("dummy -t", "");
            return;
        }
        Properties properties = this._instance.initializationData().properties;
        ArrayList<String> unknownProps = new ArrayList<String>();
        boolean noProps = this.filterProperties(unknownProps);
        if (unknownProps.size() != 0 && properties.getPropertyAsIntWithDefault("Ice.Warn.UnknownProperties", 1) > 0) {
            String message = "found unknown properties for object adapter `" + this._name + "':";
            Iterator p = unknownProps.iterator();
            while (p.hasNext()) {
                message = message + "\n    " + (String)p.next();
            }
            this._instance.initializationData().logger.warning(message);
        }
        if (endpointInfo.length() == 0 && router == null && noProps) {
            this._deactivated = true;
            this._destroyed = true;
            this._instance = null;
            this._communicator = null;
            this._incomingConnectionFactories = null;
            InitializationException ex = new InitializationException();
            ex.reason = "object adapter `" + this._name + "' requires configuration";
            throw ex;
        }
        this._id = properties.getProperty(this._name + ".AdapterId");
        this._replicaGroupId = properties.getProperty(this._name + ".ReplicaGroupId");
        String proxyOptions = properties.getPropertyWithDefault(this._name + ".ProxyOptions", "-t");
        try {
            this._reference = this._instance.referenceFactory().create("dummy " + proxyOptions, "");
        }
        catch (ProxyParseException e) {
            InitializationException ex = new InitializationException();
            ex.reason = "invalid proxy options `" + proxyOptions + "' for object adapter `" + this._name + "'";
            throw ex;
        }
        try {
            int threadPoolSize = properties.getPropertyAsInt(this._name + ".ThreadPool.Size");
            int threadPoolSizeMax = properties.getPropertyAsInt(this._name + ".ThreadPool.SizeMax");
            if (threadPoolSize > 0 || threadPoolSizeMax > 0) {
                this._threadPool = new ThreadPool(this._instance, this._name + ".ThreadPool", 0);
            }
            if (router == null) {
                router = RouterPrxHelper.uncheckedCast(this._instance.proxyFactory().propertyToProxy(name + ".Router"));
            }
            if (router != null) {
                this._routerInfo = this._instance.routerManager().get(router);
                if (this._routerInfo != null) {
                    int i;
                    if (this._routerInfo.getAdapter() != null) {
                        throw new AlreadyRegisteredException("object adapter with router", this._instance.identityToString(router.ice_getIdentity()));
                    }
                    EndpointI[] endpoints = this._routerInfo.getServerEndpoints();
                    for (i = 0; i < endpoints.length; ++i) {
                        this._routerEndpoints.add(endpoints[i]);
                    }
                    Collections.sort(this._routerEndpoints);
                    i = 0;
                    while (i < this._routerEndpoints.size() - 1) {
                        EndpointI e2;
                        EndpointI e1 = this._routerEndpoints.get(i);
                        if (e1.equals(e2 = this._routerEndpoints.get(i + 1))) {
                            this._routerEndpoints.remove(i);
                            continue;
                        }
                        ++i;
                    }
                    this._routerInfo.setAdapter(this);
                    this._instance.outgoingConnectionFactory().setRouterInfo(this._routerInfo);
                }
            } else {
                List<EndpointI> endpoints = endpointInfo.length() == 0 ? this.parseEndpoints(properties.getProperty(this._name + ".Endpoints"), true) : this.parseEndpoints(endpointInfo, true);
                for (int i = 0; i < endpoints.size(); ++i) {
                    EndpointI endp = endpoints.get(i);
                    IncomingConnectionFactory factory = new IncomingConnectionFactory(instance, endp, this, this._name);
                    this._incomingConnectionFactories.add(factory);
                }
                if (endpoints.size() == 0) {
                    TraceLevels tl = this._instance.traceLevels();
                    if (tl.network >= 2) {
                        this._instance.initializationData().logger.trace(tl.networkCat, "created adapter `" + name + "' without endpoints");
                    }
                }
                this._publishedEndpoints = this.parsePublishedEndpoints();
            }
            if (properties.getProperty(this._name + ".Locator").length() > 0) {
                this.setLocator(LocatorPrxHelper.uncheckedCast(this._instance.proxyFactory().propertyToProxy(this._name + ".Locator")));
            } else {
                this.setLocator(this._instance.referenceFactory().getDefaultLocator());
            }
        }
        catch (LocalException ex) {
            this.destroy();
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        if (!this._deactivated) {
            this._instance.initializationData().logger.warning("object adapter `" + this.getName() + "' has not been deactivated");
        } else if (!this._destroyed) {
            this._instance.initializationData().logger.warning("object adapter `" + this.getName() + "' has not been destroyed");
        } else {
            Assert.FinalizerAssert(this._threadPool == null);
            Assert.FinalizerAssert(this._communicator == null);
            Assert.FinalizerAssert(this._incomingConnectionFactories == null);
            Assert.FinalizerAssert(this._directCount == 0);
            Assert.FinalizerAssert(!this._waitForActivate);
        }
        super.finalize();
    }

    private ObjectPrx newProxy(Identity ident, String facet) {
        if (this._id.length() == 0) {
            return this.newDirectProxy(ident, facet);
        }
        if (this._replicaGroupId.length() == 0) {
            return this.newIndirectProxy(ident, facet, this._id);
        }
        return this.newIndirectProxy(ident, facet, this._replicaGroupId);
    }

    private ObjectPrx newDirectProxy(Identity ident, String facet) {
        int sz = this._publishedEndpoints.size();
        EndpointI[] endpoints = new EndpointI[sz + this._routerEndpoints.size()];
        this._publishedEndpoints.toArray(endpoints);
        for (int i = 0; i < this._routerEndpoints.size(); ++i) {
            endpoints[sz + i] = this._routerEndpoints.get(i);
        }
        Reference ref = this._instance.referenceFactory().create(ident, facet, this._reference, endpoints);
        return this._instance.proxyFactory().referenceToProxy(ref);
    }

    private ObjectPrx newIndirectProxy(Identity ident, String facet, String id) {
        Reference ref = this._instance.referenceFactory().create(ident, facet, this._reference, id);
        return this._instance.proxyFactory().referenceToProxy(ref);
    }

    private void checkForDeactivation() {
        if (this._deactivated) {
            ObjectAdapterDeactivatedException ex = new ObjectAdapterDeactivatedException();
            ex.name = this.getName();
            throw ex;
        }
    }

    private static void checkIdentity(Identity ident) {
        if (ident.name == null || ident.name.length() == 0) {
            IllegalIdentityException e = new IllegalIdentityException();
            e.id = (Identity)ident.clone();
            throw e;
        }
        if (ident.category == null) {
            ident.category = "";
        }
    }

    private List<EndpointI> parseEndpoints(String endpts, boolean oaEndpoints) {
        int beg;
        int end = 0;
        String delim = " \t\n\r";
        ArrayList<EndpointI> endpoints = new ArrayList<EndpointI>();
        while (end < endpts.length() && (beg = StringUtil.findFirstNotOf(endpts, " \t\n\r", end)) != -1) {
            end = beg;
            while (true) {
                if ((end = endpts.indexOf(58, end)) == -1) {
                    end = endpts.length();
                    break;
                }
                boolean quoted = false;
                int quote = beg;
                while ((quote = endpts.indexOf(34, quote)) != -1 && end >= quote) {
                    ++quote;
                    if ((quote = endpts.indexOf(34, quote)) == -1) break;
                    if (end < quote) {
                        quoted = true;
                        break;
                    }
                    ++quote;
                }
                if (!quoted) break;
                ++end;
            }
            if (end == beg) {
                ++end;
                continue;
            }
            String s = endpts.substring(beg, end);
            EndpointI endp = this._instance.endpointFactoryManager().create(s, oaEndpoints);
            if (endp == null) {
                EndpointParseException e = new EndpointParseException();
                e.str = s;
                throw e;
            }
            endpoints.add(endp);
            ++end;
        }
        return endpoints;
    }

    private List<EndpointI> parsePublishedEndpoints() {
        String endpts = this._instance.initializationData().properties.getProperty(this._name + ".PublishedEndpoints");
        List<EndpointI> endpoints = this.parseEndpoints(endpts, false);
        if (!endpoints.isEmpty()) {
            return endpoints;
        }
        for (int i = 0; i < this._incomingConnectionFactories.size(); ++i) {
            IncomingConnectionFactory factory = this._incomingConnectionFactories.get(i);
            endpoints.add(factory.endpoint());
        }
        ArrayList<EndpointI> expandedEndpoints = new ArrayList<EndpointI>();
        Iterator<EndpointI> p = endpoints.iterator();
        while (p.hasNext()) {
            expandedEndpoints.addAll(p.next().expand());
        }
        return expandedEndpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocatorRegistry(LocatorInfo locatorInfo, ObjectPrx proxy, boolean registerProcess) {
        java.lang.Object s;
        if (!registerProcess && this._id.length() == 0) {
            return;
        }
        LocatorRegistryPrx locatorRegistry = locatorInfo != null ? locatorInfo.getLocatorRegistry() : null;
        String serverId = "";
        if (registerProcess) {
            assert (this._instance != null);
            serverId = this._instance.initializationData().properties.getProperty("Ice.ServerId");
            if (locatorRegistry == null) {
                this._instance.initializationData().logger.warning("object adapter `" + this.getName() + "' cannot register the process without a locator registry");
            } else if (serverId.length() == 0) {
                this._instance.initializationData().logger.warning("object adapter `" + this.getName() + "' cannot register the process without a value for Ice.ServerId");
            }
        }
        if (locatorRegistry == null) {
            return;
        }
        if (this._id.length() > 0) {
            try {
                if (this._replicaGroupId.length() == 0) {
                    locatorRegistry.setAdapterDirectProxy(this._id, proxy);
                } else {
                    locatorRegistry.setReplicatedAdapterDirectProxy(this._id, this._replicaGroupId, proxy);
                }
            }
            catch (AdapterNotFoundException ex) {
                if (this._instance.traceLevels().location >= 1) {
                    StringBuffer s2 = new StringBuffer();
                    s2.append("couldn't update object adapter `" + this._id + "' endpoints with the locator registry:\n");
                    s2.append("the object adapter is not known to the locator registry");
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, s2.toString());
                }
                NotRegisteredException ex1 = new NotRegisteredException();
                ex1.kindOfObject = "object adapter";
                ex1.id = this._id;
                throw ex1;
            }
            catch (InvalidReplicaGroupIdException ex) {
                if (this._instance.traceLevels().location >= 1) {
                    StringBuffer s3 = new StringBuffer();
                    s3.append("couldn't update object adapter `" + this._id + "' endpoints with the locator registry:\n");
                    s3.append("the replica group `" + this._replicaGroupId + "' is not known to the locator registry");
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, s3.toString());
                }
                NotRegisteredException ex1 = new NotRegisteredException();
                ex1.kindOfObject = "replica group";
                ex1.id = this._replicaGroupId;
                throw ex1;
            }
            catch (AdapterAlreadyActiveException ex) {
                if (this._instance.traceLevels().location >= 1) {
                    StringBuffer s4 = new StringBuffer();
                    s4.append("couldn't update object adapter `" + this._id + "' endpoints with the locator registry:\n");
                    s4.append("the object adapter endpoints are already set");
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, s4.toString());
                }
                ObjectAdapterIdInUseException ex1 = new ObjectAdapterIdInUseException();
                ex1.id = this._id;
                throw ex1;
            }
            catch (LocalException e) {
                if (this._instance.traceLevels().location >= 1) {
                    StringBuffer s5 = new StringBuffer();
                    s5.append("couldn't update object adapter `" + this._id + "' endpoints with the locator registry:\n" + e);
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, s5.toString());
                }
                throw e;
            }
            if (this._instance.traceLevels().location >= 1) {
                s = new StringBuffer();
                ((StringBuffer)s).append("updated object adapter `" + this._id + "' endpoints with the locator registry\n");
                ((StringBuffer)s).append("endpoints = ");
                if (proxy != null) {
                    Endpoint[] endpoints = proxy.ice_getEndpoints();
                    for (int i = 0; i < endpoints.length; ++i) {
                        ((StringBuffer)s).append(endpoints[i].toString());
                        if (i + 1 >= endpoints.length) continue;
                        ((StringBuffer)s).append(":");
                    }
                }
                this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, ((StringBuffer)s).toString());
            }
        }
        if (registerProcess && serverId.length() > 0) {
            StringBuffer s6;
            s = this;
            synchronized (s) {
                if (this._processId == null) {
                    ProcessI servant = new ProcessI(this._communicator);
                    this._processId = this.addWithUUID(servant).ice_getIdentity();
                }
            }
            try {
                locatorRegistry.setServerProcessProxy(serverId, ProcessPrxHelper.uncheckedCast(this.createDirectProxy(this._processId)));
            }
            catch (ServerNotFoundException ex) {
                if (this._instance.traceLevels().location >= 1) {
                    s6 = new StringBuffer();
                    s6.append("couldn't register server `" + serverId + "' with the locator registry:\n");
                    s6.append("the server is not known to the locator registry");
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, s6.toString());
                }
                NotRegisteredException ex1 = new NotRegisteredException();
                ex1.id = serverId;
                ex1.kindOfObject = "server";
                throw ex1;
            }
            catch (LocalException ex) {
                if (this._instance.traceLevels().location >= 1) {
                    s6 = new StringBuffer();
                    s6.append("couldn't register server `" + serverId + "' with the locator registry:\n" + ex);
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, s6.toString());
                }
                throw ex;
            }
            if (this._instance.traceLevels().location >= 1) {
                s = new StringBuffer();
                ((StringBuffer)s).append("registered server `" + serverId + "' with the locator registry");
                this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, ((StringBuffer)s).toString());
            }
        }
    }

    boolean filterProperties(List<String> unknownProps) {
        boolean addUnknown = true;
        String prefix = this._name + ".";
        int i = 0;
        while (PropertyNames.clPropNames[i] != null) {
            if (prefix.startsWith(PropertyNames.clPropNames[i] + ".")) {
                addUnknown = false;
                break;
            }
            ++i;
        }
        boolean noProps = true;
        Map<String, String> props = this._instance.initializationData().properties.getPropertiesForPrefix(prefix);
        for (String prop : props.keySet()) {
            boolean valid = false;
            for (int i2 = 0; i2 < _suffixes.length; ++i2) {
                if (!prop.equals(prefix + _suffixes[i2])) continue;
                noProps = false;
                valid = true;
                break;
            }
            if (valid || !addUnknown) continue;
            unknownProps.add(prop);
        }
        return noProps;
    }
}

