/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.HeaderUI;
import org.jdesktop.swingx.plaf.PainterUIResource;

public class BasicHeaderUI
extends HeaderUI {
    protected JLabel titleLabel;
    protected JXLabel descriptionPane;
    protected JLabel imagePanel;
    private PropertyChangeListener propListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicHeaderUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        assert (c instanceof JXHeader);
        JXHeader header = (JXHeader)c;
        this.installDefaults(header);
        this.titleLabel = new JLabel(header.getTitle() == null ? "Title For Header Goes Here" : header.getTitle());
        this.titleLabel.setFont(header.getTitleFont());
        this.descriptionPane = new JXLabel(){

            public void paint(Graphics g) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                super.paint(g);
            }
        };
        this.descriptionPane.setFont(header.getDescriptionFont());
        this.descriptionPane.setLineWrap(true);
        this.descriptionPane.setOpaque(false);
        this.descriptionPane.setText(header.getDescription() == null ? "The description for the header goes here.\nExample: Click the Copy Code button to generate the corresponding Java code." : header.getDescription());
        this.imagePanel = new JLabel();
        this.imagePanel.setIcon(header.getIcon() == null ? UIManager.getIcon("Header.defaultIcon") : header.getIcon());
        this.installComponents(header);
        this.installListeners(header);
    }

    public void uninstallUI(JComponent c) {
        assert (c instanceof JXHeader);
        JXHeader header = (JXHeader)c;
        this.uninstallDefaults(header);
        this.uninstallListeners(header);
        this.uninstallComponents(header);
        this.titleLabel = null;
        this.descriptionPane = null;
        this.imagePanel = null;
    }

    protected void installDefaults(JXHeader h) {
        Painter p = h.getBackgroundPainter();
        if (p == null || p instanceof PainterUIResource) {
            h.setBackgroundPainter(this.createBackgroundPainter());
        }
    }

    protected void uninstallDefaults(JXHeader h) {
    }

    protected void installListeners(final JXHeader h) {
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                BasicHeaderUI.this.onPropertyChange(h, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
        h.addPropertyChangeListener(this.propListener);
        h.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            public void ancestorResized(HierarchyEvent e) {
                if (h == e.getComponent()) {
                    View v = (View)BasicHeaderUI.this.descriptionPane.getClientProperty("html");
                    v.setSize(h.getParent().getWidth() - h.getInsets().left - h.getInsets().right - BasicHeaderUI.this.descriptionPane.getInsets().left - BasicHeaderUI.this.descriptionPane.getInsets().right - BasicHeaderUI.this.descriptionPane.getBounds().x, BasicHeaderUI.this.descriptionPane.getHeight());
                }
            }
        });
    }

    protected void uninstallListeners(JXHeader h) {
        h.removePropertyChangeListener(this.propListener);
    }

    protected void onPropertyChange(JXHeader h, String propertyName, Object oldValue, Object newValue) {
        if ("title".equals(propertyName)) {
            this.titleLabel.setText(h.getTitle());
        } else if ("description".equals(propertyName)) {
            this.descriptionPane.setText(h.getDescription());
        } else if ("icon".equals(propertyName)) {
            this.imagePanel.setIcon(h.getIcon());
        } else if ("enabled".equals(propertyName)) {
            boolean enabled = h.isEnabled();
            this.titleLabel.setEnabled(enabled);
            this.descriptionPane.setEnabled(enabled);
            this.imagePanel.setEnabled(enabled);
        } else if ("titleFont".equals(propertyName)) {
            this.titleLabel.setFont((Font)newValue);
        } else if ("descriptionFont".equals(propertyName)) {
            this.descriptionPane.setFont((Font)newValue);
        }
    }

    protected void installComponents(JXHeader h) {
        h.setLayout(new GridBagLayout());
        h.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(12, 12, 0, 11), 0, 0));
        h.add((Component)this.descriptionPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 24, 12, 11), 0, 0));
        h.add((Component)this.imagePanel, new GridBagConstraints(1, 0, 1, 2, 0.0, 1.0, 24, 0, new Insets(12, 0, 11, 11), 0, 0));
    }

    protected void uninstallComponents(JXHeader h) {
        h.remove(this.titleLabel);
        h.remove(this.descriptionPane);
        h.remove(this.imagePanel);
    }

    protected Painter createBackgroundPainter() {
        MattePainter p = new MattePainter(new GradientPaint(0.0f, 0.0f, Color.WHITE, 1.0f, 0.0f, UIManager.getColor("control")));
        p.setPaintStretched(true);
        return new PainterUIResource(p);
    }
}

