/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import ucar.unidata.util.StringUtil;

public class IO {
    private static int default_file_buffersize = 9200;
    private static int default_socket_buffersize = 64000;
    static boolean showStackTrace = true;
    static boolean debug = false;
    static boolean showResponse = false;

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[default_file_buffersize];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public static void copyB(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int bytesRead;
        int done = 0;
        int next = 1;
        boolean show = false;
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            if (!show || (done += bytesRead) <= 1000000 * next) continue;
            System.out.println(next + " Mb");
            ++next;
        }
    }

    public static void copy(InputStream in, OutputStream out, int n) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[default_file_buffersize];
        int count = 0;
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            if ((count += bytesRead) <= n) continue;
            return;
        }
    }

    public static String readContents(InputStream is) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10 * default_file_buffersize);
        IO.copy(is, bout);
        return bout.toString();
    }

    public static byte[] readContentsToByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10 * default_file_buffersize);
        IO.copy(is, bout);
        return bout.toByteArray();
    }

    public static void writeContents(String contents, OutputStream os) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(contents.getBytes());
        IO.copy(bin, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String fileInName, String fileOutName) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(fileInName));
            out = new BufferedOutputStream(new FileOutputStream(fileOutName));
            IO.copy(in, out);
        }
        finally {
            if (null != in) {
                in.close();
            }
            if (null != out) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File fileIn, File fileOut) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(fileIn));
            out = new BufferedOutputStream(new FileOutputStream(fileOut));
            IO.copy(in, out);
        }
        finally {
            if (null != in) {
                in.close();
            }
            if (null != out) {
                out.close();
            }
        }
    }

    public static void copyFile(String fileInName, OutputStream out) throws IOException {
        IO.copyFileB(new File(fileInName), out, default_file_buffersize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileB(File fileIn, OutputStream out, int bufferSize) throws IOException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(fileIn));
            IO.copyB(in, out, bufferSize);
        }
        finally {
            if (null != in) {
                in.close();
            }
        }
    }

    public static long copyRafB(ucar.unidata.io.RandomAccessFile raf, long offset, long length, OutputStream out, byte[] buffer) throws IOException {
        int len;
        long want;
        int bytesRead;
        int bufferSize = buffer.length;
        raf.seek(offset);
        for (want = length; want > 0L && (bytesRead = raf.read(buffer, 0, len = (int)Math.min(want, (long)bufferSize))) > 0; want -= (long)bytesRead) {
            out.write(buffer, 0, bytesRead);
        }
        return length - want;
    }

    public static void copyDirTree(String fromDirName, String toDirName) throws IOException {
        File fromDir = new File(fromDirName);
        File toDir = new File(toDirName);
        if (!fromDir.exists()) {
            return;
        }
        if (!toDir.exists()) {
            toDir.mkdirs();
        }
        File[] files = fromDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                IO.copyDirTree(f.getAbsolutePath(), toDir.getAbsolutePath() + "/" + f.getName());
                continue;
            }
            IO.copyFile(f.getAbsolutePath(), toDir.getAbsolutePath() + "/" + f.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToByteArray(String filename) throws IOException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(filename));
            byte[] byArray = IO.readContentsToByteArray(in);
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String filename) throws IOException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(filename));
            String string = IO.readContents(in);
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String contents, File file) throws IOException {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            IO.copy(new ByteArrayInputStream(contents.getBytes()), out);
            out.flush();
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }

    public static void writeToFile(String contents, String fileOutName) throws IOException {
        IO.writeToFile(contents, new File(fileOutName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(InputStream in, String fileOutName) throws IOException {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(fileOutName));
            IO.copy(in, out);
        }
        finally {
            if (null != in) {
                in.close();
            }
            if (null != out) {
                ((OutputStream)out).close();
            }
        }
    }

    public static void copyUrlB(String urlString, OutputStream out, int bufferSize) throws IOException {
        URL url;
        InputStream is = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IOException("** MalformedURLException on URL <" + urlString + ">\n" + e.getMessage() + "\n");
        }
        try {
            HttpURLConnection httpConnection;
            int responseCode;
            URLConnection connection = url.openConnection();
            if (connection instanceof HttpURLConnection && (responseCode = (httpConnection = (HttpURLConnection)connection).getResponseCode()) / 100 != 2) {
                throw new IOException("** Cant open URL <" + urlString + ">\n Response code = " + responseCode + "\n" + httpConnection.getResponseMessage() + "\n");
            }
            is = connection.getInputStream();
            IO.copyB(is, out, bufferSize);
        }
        catch (ConnectException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            throw new IOException("** ConnectException on URL: <" + urlString + ">\n" + e.getMessage() + "\nServer probably not running");
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readURLtoFile(String urlString, File file) {
        BufferedOutputStream out;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (IOException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            return "** IOException opening file: <" + file + ">\n" + e.getMessage() + "\n";
        }
        try {
            IO.copyUrlB(urlString, out, 20000);
            String e = "ok";
            return e;
        }
        catch (IOException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            String string = "** IOException reading URL: <" + urlString + ">\n" + e.getMessage() + "\n";
            return string;
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                return "** IOException closing file : <" + file + ">\n" + e.getMessage() + "\n";
            }
        }
    }

    public static String readURLtoFileWithExceptions(String urlString, File file) throws IOException {
        return IO.readURLtoFileWithExceptions(urlString, file, default_socket_buffersize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readURLtoFileWithExceptions(String urlString, File file, int buffer_size) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            IO.copyUrlB(urlString, out, buffer_size);
            String string = "ok";
            return string;
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                return "** IOException closing file : <" + file + ">\n" + e.getMessage() + "\n";
            }
        }
    }

    public static String readURLcontentsWithException(String urlString) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(20000);
        IO.copyUrlB(urlString, bout, 20000);
        return bout.toString();
    }

    public static String readURLcontents(String urlString) {
        try {
            return IO.readURLcontentsWithException(urlString);
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public static Result putToURL(String urlString, String contents) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            return new Result(-1, "** MalformedURLException on URL (" + urlString + ")\n" + e.getMessage());
        }
        try {
            HttpURLConnection c = (HttpURLConnection)url.openConnection();
            c.setDoOutput(true);
            c.setRequestMethod("PUT");
            BufferedOutputStream out = new BufferedOutputStream(c.getOutputStream());
            IO.copy(new ByteArrayInputStream(contents.getBytes()), out);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            int code = c.getResponseCode();
            String mess = c.getResponseMessage();
            return new Result(code, mess);
        }
        catch (ConnectException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            return new Result(-2, "** ConnectException on URL: <" + urlString + ">\n" + e.getMessage() + "\nServer probably not running");
        }
        catch (IOException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            return new Result(-3, "** IOException on URL: (" + urlString + ")\n" + e.getMessage());
        }
    }

    public static void testRead() {
        String baseUrl = "http://moca.virtual.museum/legac/legac01.htm";
        String baseDir = "";
        File dir = new File(baseDir);
        dir.mkdirs();
        for (int i = 1; i < 159; ++i) {
            String n = StringUtil.padZero(i, 3);
            String filename = n + ".jpg";
            System.out.println("Open " + baseDir + filename);
            File file = new File(baseDir + filename);
            IO.readURLtoFile(baseUrl + filename, file);
        }
    }

    public static void main4(String[] args) {
        String url = "http://whoopee:8080/thredds/dodsC/test/2005052412_NAM.wmo.dods?Best_4-layer_lifted_index";
        String filenameOut = "C:/temp/tempFile4.compress";
        File f = new File(filenameOut);
        long start = System.currentTimeMillis();
        String result = IO.readURLtoFile(url, f);
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        System.out.println(result);
        System.out.println(" that took = " + took + "sec");
        System.out.println(" file size = " + f.length());
    }

    public static void mainn(String[] args) {
        long start = System.currentTimeMillis();
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<RandomAccessFile> rafList = new ArrayList<RandomAccessFile>();
        int count = 0;
        while (true) {
            try {
                File temp = File.createTempFile("test", "tmp");
                fileList.add(temp);
                RandomAccessFile raf = new RandomAccessFile(temp, "r");
                rafList.add(raf);
            }
            catch (IOException e) {
                e.printStackTrace();
                break;
            }
            if (++count % 50 != 0) continue;
            System.out.println(" " + count);
        }
        long took = System.currentTimeMillis() - start;
        System.out.println(" Created and opened " + count + " files in " + took + " msecs");
        start = System.currentTimeMillis();
        for (RandomAccessFile raf : rafList) {
            try {
                raf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        took = System.currentTimeMillis() - start;
        System.out.println(" Closed " + count + " files in " + took + " msecs");
        for (File file : fileList) {
            file.delete();
        }
        took = System.currentTimeMillis() - start;
        System.out.println(" Deleted " + count + " files in " + took + " msecs");
        count = 0;
        took = System.currentTimeMillis() - start;
        File dir = new File("/var/tmp/");
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            File file = list[i];
            if (!file.getName().endsWith("tmp")) continue;
            file.delete();
            ++count;
        }
        took = System.currentTimeMillis() - start;
        System.out.println(" Deleted " + count + " files in " + took + " msecs");
    }

    public static void main(String[] args) {
        String url_point = "http:/thredds/ncss/metars?variables=all&north=82.5199&west=88.4499&east=90.4000&south=-90.0000&spatial=point&latitude=40&longitude=-100&stn=&temporal=all&time_start=2007-09-26T23%3A45%3A04Z&time_end=present&time=2007-09-26T23%3A45%3A04Z&accept=netcdf";
        String url = "http://motherlode.ucar.edu:9080/thredds/ncss/metars?variables=all&spatial=all&time_start=2007-09-29T00%3A00%3A00Z&time_end=2007-09-29T23%3A59%3A59Z&accept=netcdf";
        String url_box = "http:/thredds/ncss/metars?variables=all&spatial=bb&north=41&west=-103&east=-100&south=39&latitude=40&longitude=-100&stn=&temporal=all&time_start=2007-09-26T23%3A45%3A04Z&time_end=present&time=2007-09-26T23%3A45%3A04Z&accept=netcdf";
        String filenameOut = "C:/temp/metars-timeseries-box.nc";
        File f = new File(filenameOut);
        System.out.println("Read = " + url + " to " + filenameOut);
        long start = System.currentTimeMillis();
        String result = IO.readURLtoFile(url_box, f);
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        System.out.println(result);
        System.out.println(" that took = " + took + "sec");
        System.out.println(" file size = " + f.length());
    }

    public static class Result {
        public int code;
        public String message;

        Result(int code, String message) {
            this.code = code;
            this.message = message;
        }
    }
}

