/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.poifs.filesystem;

import java.io.IOException;
import java.io.InputStream;
import loci.common.RandomAccessStream;
import loci.poi.poifs.filesystem.DocumentEntry;
import loci.poi.poifs.filesystem.DocumentNode;
import loci.poi.poifs.filesystem.POIFSDocument;

public class DocumentInputStream
extends InputStream {
    private int _current_offset = 0;
    private int _marked_offset = 0;
    private int _document_size;
    private boolean _closed;
    private POIFSDocument _document;
    private byte[] _tiny_buffer;
    private RandomAccessStream stream;
    private static final int EOD = -1;

    public DocumentInputStream(DocumentEntry document, RandomAccessStream stream) throws IOException {
        this._document_size = document.getSize();
        this._closed = false;
        this._tiny_buffer = null;
        this.stream = stream;
        if (!(document instanceof DocumentNode)) {
            throw new IOException("Cannot open internal document storage");
        }
        this._document = ((DocumentNode)document).getDocument();
    }

    public DocumentInputStream(POIFSDocument document, RandomAccessStream stream) throws IOException {
        this._document_size = document.getSize();
        this._closed = false;
        this._tiny_buffer = null;
        this._document = document;
        this.stream = stream;
    }

    public int available() throws IOException {
        this.dieIfClosed();
        return this._document_size - this._current_offset;
    }

    public void close() throws IOException {
        this._closed = true;
    }

    public void mark(int ignoredReadlimit) {
        this._marked_offset = this._current_offset;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        this.dieIfClosed();
        if (this.atEOD()) {
            return -1;
        }
        if (this._tiny_buffer == null) {
            this._tiny_buffer = new byte[1];
        }
        this._document.read(this._tiny_buffer, this._current_offset++, this.stream);
        return this._tiny_buffer[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException, NullPointerException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException, NullPointerException, IndexOutOfBoundsException {
        this.dieIfClosed();
        if (b == null) {
            throw new NullPointerException("buffer is null");
        }
        if (off < 0 || len < 0 || b.length < off + len) {
            throw new IndexOutOfBoundsException("can't read past buffer boundaries");
        }
        if (len == 0) {
            return 0;
        }
        if (this.atEOD()) {
            return -1;
        }
        int limit = Math.min(this.available(), len);
        if (off == 0 && limit == b.length) {
            this._document.read(b, this._current_offset, this.stream);
        } else {
            byte[] buffer = new byte[limit];
            this._document.read(buffer, this._current_offset, this.stream);
            System.arraycopy(buffer, 0, b, off, limit);
        }
        this._current_offset += limit;
        return limit;
    }

    public void reset() {
        this._current_offset = this._marked_offset;
    }

    public long skip(long n) throws IOException {
        this.dieIfClosed();
        if (n < 0L) {
            return 0L;
        }
        int new_offset = this._current_offset + (int)n;
        if (new_offset < this._current_offset) {
            new_offset = this._document_size;
        } else if (new_offset > this._document_size) {
            new_offset = this._document_size;
        }
        long rval = new_offset - this._current_offset;
        this._current_offset = new_offset;
        return rval;
    }

    private void dieIfClosed() throws IOException {
        if (this._closed) {
            throw new IOException("cannot perform requested operation on a closed stream");
        }
    }

    private boolean atEOD() {
        return this._current_offset == this._document_size;
    }
}

