/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.test.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.ini4j.IniPreferences;
import org.ini4j.InvalidIniFormatException;

public class TestEngineConfig
extends IniPreferences {
    public static final String CONFIG_ROOT = "main";
    public static final String CONFIG_HOSTNAME = "hostname";
    public static final String CONFIG_USERNAME = "username";
    public static final String CONFIG_PASSWORD = "password";
    public static final String CONFIG_SESSIONKEY = "sessionkey";
    public static final String CONFIG_PORT = "port";
    public static final String CONFIG_POPULATE = "populate";
    public static final String CONFIG_RECURSE = "recurse";
    public static final String CONFIG_TARGET = "target_directory";

    public TestEngineConfig(InputStream stream) throws InvalidIniFormatException, FileNotFoundException, IOException {
        super(stream);
    }

    public void setHostname(String hostname) {
        this.node(CONFIG_ROOT).put(CONFIG_HOSTNAME, hostname);
    }

    public String getHostname() {
        return this.node(CONFIG_ROOT).get(CONFIG_HOSTNAME, null);
    }

    public void setUsername(String username) {
        this.node(CONFIG_ROOT).put(CONFIG_USERNAME, username);
    }

    public String getUsername() {
        return this.node(CONFIG_ROOT).get(CONFIG_USERNAME, null);
    }

    public void setPassword(String password) {
        this.node(CONFIG_ROOT).put(CONFIG_PASSWORD, password);
    }

    public String getPassword() {
        return this.node(CONFIG_ROOT).get(CONFIG_PASSWORD, null);
    }

    public void setSessionKey(String sessionKey) {
        this.node(CONFIG_ROOT).put(CONFIG_SESSIONKEY, sessionKey);
    }

    public String getSessionKey() {
        return this.node(CONFIG_ROOT).get(CONFIG_SESSIONKEY, null);
    }

    public void setPort(int port) {
        this.node(CONFIG_ROOT).putInt(CONFIG_PORT, port);
    }

    public int getPort() {
        return this.node(CONFIG_ROOT).getInt(CONFIG_PORT, 4063);
    }

    public void setPopulate(boolean populate) {
        this.node(CONFIG_ROOT).putBoolean(CONFIG_POPULATE, populate);
    }

    public boolean getPopulate() {
        return this.node(CONFIG_ROOT).getBoolean(CONFIG_POPULATE, false);
    }

    public void setRecurse(boolean recurse) {
        this.node(CONFIG_ROOT).putBoolean(CONFIG_RECURSE, recurse);
    }

    public boolean getRecurse() {
        return this.node(CONFIG_ROOT).getBoolean(CONFIG_RECURSE, true);
    }

    public void setTarget(String target) {
        this.node(CONFIG_ROOT).put(CONFIG_TARGET, target);
    }

    public String getTarget() {
        return this.node(CONFIG_ROOT).get(CONFIG_TARGET, null);
    }

    public boolean validateLogin() {
        return (this.getUsername() != null && this.getPassword() != null || this.getSessionKey() != null) && this.getHostname() != null;
    }
}

