/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model.handler;

import java.util.HashMap;
import java.util.Map;
import ome.formats.enums.EnumerationProvider;
import ome.formats.model.handler.ArcHandler;
import ome.formats.model.handler.DetectorHandler;
import ome.formats.model.handler.FilamentHandler;
import ome.formats.model.handler.LaserHandler;
import ome.formats.model.handler.LogicalChannelHandler;
import ome.formats.model.handler.ModelObjectHandler;
import ome.formats.model.handler.NoopModelObjectHandler;
import ome.formats.model.handler.ObjectiveHandler;
import omero.model.IObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelObjectHandlerFactory {
    private static Map<Class<? extends IObject>, ModelObjectHandler> handlers = new HashMap<Class<? extends IObject>, ModelObjectHandler>();
    private ModelObjectHandler noopHandler = new NoopModelObjectHandler();

    public ModelObjectHandlerFactory(EnumerationProvider enumProvider) {
        handlers.put(ObjectiveHandler.HANDLER_FOR, new ObjectiveHandler(enumProvider));
        handlers.put(DetectorHandler.HANDLER_FOR, new DetectorHandler(enumProvider));
        handlers.put(ArcHandler.HANDLER_FOR, new ArcHandler(enumProvider));
        handlers.put(FilamentHandler.HANDLER_FOR, new FilamentHandler(enumProvider));
        handlers.put(LaserHandler.HANDLER_FOR, new LaserHandler(enumProvider));
        handlers.put(LogicalChannelHandler.HANDLER_FOR, new LogicalChannelHandler(enumProvider));
    }

    public ModelObjectHandler getHandler(Class<? extends IObject> klass) {
        return handlers.containsKey(klass) ? handlers.get(klass) : this.noopHandler;
    }
}

