/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.cli;

import gnu.getopt.Getopt;
import java.io.File;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.ImageReader;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.OMEROWrapper;
import ome.formats.importer.cli.LoggingImportMonitor;
import omero.ServerError;
import omero.model.Dataset;
import omero.model.IObject;
import omero.model.Screen;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineImporter {
    private static Log log = LogFactory.getLog(CommandLineImporter.class);
    private static final int PORT = 4063;
    private static final String APP_NAME = "importer-cli";
    public ImportLibrary library;
    private OMEROWrapper reader;
    private OMEROMetadataStoreClient store = new OMEROMetadataStoreClient();

    public CommandLineImporter(String username, String password, String host, int port) throws Exception {
        this.store.initialize(username, password, host, port);
        this.reader = new OMEROWrapper();
        this.library = new ImportLibrary(this.store, this.reader);
    }

    public CommandLineImporter(String sessionKey, String host, int port) throws Exception {
        this.store.initialize(host, port, sessionKey);
        this.reader = new OMEROWrapper();
        this.library = new ImportLibrary(this.store, this.reader);
    }

    public void addMonitor(LoggingImportMonitor monitor) {
        this.library.addObserver(monitor);
    }

    public void importImage(String path, Class<? extends IObject> targetClass, Long targetId, String name, String description) throws IOException, FormatException, ServerError {
        File f = new File(path);
        IObject target = null;
        if (targetId != null) {
            target = this.store.getTarget(targetClass, targetId);
        }
        this.library.setTarget(target);
        this.library.importImage(f, 0, 0, 1, name, description, false, null);
        this.store.logout();
    }

    public void cleanup() {
        this.store.logout();
    }

    public static void usage() {
        System.err.println(String.format("Usage: %s [OPTION]... [FILE]\nImport single files into an OMERO instance.\n\nMandatory arguments:\n  -s\tOMERO server hostname\n  -u\tOMERO experimenter name (username)\n  -w\tOMERO experimenter password\n  -k\tOMERO session key (can be used in place of -u and -w)\n\nOptional arguments:\n  -f\tDisplay the used files [does not require mandatory arguments]\n  -d\tOMERO dataset Id to import image into\n  -r\tOMERO screen Id to import plate into\n  -n\tImage name to use\n  -x\tImage description to use\n  -p\tOMERO server port [defaults to 4063]\n  -h\tDisplay this help and exit\n\nex. %s -s localhost -u bart -w simpson -d 50 foo.tiff\n\nReport bugs to <ome-users@openmicroscopy.org.uk>", APP_NAME, APP_NAME));
        System.exit(1);
    }

    public static void main(String[] args) {
        int a;
        Getopt g = new Getopt(APP_NAME, args, "fs:u:w:d:r:k:x:n:p:h");
        String username = null;
        String password = null;
        String sessionKey = null;
        String hostname = null;
        int port = 4063;
        Class<Dataset> targetClass = null;
        Long targetId = null;
        String name = null;
        String description = null;
        boolean getUsedFiles = false;
        while ((a = g.getopt()) != -1) {
            switch (a) {
                case 115: {
                    hostname = g.getOptarg();
                    break;
                }
                case 117: {
                    username = g.getOptarg();
                    break;
                }
                case 119: {
                    password = g.getOptarg();
                    break;
                }
                case 107: {
                    sessionKey = g.getOptarg();
                    break;
                }
                case 112: {
                    port = Integer.parseInt(g.getOptarg());
                    break;
                }
                case 100: {
                    targetClass = Dataset.class;
                    targetId = Long.parseLong(g.getOptarg());
                    break;
                }
                case 114: {
                    targetClass = Screen.class;
                    targetId = Long.parseLong(g.getOptarg());
                    break;
                }
                case 110: {
                    name = g.getOptarg();
                    break;
                }
                case 120: {
                    description = g.getOptarg();
                    break;
                }
                case 102: {
                    getUsedFiles = true;
                    break;
                }
                default: {
                    CommandLineImporter.usage();
                }
            }
        }
        if (args.length - g.getOptind() != 1) {
            CommandLineImporter.usage();
        }
        String path = args[g.getOptind()];
        if (getUsedFiles) {
            ImageReader reader = new ImageReader();
            try {
                reader.setId(path);
                String[] stringArray = reader.getUsedFiles();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String usedFile = stringArray[n2];
                    System.out.println(usedFile);
                    ++n2;
                }
                return;
            }
            catch (Throwable t) {
                log.error((Object)"Error retrieving used files.", t);
                System.exit(2);
            }
        }
        if ((username == null || password == null) && sessionKey == null || hostname == null) {
            CommandLineImporter.usage();
        }
        CommandLineImporter c = null;
        try {
            try {
                if (name == null) {
                    name = path;
                }
                c = sessionKey != null ? new CommandLineImporter(sessionKey, hostname, port) : new CommandLineImporter(username, password, hostname, port);
                c.library.addObserver(new LoggingImportMonitor());
                c.importImage(path, targetClass, targetId, name, description);
                System.exit(0);
            }
            catch (Throwable t) {
                log.error((Object)"Error during import process.", t);
                System.exit(2);
                if (c != null) {
                    c.cleanup();
                }
            }
        }
        finally {
            if (c != null) {
                c.cleanup();
            }
        }
    }
}

