/*
 * Decompiled with CFR 0.152.
 */
package ome.formats;

import Glacier2.CannotCreateSessionException;
import Glacier2.PermissionDeniedException;
import Ice.ObjectPrx;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Timestamp;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.meta.IMinMaxStore;
import loci.formats.meta.MetadataStore;
import ome.formats.enums.EnumerationProvider;
import ome.formats.enums.IQueryEnumProvider;
import ome.formats.importer.MetaLightSource;
import ome.formats.importer.util.ClientKeepAlive;
import ome.formats.model.BlitzInstanceProvider;
import ome.formats.model.ChannelProcessor;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.InstanceProvider;
import ome.formats.model.InstrumentProcessor;
import ome.formats.model.ModelProcessor;
import ome.formats.model.PixelsProcessor;
import ome.formats.model.ReferenceProcessor;
import ome.formats.model.TargetProcessor;
import ome.util.LSID;
import omero.RBool;
import omero.RDouble;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.RTime;
import omero.ServerError;
import omero.api.IAdminPrx;
import omero.api.IContainerPrx;
import omero.api.IQueryPrx;
import omero.api.IRepositoryInfoPrx;
import omero.api.IUpdatePrx;
import omero.api.MetadataStorePrx;
import omero.api.MetadataStorePrxHelper;
import omero.api.RawFileStorePrx;
import omero.api.RawPixelsStorePrx;
import omero.api.ServiceFactoryPrx;
import omero.api.ServiceInterfacePrx;
import omero.client;
import omero.metadatastore.IObjectContainer;
import omero.model.AcquisitionMode;
import omero.model.Arc;
import omero.model.ArcType;
import omero.model.Binning;
import omero.model.ContrastMethod;
import omero.model.Correction;
import omero.model.Dataset;
import omero.model.DatasetI;
import omero.model.Detector;
import omero.model.DetectorSettings;
import omero.model.DetectorType;
import omero.model.DimensionOrder;
import omero.model.Experiment;
import omero.model.ExperimentType;
import omero.model.Filament;
import omero.model.FilamentType;
import omero.model.Format;
import omero.model.IObject;
import omero.model.Illumination;
import omero.model.Image;
import omero.model.ImageI;
import omero.model.ImagingEnvironment;
import omero.model.Immersion;
import omero.model.Instrument;
import omero.model.Laser;
import omero.model.LaserMedium;
import omero.model.LaserType;
import omero.model.LightSettings;
import omero.model.LightSource;
import omero.model.LogicalChannel;
import omero.model.Medium;
import omero.model.OTF;
import omero.model.Objective;
import omero.model.ObjectiveSettings;
import omero.model.OriginalFile;
import omero.model.PhotometricInterpretation;
import omero.model.Pixels;
import omero.model.PixelsType;
import omero.model.PlaneInfo;
import omero.model.Plate;
import omero.model.Project;
import omero.model.ProjectI;
import omero.model.Pulse;
import omero.model.Reagent;
import omero.model.Screen;
import omero.model.ScreenAcquisition;
import omero.model.ScreenI;
import omero.model.StageLabel;
import omero.model.Well;
import omero.model.WellSample;
import omero.rtypes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMEROMetadataStoreClient
implements MetadataStore,
IMinMaxStore,
IObjectContainerStore {
    private Log log = LogFactory.getLog(OMEROMetadataStoreClient.class);
    private MetadataStorePrx delegate;
    private Map<LSID, IObjectContainer> containerCache = new TreeMap<LSID, IObjectContainer>(new OMEXMLModelComparator());
    private Map<LSID, LSID> referenceCache = new HashMap<LSID, LSID>();
    private Map<String, String> referenceStringCache;
    private List<ModelProcessor> modelProcessors = new ArrayList<ModelProcessor>();
    private IFormatReader reader;
    private List<Pixels> pixelsList;
    private client c;
    private ServiceFactoryPrx serviceFactory;
    private IUpdatePrx iUpdate;
    private IQueryPrx iQuery;
    private IAdminPrx iAdmin;
    private RawFileStorePrx rawFileStore;
    private RawPixelsStorePrx rawPixelStore;
    private IRepositoryInfoPrx iRepoInfo;
    private IContainerPrx iContainer;
    private EnumerationProvider enumProvider;
    private InstanceProvider instanceProvider;
    private Long currentPixId;
    private String userSpecifiedImageName;
    private String userSpecifiedImageDescription;
    private IObject userSpecifiedTarget;
    private Double[] userSpecifiedPhysicalPixelSizes;
    private double[][][] imageChannelGlobalMinMax;
    private ClientKeepAlive keepAlive = new ClientKeepAlive();
    private ScheduledThreadPoolExecutor executor;

    private void initializeServices() throws ServerError {
        this.iUpdate = this.serviceFactory.getUpdateService();
        this.iQuery = this.serviceFactory.getQueryService();
        this.iAdmin = this.serviceFactory.getAdminService();
        this.rawFileStore = this.serviceFactory.createRawFileStore();
        this.rawPixelStore = this.serviceFactory.createRawPixelsStore();
        this.iRepoInfo = this.serviceFactory.getRepositoryInfoService();
        this.iContainer = this.serviceFactory.getContainerService();
        this.delegate = MetadataStorePrxHelper.checkedCast((ObjectPrx)this.serviceFactory.getByName("omero.api.MetadataStore"));
        this.enumProvider = new IQueryEnumProvider(this.iQuery);
        this.instanceProvider = new BlitzInstanceProvider(this.enumProvider);
        this.modelProcessors.add(new PixelsProcessor());
        this.modelProcessors.add(new ChannelProcessor());
        this.modelProcessors.add(new InstrumentProcessor());
        this.modelProcessors.add(new TargetProcessor());
        this.modelProcessors.add(new ReferenceProcessor());
        if (this.executor == null) {
            this.executor = new ScheduledThreadPoolExecutor(1);
            this.executor.scheduleWithFixedDelay(this.keepAlive, 60L, 60L, TimeUnit.SECONDS);
        }
        this.keepAlive.setClient(this);
    }

    public IQueryPrx getIQuery() {
        return this.iQuery;
    }

    public void initialize(ServiceFactoryPrx serviceFactory) throws ServerError {
        if (serviceFactory == null) {
            throw new IllegalArgumentException("No factory.");
        }
        this.serviceFactory = serviceFactory;
        this.initializeServices();
    }

    public void initialize(String username, String password, String server, int port) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.c = new client(server, port);
        this.serviceFactory = this.c.createSession(username, password);
        this.initializeServices();
    }

    public void initialize(String server, int port, String sessionKey) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.c = new client(server, port);
        this.serviceFactory = this.c.joinSession(sessionKey);
        this.initializeServices();
    }

    public void ping() {
        this.serviceFactory.keepAllAlive(new ServiceInterfacePrx[]{this.iQuery, this.iAdmin, this.rawFileStore, this.rawPixelStore, this.iRepoInfo, this.iContainer, this.iUpdate, this.delegate});
        this.log.debug((Object)"KeepAlive ping");
    }

    public RInt toRType(Integer value) {
        return value == null ? null : rtypes.rint((int)value);
    }

    public RLong toRType(Long value) {
        return value == null ? null : rtypes.rlong((long)value);
    }

    public RString toRType(String value) {
        return value == null ? null : rtypes.rstring((String)value);
    }

    public RBool toRType(Boolean value) {
        return value == null ? null : rtypes.rbool((boolean)value);
    }

    public RDouble toRType(Double value) {
        return value == null ? null : rtypes.rdouble((double)value);
    }

    public RDouble toRType(Float value) {
        return value == null ? null : rtypes.rdouble((double)Double.parseDouble(value.toString()));
    }

    public RTime toRType(Timestamp value) {
        return value == null ? null : rtypes.rtime((Date)value);
    }

    public void logout() {
        if (this.executor != null) {
            this.log.debug((Object)"Logout called, keep alive shut down.");
            this.executor.shutdown();
            this.executor = null;
        }
        if (this.c != null) {
            this.c.closeSession();
            this.c = null;
        }
    }

    public void createRoot() {
        try {
            this.log.debug((Object)"Creating root!");
            this.containerCache = new TreeMap<LSID, IObjectContainer>(new OMEXMLModelComparator());
            this.referenceCache = new HashMap<LSID, LSID>();
            this.referenceStringCache = null;
            this.imageChannelGlobalMinMax = null;
            this.userSpecifiedImageName = null;
            this.userSpecifiedImageDescription = null;
            this.userSpecifiedTarget = null;
            this.userSpecifiedPhysicalPixelSizes = null;
            this.delegate.createRoot();
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public Object getRoot() {
        return this.pixelsList;
    }

    private IObject getEnumeration(Class<? extends IObject> klass, String value) {
        return this.enumProvider.getEnumeration(klass, value, false);
    }

    @Override
    public IFormatReader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(IFormatReader reader) {
        this.reader = reader;
    }

    @Override
    public String getUserSpecifiedImageName() {
        return this.userSpecifiedImageName;
    }

    @Override
    public void setUserSpecifiedImageName(String name) {
        this.userSpecifiedImageName = name;
    }

    @Override
    public String getUserSpecifiedImageDescription() {
        return this.userSpecifiedImageDescription;
    }

    @Override
    public void setUserSpecifiedImageDescription(String description) {
        this.userSpecifiedImageDescription = description;
    }

    @Override
    public IObject getUserSpecifiedTarget() {
        return this.userSpecifiedTarget;
    }

    @Override
    public void setUserSpecifiedTarget(IObject target) {
        this.userSpecifiedTarget = target;
    }

    @Override
    public Double[] getUserSpecifiedPhysicalPixelSizes() {
        return this.userSpecifiedPhysicalPixelSizes;
    }

    @Override
    public void setUserSpecifiedPhysicalPixelSizes(Double physicalSizeX, Double physicalSizeY, Double physicalSizeZ) {
        this.userSpecifiedPhysicalPixelSizes = new Double[]{physicalSizeX, physicalSizeY, physicalSizeZ};
    }

    public List<ModelProcessor> getModelProcessors() {
        return this.modelProcessors;
    }

    public void setModelProcessors(List<ModelProcessor> modelProcessors) {
        this.modelProcessors = modelProcessors;
    }

    public void removeModelProcessor(ModelProcessor processor) {
        this.modelProcessors.remove(processor);
    }

    public boolean addModelProcessor(ModelProcessor processor) {
        return this.modelProcessors.add(processor);
    }

    @Override
    public Map<LSID, IObjectContainer> getContainerCache() {
        return this.containerCache;
    }

    @Override
    public Map<LSID, LSID> getReferenceCache() {
        return this.referenceCache;
    }

    @Override
    public Map<String, String> getReferenceStringCache() {
        return this.referenceStringCache;
    }

    @Override
    public void setReferenceStringCache(Map<String, String> referenceStringCache) {
        this.referenceStringCache = referenceStringCache;
    }

    private <T extends IObject> T getSourceObject(Class<T> klass, LinkedHashMap<String, Integer> indexes) {
        return (T)this.getIObjectContainer(klass, indexes).sourceObject;
    }

    @Override
    public IObject getSourceObject(LSID LSID2) {
        IObjectContainer o = this.containerCache.get(LSID2);
        if (o == null) {
            return null;
        }
        return o.sourceObject;
    }

    @Override
    public <T extends IObject> List<T> getSourceObjects(Class<T> klass) {
        List<IObjectContainer> containers = this.getIObjectContainers(klass);
        ArrayList<IObject> toReturn = new ArrayList<IObject>(containers.size());
        for (IObjectContainer container : containers) {
            toReturn.add(container.sourceObject);
        }
        return toReturn;
    }

    @Override
    public boolean hasReference(LSID source, LSID target) {
        return this.referenceCache.containsKey(source) && this.referenceCache.containsValue(target);
    }

    @Override
    public IObjectContainer getIObjectContainer(Class<? extends IObject> klass, LinkedHashMap<String, Integer> indexes) {
        LSID lsLSID;
        Collection<Integer> indexValues = indexes.values();
        int[] indexesArray = new int[indexValues.size()];
        int i = 0;
        for (Integer index : indexValues) {
            indexesArray[i] = index;
            ++i;
        }
        LSID lsid = new LSID(klass, indexesArray);
        if ((klass.equals(Arc.class) || klass.equals(Laser.class) || klass.equals(Filament.class)) && !this.containerCache.containsKey(lsid) && this.containerCache.containsKey(lsLSID = new LSID(LightSource.class, new int[]{indexes.get("instrumentIndex"), indexes.get("lightSourceIndex")}))) {
            IObjectContainer container = this.containerCache.get(lsLSID);
            MetaLightSource mls = (MetaLightSource)container.sourceObject;
            LightSource realInstance = (LightSource)this.getSourceObjectInstance(klass);
            mls.copyData(realInstance);
            container.sourceObject = realInstance;
            if (container.LSID == null || container.LSID.equals(lsLSID.toString())) {
                container.LSID = lsid.toString();
            }
            this.containerCache.put(lsid, container);
            return container;
        }
        if (klass.equals(LightSource.class) && !this.containerCache.containsKey(lsid)) {
            Class[] concreteClasses;
            Class[] classArray = concreteClasses = new Class[]{Arc.class, Laser.class, Filament.class};
            int n = concreteClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class concreteClass = classArray[n2];
                LSID lsLSID2 = new LSID(concreteClass, new int[]{indexes.get("instrumentIndex"), indexes.get("lightSourceIndex")});
                if (this.containerCache.containsKey(lsLSID2)) {
                    return this.containerCache.get(lsLSID2);
                }
                ++n2;
            }
        }
        if (!this.containerCache.containsKey(lsid)) {
            IObjectContainer c = new IObjectContainer();
            c.indexes = indexes;
            c.LSID = lsid.toString();
            c.sourceObject = this.getSourceObjectInstance(klass);
            this.containerCache.put(lsid, c);
        }
        return this.containerCache.get(lsid);
    }

    @Override
    public List<IObjectContainer> getIObjectContainers(Class<? extends IObject> klass) {
        Set<LSID> keys = this.containerCache.keySet();
        ArrayList<IObjectContainer> toReturn = new ArrayList<IObjectContainer>();
        for (LSID key : keys) {
            Class keyClass = key.getJavaClass();
            if (keyClass == null || !keyClass.equals(klass)) continue;
            toReturn.add(this.containerCache.get(key));
        }
        return toReturn;
    }

    private <T extends IObject> T getSourceObjectInstance(Class<T> klass) {
        return this.instanceProvider.getInstance(klass);
    }

    @Override
    public int countCachedContainers(Class<? extends IObject> klass, int ... indexes) {
        if (klass == null) {
            return new HashSet<IObjectContainer>(this.containerCache.values()).size();
        }
        int count = 0;
        for (LSID lsid : this.containerCache.keySet()) {
            Class lsidClass = lsid.getJavaClass();
            if (lsidClass == null || !lsidClass.equals(klass)) continue;
            if (indexes != null) {
                int[] lsidIndexes = lsid.getIndexes();
                int i = 0;
                while (i < indexes.length) {
                    if (lsidIndexes[i] != indexes[i]) {
                        // empty if block
                    }
                    ++i;
                }
            }
            ++count;
        }
        return count;
    }

    @Override
    public int countCachedReferences(Class<? extends IObject> source, Class<? extends IObject> target) {
        if (source == null && target == null) {
            return this.referenceCache.size();
        }
        int count = 0;
        if (target == null) {
            for (LSID lsid : this.referenceCache.keySet()) {
                Class containerClass = lsid.getJavaClass();
                if (!containerClass.equals(source)) continue;
                ++count;
            }
            return count;
        }
        if (source == null) {
            for (LSID lsid : this.referenceCache.values()) {
                Class containerClass = lsid.getJavaClass();
                if (!containerClass.equals(target)) continue;
                ++count;
            }
            return count;
        }
        for (LSID lsid : this.referenceCache.keySet()) {
            Class targetClass;
            Class containerClass = lsid.getJavaClass();
            if (!containerClass.equals(source.getName()) || !(targetClass = this.referenceCache.get(lsid).getJavaClass()).equals(target.getName())) continue;
            ++count;
        }
        return count;
    }

    public void setArchive(boolean archive) {
        List<Image> images = this.getSourceObjects(Image.class);
        String[] files = this.reader.getUsedFiles();
        if (archive) {
            LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
            ImageReader imageReader = (ImageReader)this.reader;
            String formatString = imageReader.getReader().getClass().toString();
            formatString = formatString.replace("class loci.formats.in.", "");
            formatString = formatString.replace("Reader", "");
            int i = 0;
            while (i < files.length) {
                indexes.put("originaFileIndex", i);
                OriginalFile o = this.getSourceObject(OriginalFile.class, indexes);
                File file = new File(files[i]);
                o.setName(this.toRType(file.getName()));
                o.setSize(this.toRType(file.length()));
                o.setFormat((Format)this.getEnumeration(Format.class, formatString));
                o.setPath(this.toRType(file.getAbsolutePath()));
                o.setSha1(this.toRType("Pending"));
                ++i;
            }
        }
        int i = 0;
        while (i < images.size()) {
            Image image = images.get(i);
            image.setArchived(this.toRType(archive));
            if (archive) {
                LSID key = new LSID(Pixels.class, new int[]{i, 0});
                int j = 0;
                while (j < files.length) {
                    this.referenceCache.put(key, new LSID(OriginalFile.class, new int[]{j++}));
                }
            }
            ++i;
        }
    }

    public void setArcType(String type, int instrumentIndex, int lightSourceIndex) {
        Arc o = this.getArc(instrumentIndex, lightSourceIndex);
        o.setType((ArcType)this.getEnumeration(ArcType.class, type));
    }

    private Arc getArc(int instrumentIndex, int lightSourceIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("instrumentIndex", instrumentIndex);
        indexes.put("lightSourceIndex", lightSourceIndex);
        return this.getSourceObject(Arc.class, indexes);
    }

    public void setChannelComponentColorDomain(String colorDomain, int imageIndex, int logicalChannelIndex, int channelComponentIndex) {
    }

    public void setChannelComponentIndex(Integer index, int imageIndex, int logicalChannelIndex, int channelComponentIndex) {
    }

    public void setDetectorGain(Float gain, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setGain(this.toRType(gain));
    }

    public Detector getDetector(int instrumentIndex, int detectorIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("instrumentIndex", instrumentIndex);
        indexes.put("detectorIndex", detectorIndex);
        return this.getSourceObject(Detector.class, indexes);
    }

    public void setDetectorID(String id, int instrumentIndex, int detectorIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("instrumentIndex", instrumentIndex);
        indexes.put("detectorIndex", detectorIndex);
        IObjectContainer o = this.getIObjectContainer(Detector.class, indexes);
        o.LSID = id;
    }

    public void setDetectorManufacturer(String manufacturer, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setDetectorModel(String model, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setModel(this.toRType(model));
    }

    public void setDetectorOffset(Float offset, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setOffsetValue(this.toRType(offset));
    }

    public void setDetectorSerialNumber(String serialNumber, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setDetectorSettingsDetector(String detector, int imageIndex, int logicalChannelIndex) {
        LSID key = new LSID(DetectorSettings.class, new int[]{imageIndex, logicalChannelIndex});
        this.referenceCache.put(key, new LSID(detector));
    }

    private DetectorSettings getDetectorSettings(int imageIndex, int logicalChannelIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("imageIndex", imageIndex);
        indexes.put("logicalChannelIndex", logicalChannelIndex);
        return this.getSourceObject(DetectorSettings.class, indexes);
    }

    public void setDetectorSettingsBinning(String binning, int imageIndex, int logicalChannelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, logicalChannelIndex);
        o.setBinning((Binning)this.getEnumeration(Binning.class, binning));
    }

    public void setDetectorSettingsReadOutRate(Float readOutRate, int imageIndex, int logicalChannelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, logicalChannelIndex);
        o.setReadOutRate(this.toRType(readOutRate));
    }

    public void setDetectorSettingsVoltage(Float voltage, int imageIndex, int logicalChannelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, logicalChannelIndex);
        o.setVoltage(this.toRType(voltage));
    }

    public void setDetectorSettingsGain(Float gain, int imageIndex, int logicalChannelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, logicalChannelIndex);
        o.setGain(this.toRType(gain));
    }

    public void setDetectorSettingsOffset(Float offset, int imageIndex, int logicalChannelIndex) {
        DetectorSettings o = this.getDetectorSettings(imageIndex, logicalChannelIndex);
        o.setOffsetValue(this.toRType(offset));
    }

    public void setDetectorType(String type, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setType((DetectorType)this.getEnumeration(DetectorType.class, type));
    }

    public void setDetectorVoltage(Float voltage, int instrumentIndex, int detectorIndex) {
        Detector o = this.getDetector(instrumentIndex, detectorIndex);
        o.setVoltage(this.toRType(voltage));
    }

    public void setDimensionsPhysicalSizeX(Float physicalSizeX, int imageIndex, int pixelsIndex) {
        Pixels o = this.getPixels(imageIndex, pixelsIndex);
        o.setPhysicalSizeX(this.toRType(physicalSizeX));
    }

    private Pixels getPixels(int imageIndex, int pixelsIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("imageIndex", imageIndex);
        indexes.put("pixelsIndex", pixelsIndex);
        Pixels p = this.getSourceObject(Pixels.class, indexes);
        p.setSha1(rtypes.rstring((String)"Foo"));
        return p;
    }

    public void setDimensionsPhysicalSizeY(Float physicalSizeY, int imageIndex, int pixelsIndex) {
        Pixels o = this.getPixels(imageIndex, pixelsIndex);
        o.setPhysicalSizeY(this.toRType(physicalSizeY));
    }

    public void setDimensionsPhysicalSizeZ(Float physicalSizeZ, int imageIndex, int pixelsIndex) {
        Pixels o = this.getPixels(imageIndex, pixelsIndex);
        o.setPhysicalSizeZ(this.toRType(physicalSizeZ));
    }

    public void setDimensionsTimeIncrement(Float timeIncrement, int imageIndex, int pixelsIndex) {
    }

    public void setDimensionsWaveIncrement(Integer waveIncrement, int imageIndex, int pixelsIndex) {
    }

    public void setDimensionsWaveStart(Integer waveStart, int imageIndex, int pixelsIndex) {
    }

    public void setDisplayOptionsID(String id, int imageIndex) {
    }

    public void setDisplayOptionsProjectionZStart(Integer start, int imageIndex) {
    }

    public void setDisplayOptionsProjectionZStop(Integer stop, int imageIndex) {
    }

    public void setDisplayOptionsTimeTStart(Integer start, int imageIndex) {
    }

    public void setDisplayOptionsTimeTStop(Integer stop, int imageIndex) {
    }

    public void setDisplayOptionsZoom(Float zoom, int imageIndex) {
    }

    public void setExperimenterEmail(String email, int experimenterIndex) {
    }

    public void setExperimenterFirstName(String firstName, int experimenterIndex) {
    }

    public void setExperimenterID(String id, int experimenterIndex) {
    }

    public void setExperimenterInstitution(String institution, int experimenterIndex) {
    }

    public void setExperimenterLastName(String lastName, int experimenterIndex) {
    }

    public void setFilamentType(String type, int instrumentIndex, int lightSourceIndex) {
        Filament o = this.getFilament(instrumentIndex, lightSourceIndex);
        o.setType((FilamentType)this.getEnumeration(FilamentType.class, type));
    }

    private Filament getFilament(int instrumentIndex, int lightSourceIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("instrumentIndex", instrumentIndex);
        indexes.put("lightSourceIndex", lightSourceIndex);
        return this.getSourceObject(Filament.class, indexes);
    }

    public void setImageCreationDate(String creationDate, int imageIndex) {
        if (creationDate != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                Date date = sdf.parse(creationDate);
                Timestamp creationTimestamp = new Timestamp(date.getTime());
                Image i = this.getImage(imageIndex);
                i.setAcquisitionDate(this.toRType(creationTimestamp));
            }
            catch (ParseException e) {
                this.log.error((Object)String.format("Parsing start time failed!", new Object[0]), (Throwable)e);
            }
        }
    }

    private Image getImage(int imageIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("imageIndex", imageIndex);
        return this.getSourceObject(Image.class, indexes);
    }

    public void setImageDescription(String description, int imageIndex) {
        Image o = this.getImage(imageIndex);
        o.setDescription(this.toRType(description));
    }

    public void setImageID(String id, int imageIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("imageIndex", imageIndex);
        IObjectContainer o = this.getIObjectContainer(Image.class, indexes);
        o.LSID = id;
    }

    public void setImageInstrumentRef(String instrumentRef, int imageIndex) {
        LSID key = new LSID(Image.class, new int[]{imageIndex});
        this.referenceCache.put(key, new LSID(instrumentRef));
    }

    public void setImageName(String name, int imageIndex) {
        Image o = this.getImage(imageIndex);
        o.setName(this.toRType(name));
    }

    public void setImagingEnvironmentAirPressure(Float airPressure, int imageIndex) {
        ImagingEnvironment o = this.getImagingEnvironment(imageIndex);
        o.setAirPressure(this.toRType(airPressure));
    }

    private ImagingEnvironment getImagingEnvironment(int imageIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("imageIndex", imageIndex);
        return this.getSourceObject(ImagingEnvironment.class, indexes);
    }

    public void setImagingEnvironmentCO2Percent(Float percent, int imageIndex) {
        ImagingEnvironment o = this.getImagingEnvironment(imageIndex);
        o.setCo2percent(this.toRType(percent));
    }

    public void setImagingEnvironmentHumidity(Float humidity, int imageIndex) {
        ImagingEnvironment o = this.getImagingEnvironment(imageIndex);
        o.setHumidity(this.toRType(humidity));
    }

    public void setImagingEnvironmentTemperature(Float temperature, int imageIndex) {
        ImagingEnvironment o = this.getImagingEnvironment(imageIndex);
        o.setTemperature(this.toRType(temperature));
    }

    public void setInstrumentID(String id, int instrumentIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("instrumentIndex", instrumentIndex);
        IObjectContainer o = this.getIObjectContainer(Instrument.class, indexes);
        o.LSID = id;
    }

    public void setLaserFrequencyMultiplication(Integer frequencyMultiplication, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setFrequencyMultiplication(this.toRType(frequencyMultiplication));
    }

    private Laser getLaser(int instrumentIndex, int lightSourceIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("instrumentIndex", instrumentIndex);
        indexes.put("lightSourceIndex", lightSourceIndex);
        return this.getSourceObject(Laser.class, indexes);
    }

    public void setLaserLaserMedium(String laserMedium, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setLaserMedium((LaserMedium)this.getEnumeration(LaserMedium.class, laserMedium));
    }

    public void setLaserPulse(String pulse, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setPulse((Pulse)this.getEnumeration(Pulse.class, pulse));
    }

    public void setLaserTuneable(Boolean tuneable, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setTuneable(this.toRType(tuneable));
    }

    public void setLaserType(String type, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setType((LaserType)this.getEnumeration(LaserType.class, type));
    }

    public void setLaserWavelength(Integer wavelength, int instrumentIndex, int lightSourceIndex) {
        Laser o = this.getLaser(instrumentIndex, lightSourceIndex);
        o.setWavelength(this.toRType(wavelength));
    }

    public void setLightSourceID(String id, int instrumentIndex, int lightSourceIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("instrumentIndex", instrumentIndex);
        indexes.put("lightSourceIndex", lightSourceIndex);
        IObjectContainer o = this.getIObjectContainer(LightSource.class, indexes);
        o.LSID = id;
    }

    public void setLightSourceManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        LightSource o = this.getLightSource(instrumentIndex, lightSourceIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public LightSource getLightSource(int instrumentIndex, int lightSourceIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("instrumentIndex", instrumentIndex);
        indexes.put("lightSourceIndex", lightSourceIndex);
        return this.getSourceObject(LightSource.class, indexes);
    }

    public void setLightSourceModel(String model, int instrumentIndex, int lightSourceIndex) {
        LightSource o = this.getLightSource(instrumentIndex, lightSourceIndex);
        o.setModel(this.toRType(model));
    }

    public void setLightSourcePower(Float power, int instrumentIndex, int lightSourceIndex) {
        LightSource o = this.getLightSource(instrumentIndex, lightSourceIndex);
        o.setPower(this.toRType(power));
    }

    public void setLightSourceSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        LightSource o = this.getLightSource(instrumentIndex, lightSourceIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setLightSourceSettingsAttenuation(Float attenuation, int imageIndex, int logicalChannelIndex) {
        LightSettings o = this.getLightSettings(imageIndex, logicalChannelIndex);
        o.setAttenuation(this.toRType(attenuation));
    }

    private LightSettings getLightSettings(int imageIndex, int logicalChannelIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("imageIndex", imageIndex);
        indexes.put("logicalChannelIndex", logicalChannelIndex);
        return this.getSourceObject(LightSettings.class, indexes);
    }

    public void setLightSourceSettingsLightSource(String lightSource, int imageIndex, int logicalChannelIndex) {
        LSID key = new LSID(LightSettings.class, new int[]{imageIndex, logicalChannelIndex});
        this.referenceCache.put(key, new LSID(lightSource));
    }

    public void setLightSourceSettingsWavelength(Integer wavelength, int imageIndex, int logicalChannelIndex) {
        LightSettings o = this.getLightSettings(imageIndex, logicalChannelIndex);
        o.setWavelength(this.toRType(wavelength));
    }

    public void setLogicalChannelContrastMethod(String contrastMethod, int imageIndex, int logicalChannelIndex) {
        LogicalChannel o = this.getLogicalChannel(imageIndex, logicalChannelIndex);
        o.setContrastMethod((ContrastMethod)this.getEnumeration(ContrastMethod.class, contrastMethod));
    }

    public LogicalChannel getLogicalChannel(int imageIndex, int logicalChannelIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("imageIndex", imageIndex);
        indexes.put("logicalChannelIndex", logicalChannelIndex);
        return this.getSourceObject(LogicalChannel.class, indexes);
    }

    public void setLogicalChannelEmWave(Integer emWave, int imageIndex, int logicalChannelIndex) {
        LogicalChannel o = this.getLogicalChannel(imageIndex, logicalChannelIndex);
        o.setEmissionWave(this.toRType(emWave));
    }

    public void setLogicalChannelExWave(Integer exWave, int imageIndex, int logicalChannelIndex) {
        LogicalChannel o = this.getLogicalChannel(imageIndex, logicalChannelIndex);
        o.setExcitationWave(this.toRType(exWave));
    }

    public void setLogicalChannelFluor(String fluor, int imageIndex, int logicalChannelIndex) {
        LogicalChannel o = this.getLogicalChannel(imageIndex, logicalChannelIndex);
        o.setFluor(this.toRType(fluor));
    }

    public void setLogicalChannelID(String id, int imageIndex, int logicalChannelIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("imageIndex", imageIndex);
        indexes.put("logicalChannelIndex", logicalChannelIndex);
        IObjectContainer o = this.getIObjectContainer(LogicalChannel.class, indexes);
        o.LSID = id;
    }

    public void setLogicalChannelIlluminationType(String illuminationType, int imageIndex, int logicalChannelIndex) {
        LogicalChannel o = this.getLogicalChannel(imageIndex, logicalChannelIndex);
        o.setIllumination((Illumination)this.getEnumeration(Illumination.class, illuminationType));
    }

    public void setLogicalChannelMode(String mode, int imageIndex, int logicalChannelIndex) {
        LogicalChannel o = this.getLogicalChannel(imageIndex, logicalChannelIndex);
        o.setMode((AcquisitionMode)this.getEnumeration(AcquisitionMode.class, mode));
    }

    public void setLogicalChannelName(String name, int imageIndex, int logicalChannelIndex) {
        LogicalChannel o = this.getLogicalChannel(imageIndex, logicalChannelIndex);
        o.setName(this.toRType(name));
    }

    public void setLogicalChannelNdFilter(Float ndFilter, int imageIndex, int logicalChannelIndex) {
        LogicalChannel o = this.getLogicalChannel(imageIndex, logicalChannelIndex);
        o.setNdFilter(this.toRType(ndFilter));
    }

    public void setLogicalChannelPhotometricInterpretation(String photometricInterpretation, int imageIndex, int logicalChannelIndex) {
        LogicalChannel o = this.getLogicalChannel(imageIndex, logicalChannelIndex);
        o.setPhotometricInterpretation((PhotometricInterpretation)this.getEnumeration(PhotometricInterpretation.class, photometricInterpretation));
    }

    public void setLogicalChannelPinholeSize(Float pinholeSize, int imageIndex, int logicalChannelIndex) {
        LogicalChannel o = this.getLogicalChannel(imageIndex, logicalChannelIndex);
        o.setPinHoleSize(this.toRType(pinholeSize));
    }

    public void setLogicalChannelPockelCellSetting(Integer pockelCellSetting, int imageIndex, int logicalChannelIndex) {
        LogicalChannel o = this.getLogicalChannel(imageIndex, logicalChannelIndex);
        o.setPockelCellSetting(this.toRType(pockelCellSetting));
    }

    public void setLogicalChannelSamplesPerPixel(Integer samplesPerPixel, int imageIndex, int logicalChannelIndex) {
    }

    public void setOTFID(String id, int instrumentIndex, int otfIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("instrumentIndex", instrumentIndex);
        indexes.put("otfIndex", otfIndex);
        IObjectContainer o = this.getIObjectContainer(OTF.class, indexes);
        o.LSID = id;
    }

    public void setOTFOpticalAxisAveraged(Boolean opticalAxisAveraged, int instrumentIndex, int otfIndex) {
        OTF o = this.getOTF(instrumentIndex, otfIndex);
        o.setOpticalAxisAveraged(this.toRType(opticalAxisAveraged));
    }

    private OTF getOTF(int instrumentIndex, int otfIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("instrumentIndex", instrumentIndex);
        indexes.put("otfIndex", otfIndex);
        return this.getSourceObject(OTF.class, indexes);
    }

    public void setOTFPixelType(String pixelType, int instrumentIndex, int otfIndex) {
        OTF o = this.getOTF(instrumentIndex, otfIndex);
        o.setPixelsType((PixelsType)this.getEnumeration(PixelsType.class, pixelType));
    }

    public void setOTFSizeX(Integer sizeX, int instrumentIndex, int otfIndex) {
        OTF o = this.getOTF(instrumentIndex, otfIndex);
        o.setSizeX(this.toRType(sizeX));
    }

    public void setOTFSizeY(Integer sizeY, int instrumentIndex, int otfIndex) {
        OTF o = this.getOTF(instrumentIndex, otfIndex);
        o.setSizeY(this.toRType(sizeY));
    }

    public void setObjectiveIris(Boolean iris, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setIris(this.toRType(iris));
    }

    public Objective getObjective(int instrumentIndex, int objectiveIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("instrumentIndex", instrumentIndex);
        indexes.put("objectiveIndex", objectiveIndex);
        return this.getSourceObject(Objective.class, indexes);
    }

    public void setObjectiveCalibratedMagnification(Float calibratedMagnification, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setCalibratedMagnification(this.toRType(calibratedMagnification));
    }

    public void setObjectiveCorrection(String correction, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setCorrection((Correction)this.getEnumeration(Correction.class, correction));
    }

    public void setObjectiveID(String id, int instrumentIndex, int objectiveIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("instrumentIndex", instrumentIndex);
        indexes.put("objectiveIndex", objectiveIndex);
        IObjectContainer o = this.getIObjectContainer(Objective.class, indexes);
        o.LSID = id;
    }

    public void setObjectiveImmersion(String immersion, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setImmersion((Immersion)this.getEnumeration(Immersion.class, immersion));
    }

    public void setObjectiveLensNA(Float lensNA, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setLensNA(this.toRType(lensNA));
    }

    public void setObjectiveManufacturer(String manufacturer, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setManufacturer(this.toRType(manufacturer));
    }

    public void setObjectiveModel(String model, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setModel(this.toRType(model));
    }

    public void setObjectiveNominalMagnification(Integer nominalMagnification, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setNominalMagnification(this.toRType(nominalMagnification));
    }

    public void setObjectiveSerialNumber(String serialNumber, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setSerialNumber(this.toRType(serialNumber));
    }

    public void setObjectiveWorkingDistance(Float workingDistance, int instrumentIndex, int objectiveIndex) {
        Objective o = this.getObjective(instrumentIndex, objectiveIndex);
        o.setWorkingDistance(this.toRType(workingDistance));
    }

    public void setPixelsBigEndian(Boolean bigEndian, int imageIndex, int pixelsIndex) {
    }

    public void setPixelsDimensionOrder(String dimensionOrder, int imageIndex, int pixelsIndex) {
        Pixels o = this.getPixels(imageIndex, pixelsIndex);
        o.setDimensionOrder((DimensionOrder)this.getEnumeration(DimensionOrder.class, dimensionOrder));
    }

    public void setPixelsID(String id, int imageIndex, int pixelsIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("imageIndex", imageIndex);
        indexes.put("pixelsIndex", pixelsIndex);
        IObjectContainer o = this.getIObjectContainer(Pixels.class, indexes);
        o.LSID = id;
    }

    public void setPixelsPixelType(String pixelType, int imageIndex, int pixelsIndex) {
        Pixels o = this.getPixels(imageIndex, pixelsIndex);
        o.setPixelsType((PixelsType)this.getEnumeration(PixelsType.class, pixelType));
    }

    public void setPixelsSizeC(Integer sizeC, int imageIndex, int pixelsIndex) {
        Pixels o = this.getPixels(imageIndex, pixelsIndex);
        o.setSizeC(this.toRType(sizeC));
    }

    public void setPixelsSizeT(Integer sizeT, int imageIndex, int pixelsIndex) {
        Pixels o = this.getPixels(imageIndex, pixelsIndex);
        o.setSizeT(this.toRType(sizeT));
    }

    public void setPixelsSizeZ(Integer sizeZ, int imageIndex, int pixelsIndex) {
        Pixels o = this.getPixels(imageIndex, pixelsIndex);
        o.setSizeZ(this.toRType(sizeZ));
    }

    public void setPixelsSizeX(Integer sizeX, int imageIndex, int pixelsIndex) {
        Pixels o = this.getPixels(imageIndex, pixelsIndex);
        o.setSizeX(this.toRType(sizeX));
    }

    public void setPixelsSizeY(Integer sizeY, int imageIndex, int pixelsIndex) {
        Pixels o = this.getPixels(imageIndex, pixelsIndex);
        o.setSizeY(this.toRType(sizeY));
    }

    public void setPlaneTheC(Integer theC, int imageIndex, int pixelsIndex, int planeIndex) {
        PlaneInfo o = this.getPlaneInfo(imageIndex, pixelsIndex, planeIndex);
        o.setTheC(this.toRType(theC));
    }

    private PlaneInfo getPlaneInfo(int imageIndex, int pixelsIndex, int planeIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("imageIndex", imageIndex);
        indexes.put("pixelsIndex", pixelsIndex);
        indexes.put("planeIndex", planeIndex);
        return this.getSourceObject(PlaneInfo.class, indexes);
    }

    public void setPlaneTheT(Integer theT, int imageIndex, int pixelsIndex, int planeIndex) {
        PlaneInfo o = this.getPlaneInfo(imageIndex, pixelsIndex, planeIndex);
        o.setTheT(this.toRType(theT));
    }

    public void setPlaneTheZ(Integer theZ, int imageIndex, int pixelsIndex, int planeIndex) {
        PlaneInfo o = this.getPlaneInfo(imageIndex, pixelsIndex, planeIndex);
        o.setTheZ(this.toRType(theZ));
    }

    public void setPlaneTimingDeltaT(Float deltaT, int imageIndex, int pixelsIndex, int planeIndex) {
        PlaneInfo o = this.getPlaneInfo(imageIndex, pixelsIndex, planeIndex);
        o.setDeltaT(this.toRType(deltaT));
    }

    public void setPlaneTimingExposureTime(Float exposureTime, int imageIndex, int pixelsIndex, int planeIndex) {
        PlaneInfo o = this.getPlaneInfo(imageIndex, pixelsIndex, planeIndex);
        o.setExposureTime(this.toRType(exposureTime));
    }

    public void setPlateDescription(String description, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setDescription(this.toRType(description));
    }

    private Plate getPlate(int plateIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("plateIndex", plateIndex);
        return this.getSourceObject(Plate.class, indexes);
    }

    public void setPlateExternalIdentifier(String externalIdentifier, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setExternalIdentifier(this.toRType(externalIdentifier));
    }

    public void setPlateID(String id, int plateIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("plateIndex", plateIndex);
        IObjectContainer o = this.getIObjectContainer(Plate.class, indexes);
        o.LSID = id;
    }

    public void setPlateName(String name, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setName(this.toRType(name));
    }

    public void setPlateRefID(String id, int screenIndex, int plateRefIndex) {
    }

    public void setPlateStatus(String status, int plateIndex) {
        Plate o = this.getPlate(plateIndex);
        o.setStatus(this.toRType(status));
    }

    public void setROIID(String id, int imageIndex, int roiIndex) {
    }

    public void setROIT0(Integer t0, int imageIndex, int roiIndex) {
    }

    public void setROIT1(Integer t1, int imageIndex, int roiIndex) {
    }

    public void setROIX0(Integer x0, int imageIndex, int roiIndex) {
    }

    public void setROIX1(Integer x1, int imageIndex, int roiIndex) {
    }

    public void setROIY0(Integer y0, int imageIndex, int roiIndex) {
    }

    public void setROIY1(Integer y1, int imageIndex, int roiIndex) {
    }

    public void setROIZ0(Integer z0, int imageIndex, int roiIndex) {
    }

    public void setROIZ1(Integer z1, int imageIndex, int roiIndex) {
    }

    public void setReagentDescription(String description, int screenIndex, int reagentIndex) {
        Reagent o = this.getReagent(screenIndex, reagentIndex);
        o.setDescription(this.toRType(description));
    }

    private Reagent getReagent(int screenIndex, int reagentIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("screenIndex", screenIndex);
        indexes.put("reagentIndex", reagentIndex);
        return this.getSourceObject(Reagent.class, indexes);
    }

    public void setReagentID(String id, int screenIndex, int reagentIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("screenIndex", screenIndex);
        indexes.put("reagentIndex", reagentIndex);
        IObjectContainer o = this.getIObjectContainer(Reagent.class, indexes);
        o.LSID = id;
    }

    public void setReagentName(String name, int screenIndex, int reagentIndex) {
        Reagent o = this.getReagent(screenIndex, reagentIndex);
        o.setName(this.toRType(name));
    }

    public void setReagentReagentIdentifier(String reagentIdentifier, int screenIndex, int reagentIndex) {
        Reagent o = this.getReagent(screenIndex, reagentIndex);
        o.setReagentIdentifier(this.toRType(reagentIdentifier));
    }

    public void setRoot(Object root) {
        this.log.debug((Object)String.format("IGNORING: setRoot[%s]", root));
    }

    public void setScreenAcquisitionEndTime(String endTime, int screenIndex, int screenAcquisitionIndex) {
        ScreenAcquisition o = this.getScreenAcquisition(screenIndex, screenAcquisitionIndex);
        try {
            SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-d'T'HH:mm:ssZ");
            Timestamp ts = new Timestamp(parser.parse(endTime).getTime());
            o.setEndTime(this.toRType(ts));
        }
        catch (ParseException e) {
            this.log.error((Object)String.format("Parsing start time failed!", new Object[0]), (Throwable)e);
        }
    }

    private ScreenAcquisition getScreenAcquisition(int screenIndex, int screenAcquisitionIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("screenIndex", screenIndex);
        indexes.put("screenAcquisitionIndex", screenAcquisitionIndex);
        return this.getSourceObject(ScreenAcquisition.class, indexes);
    }

    public void setScreenAcquisitionID(String id, int screenIndex, int screenAcquisitionIndex) {
        LSID lsid = new LSID(ScreenAcquisition.class, new int[]{screenIndex, screenAcquisitionIndex});
        IObjectContainer o = this.containerCache.get(lsid);
        o.LSID = id;
    }

    public void setScreenAcquisitionStartTime(String startTime, int screenIndex, int screenAcquisitionIndex) {
        ScreenAcquisition o = this.getScreenAcquisition(screenIndex, screenAcquisitionIndex);
        try {
            SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-d'T'HH:mm:ssZ");
            Timestamp ts = new Timestamp(parser.parse(startTime).getTime());
            o.setStartTime(this.toRType(ts));
        }
        catch (ParseException e) {
            this.log.error((Object)String.format("Parsing start time failed!", new Object[0]), (Throwable)e);
        }
    }

    public void setScreenID(String id, int screenIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("screenIndex", screenIndex);
        IObjectContainer o = this.getIObjectContainer(Screen.class, indexes);
        o.LSID = id;
    }

    public void setScreenName(String name, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setName(this.toRType(name));
    }

    private Screen getScreen(int screenIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("screenIndex", screenIndex);
        return this.getSourceObject(Screen.class, indexes);
    }

    public void setScreenProtocolDescription(String protocolDescription, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setProtocolDescription(this.toRType(protocolDescription));
    }

    public void setScreenProtocolIdentifier(String protocolIdentifier, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setProtocolIdentifier(this.toRType(protocolIdentifier));
    }

    public void setScreenReagentSetDescription(String reagentSetDescription, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setReagentSetDescription(this.toRType(reagentSetDescription));
    }

    public void setScreenType(String type, int screenIndex) {
        Screen o = this.getScreen(screenIndex);
        o.setType(this.toRType(type));
    }

    public void setStageLabelName(String name, int imageIndex) {
        StageLabel o = this.getStageLabel(imageIndex);
        o.setName(this.toRType(name));
    }

    private StageLabel getStageLabel(int imageIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("imageIndex", imageIndex);
        return this.getSourceObject(StageLabel.class, indexes);
    }

    public void setStageLabelX(Float x, int imageIndex) {
        StageLabel o = this.getStageLabel(imageIndex);
        o.setPositionX(this.toRType(x));
    }

    public void setStageLabelY(Float y, int imageIndex) {
        StageLabel o = this.getStageLabel(imageIndex);
        o.setPositionY(this.toRType(y));
    }

    public void setStageLabelZ(Float z, int imageIndex) {
        StageLabel o = this.getStageLabel(imageIndex);
        o.setPositionZ(this.toRType(z));
    }

    public void setStagePositionPositionX(Float positionX, int imageIndex, int pixelsIndex, int planeIndex) {
        PlaneInfo o = this.getPlaneInfo(imageIndex, pixelsIndex, planeIndex);
        o.setPositionX(this.toRType(positionX));
    }

    public void setStagePositionPositionY(Float positionY, int imageIndex, int pixelsIndex, int planeIndex) {
        PlaneInfo o = this.getPlaneInfo(imageIndex, pixelsIndex, planeIndex);
        o.setPositionY(this.toRType(positionY));
    }

    public void setStagePositionPositionZ(Float positionZ, int imageIndex, int pixelsIndex, int planeIndex) {
        PlaneInfo o = this.getPlaneInfo(imageIndex, pixelsIndex, planeIndex);
        o.setPositionZ(this.toRType(positionZ));
    }

    public void setTiffDataFileName(String fileName, int imageIndex, int pixelsIndex, int tiffDataIndex) {
    }

    public void setTiffDataFirstC(Integer firstC, int imageIndex, int pixelsIndex, int tiffDataIndex) {
    }

    public void setTiffDataFirstT(Integer firstT, int imageIndex, int pixelsIndex, int tiffDataIndex) {
    }

    public void setTiffDataFirstZ(Integer firstZ, int imageIndex, int pixelsIndex, int tiffDataIndex) {
    }

    public void setTiffDataIFD(Integer ifd, int imageIndex, int pixelsIndex, int tiffDataIndex) {
    }

    public void setTiffDataNumPlanes(Integer numPlanes, int imageIndex, int pixelsIndex, int tiffDataIndex) {
    }

    public void setTiffDataUUID(String uuid, int imageIndex, int pixelsIndex, int tiffDataIndex) {
    }

    public void setUUID(String uuid) {
    }

    public void setWellColumn(Integer column, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        o.setColumn(this.toRType(column));
    }

    private Well getWell(int plateIndex, int wellIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("plateIndex", plateIndex);
        indexes.put("wellIndex", wellIndex);
        return this.getSourceObject(Well.class, indexes);
    }

    public void setWellExternalDescription(String externalDescription, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        o.setExternalDescription(this.toRType(externalDescription));
    }

    public void setWellExternalIdentifier(String externalIdentifier, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        o.setExternalIdentifier(this.toRType(externalIdentifier));
    }

    public void setWellID(String id, int plateIndex, int wellIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("plateIndex", plateIndex);
        indexes.put("wellIndex", wellIndex);
        IObjectContainer o = this.getIObjectContainer(Well.class, indexes);
        o.LSID = id;
    }

    public void setWellRow(Integer row, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        o.setRow(this.toRType(row));
    }

    public void setWellSampleID(String id, int plateIndex, int wellIndex, int wellSampleIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("plateIndex", plateIndex);
        indexes.put("wellIndex", wellIndex);
        indexes.put("wellSampleIndex", wellSampleIndex);
        IObjectContainer o = this.getIObjectContainer(WellSample.class, indexes);
        o.LSID = id;
    }

    public void setWellSampleIndex(Integer index, int plateIndex, int wellIndex, int wellSampleIndex) {
    }

    public void setWellSamplePosX(Float posX, int plateIndex, int wellIndex, int wellSampleIndex) {
        WellSample o = this.getWellSample(plateIndex, wellIndex, wellSampleIndex);
        o.setPosX(this.toRType(posX));
    }

    private WellSample getWellSample(int plateIndex, int wellIndex, int wellSampleIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("plateIndex", plateIndex);
        indexes.put("wellIndex", wellIndex);
        indexes.put("wellSampleIndex", wellSampleIndex);
        return this.getSourceObject(WellSample.class, indexes);
    }

    public void setWellSamplePosY(Float posY, int plateIndex, int wellIndex, int wellSampleIndex) {
        WellSample o = this.getWellSample(plateIndex, wellIndex, wellSampleIndex);
        o.setPosY(this.toRType(posY));
    }

    public void setWellSampleTimepoint(Integer timepoint, int plateIndex, int wellIndex, int wellSampleIndex) {
        WellSample o = this.getWellSample(plateIndex, wellIndex, wellSampleIndex);
        o.setTimepoint(this.toRType(timepoint));
    }

    public void setWellType(String type, int plateIndex, int wellIndex) {
        Well o = this.getWell(plateIndex, wellIndex);
        o.setType(this.toRType(type));
    }

    public long getExperimenterID() {
        try {
            return this.iAdmin.getEventContext().userId;
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public void writeFilesToFileStore(File[] files, Pixels pixels) {
        List originalFileList = pixels.linkedOriginalFileList();
        HashMap<String, OriginalFile> originalFileMap = new HashMap<String, OriginalFile>(originalFileList.size());
        for (OriginalFile originalFile : originalFileList) {
            String fileName = originalFile.getName().getValue();
            originalFileMap.put(fileName, originalFile);
        }
        byte[] buf = new byte[0x100000];
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            OriginalFile originalFile = (OriginalFile)originalFileMap.get(file.getName());
            if (originalFile == null) {
                this.log.warn((Object)("Cannot lookup original file with name: " + file.getAbsolutePath()));
            } else {
                FileInputStream stream = null;
                try {
                    try {
                        stream = new FileInputStream(file);
                        this.rawFileStore.setFileId(originalFile.getId().getValue());
                        int rlen = 0;
                        int offset = 0;
                        while (stream.available() != 0) {
                            rlen = stream.read(buf);
                            this.rawFileStore.write(buf, (long)offset, rlen);
                            offset += rlen;
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Object)"I/O or server error populating file store.", (Throwable)e);
                        if (stream == null) break;
                        try {
                            stream.close();
                        }
                        catch (Exception e2) {
                            this.log.error((Object)"I/O error closing stream.", (Throwable)e2);
                        }
                        break;
                    }
                }
                finally {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception e) {
                            this.log.error((Object)"I/O error closing stream.", (Throwable)e);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public long getRepositorySpace() {
        try {
            return this.iRepoInfo.getFreeSpaceInKilobytes();
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public void postProcess() {
        for (ModelProcessor processor : this.modelProcessors) {
            processor.process(this);
        }
    }

    public List<Pixels> saveToDB() {
        try {
            String s;
            Collection<IObjectContainer> containers = this.containerCache.values();
            IObjectContainer[] containerArray = containers.toArray(new IObjectContainer[containers.size()]);
            if (this.log.isDebugEnabled()) {
                for (LSID lSID : this.containerCache.keySet()) {
                    s = String.format("%s == %s,%s", lSID, this.containerCache.get((Object)lSID).sourceObject, this.containerCache.get((Object)lSID).LSID);
                    this.log.debug((Object)s);
                }
            }
            this.log.debug((Object)"Starting references....");
            if (this.log.isDebugEnabled()) {
                for (String string : this.referenceStringCache.keySet()) {
                    s = String.format("%s == %s", string, this.referenceStringCache.get(string));
                    this.log.debug((Object)s);
                }
                this.log.debug((Object)("containerCache contains " + this.containerCache.size() + " entries."));
                this.log.debug((Object)("referenceCache contains " + this.referenceCache.size() + " entries."));
            }
            this.delegate.updateObjects(containerArray);
            this.delegate.updateReferences(this.referenceStringCache);
            this.pixelsList = this.delegate.saveToDB();
            if (this.log.isDebugEnabled()) {
                for (Pixels pixels : this.pixelsList) {
                    long l = pixels.getId().getValue();
                    this.log.debug((Object)("Saving pixels id: " + l));
                }
            }
            return this.pixelsList;
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public Project getProject(long projectId) {
        try {
            return (Project)this.iQuery.get("Project", projectId);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends IObject> T getTarget(Class<T> klass, long id) {
        try {
            return (T)this.iQuery.get(klass.getName(), id);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public Dataset addDataset(String datasetName, String datasetDescription, Project project) {
        DatasetI dataset = new DatasetI();
        if (datasetName.length() != 0) {
            dataset.setName(this.toRType(datasetName));
        }
        if (datasetDescription.length() != 0) {
            dataset.setDescription(this.toRType(datasetDescription));
        }
        ProjectI p = new ProjectI(project.getId().getValue(), false);
        dataset.linkProject((Project)p);
        try {
            return (Dataset)this.iUpdate.saveAndReturnObject((IObject)dataset);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public List<Screen> getScreens() {
        try {
            List objects = this.iContainer.loadContainerHierarchy(Screen.class.getName(), null, null);
            ArrayList<Screen> screens = new ArrayList<Screen>(objects.size());
            for (IObject object : objects) {
                screens.add((Screen)object);
            }
            return screens;
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public List<Project> getProjects() {
        try {
            List objects = this.iContainer.loadContainerHierarchy(Project.class.getName(), null, null);
            ArrayList<Project> projects = new ArrayList<Project>(objects.size());
            for (IObject object : objects) {
                projects.add((Project)object);
            }
            return projects;
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public List<Dataset> getDatasets(Project p) {
        try {
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(p.getId().getValue());
            List objects = this.iContainer.loadContainerHierarchy(Project.class.getName(), ids, null);
            if (objects.size() > 0) {
                Project project = (Project)objects.get(0);
                return project.linkedDatasetList();
            }
            return null;
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public Project addProject(String projectName, String projectDescription) {
        ProjectI project = new ProjectI();
        if (projectName.length() != 0) {
            project.setName(this.toRType(projectName));
        }
        if (projectDescription.length() != 0) {
            project.setDescription(this.toRType(projectDescription));
        }
        try {
            return (Project)this.iUpdate.saveAndReturnObject((IObject)project);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public Screen addScreen(String screenName, String screenDescription) {
        ScreenI screen = new ScreenI();
        if (screenName.length() != 0) {
            screen.setName(this.toRType(screenName));
        }
        if (screenDescription.length() != 0) {
            screen.setDescription(this.toRType(screenDescription));
        }
        try {
            return (Screen)this.iUpdate.saveAndReturnObject((IObject)screen);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public void preparePixelsStore(List<Long> pixelsIds) {
        try {
            this.rawPixelStore.prepare(pixelsIds);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public void setPlane(Long pixId, byte[] arrayBuf, int z, int c, int t) throws ServerError {
        if (this.currentPixId != pixId) {
            this.rawPixelStore.setPixelsId(pixId.longValue(), true);
            this.currentPixId = pixId;
        }
        this.rawPixelStore.setPlane(arrayBuf, z, c, t);
    }

    public void setChannelGlobalMinMax(int channel, double minimum, double maximum, int series) {
        double[] globalMinMax;
        Object channelGlobalMinMax;
        Pixels pixels = (Pixels)this.getSourceObject(new LSID(Pixels.class, new int[]{series, 0}));
        if (this.imageChannelGlobalMinMax == null) {
            int imageCount = this.countCachedContainers(Image.class, new int[0]);
            this.imageChannelGlobalMinMax = new double[imageCount][][];
        }
        if ((channelGlobalMinMax = this.imageChannelGlobalMinMax[series]) == null) {
            double[][] dArrayArray = new double[pixels.getSizeC().getValue()][];
            channelGlobalMinMax = dArrayArray;
            this.imageChannelGlobalMinMax[series] = dArrayArray;
        }
        if ((globalMinMax = channelGlobalMinMax[channel]) == null) {
            globalMinMax = new double[2];
            this.imageChannelGlobalMinMax[series][channel] = globalMinMax;
        }
        globalMinMax[0] = minimum;
        globalMinMax[1] = maximum;
    }

    public void updatePixels(List<Pixels> pixelsList) {
        try {
            ArrayList<Pixels> objectList = new ArrayList<Pixels>(pixelsList.size());
            for (Pixels pixels : pixelsList) {
                pixels.unloadCollections();
                pixels.unloadDetails();
                ImageI unloadedImage = new ImageI(pixels.getImage().getId(), false);
                pixels.setImage((Image)unloadedImage);
                objectList.add(pixels);
            }
            this.iUpdate.saveArray(objectList);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        int i = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        StringBuffer out = new StringBuffer(in.length * 2);
        while (i < in.length) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
            ++i;
        }
        String rslt = new String(out);
        return rslt;
    }

    public void populateMinMax() {
        try {
            this.delegate.populateMinMax(this.imageChannelGlobalMinMax);
        }
        catch (ServerError e) {
            throw new RuntimeException(e);
        }
    }

    public void setExperimentDescription(String description, int experimentIndex) {
        Experiment o = this.getExperiment(experimentIndex);
        o.setDescription(this.toRType(description));
    }

    private Experiment getExperiment(int experimentIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("experimentIndex", experimentIndex);
        return this.getSourceObject(Experiment.class, indexes);
    }

    public void setExperimentID(String id, int experimentIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("experimentIndex", experimentIndex);
        IObjectContainer o = this.getIObjectContainer(Experiment.class, indexes);
        o.LSID = id;
    }

    public void setExperimentType(String type, int experimentIndex) {
        Experiment o = this.getExperiment(experimentIndex);
        o.setType((ExperimentType)this.getEnumeration(ExperimentType.class, type));
    }

    public void setExperimenterMembershipGroup(String group, int experimenterIndex, int groupRefIndex) {
    }

    public void setImageDefaultPixels(String defaultPixels, int imageIndex) {
    }

    public void setLogicalChannelOTF(String otf, int imageIndex, int logicalChannelIndex) {
        LSID key = new LSID(LogicalChannel.class, new int[]{imageIndex, logicalChannelIndex});
        this.referenceCache.put(key, new LSID(otf));
    }

    public void setOTFObjective(String objective, int instrumentIndex, int otfIndex) {
        LSID key = new LSID(OTF.class, new int[]{instrumentIndex, otfIndex});
        this.referenceCache.put(key, new LSID(objective));
    }

    public void setObjectiveSettingsCorrectionCollar(Float correctionCollar, int imageIndex) {
        ObjectiveSettings o = this.getObjectiveSettings(imageIndex);
        o.setCorrectionCollar(this.toRType(correctionCollar));
    }

    private ObjectiveSettings getObjectiveSettings(int imageIndex) {
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("imageIndex", imageIndex);
        return this.getSourceObject(ObjectiveSettings.class, indexes);
    }

    public void setObjectiveSettingsMedium(String medium, int imageIndex) {
        ObjectiveSettings o = this.getObjectiveSettings(imageIndex);
        o.setMedium((Medium)this.getEnumeration(Medium.class, medium));
    }

    public void setObjectiveSettingsObjective(String objective, int imageIndex) {
        LSID key = new LSID(ObjectiveSettings.class, new int[]{imageIndex});
        this.referenceCache.put(key, new LSID(objective));
    }

    public void setObjectiveSettingsRefractiveIndex(Float refractiveIndex, int imageIndex) {
        ObjectiveSettings o = this.getObjectiveSettings(imageIndex);
        o.setRefractiveIndex(this.toRType(refractiveIndex));
    }

    public void setEnumerationProvider(EnumerationProvider enumProvider) {
        this.enumProvider = enumProvider;
    }

    public EnumerationProvider getEnumerationProvider() {
        return this.enumProvider;
    }

    public void setInstanceProvider(InstanceProvider instanceProvider) {
        this.instanceProvider = instanceProvider;
    }

    public InstanceProvider getInstanceProvider() {
        return this.instanceProvider;
    }

    public void setChannelComponentPixels(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setCircleID(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setCircleCx(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setCircleCy(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setCircleR(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setCircleTransform(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setContactExperimenter(String arg0, int arg1) {
    }

    public void setDatasetDescription(String arg0, int arg1) {
    }

    public void setDatasetExperimenterRef(String arg0, int arg1) {
    }

    public void setDatasetGroupRef(String arg0, int arg1) {
    }

    public void setDatasetID(String arg0, int arg1) {
    }

    public void setDatasetLocked(Boolean arg0, int arg1) {
    }

    public void setDatasetName(String arg0, int arg1) {
    }

    public void setDatasetRefID(String arg0, int arg1, int arg2) {
    }

    public void setDetectorAmplificationGain(Float arg0, int arg1, int arg2) {
    }

    public void setDetectorZoom(Float arg0, int arg1, int arg2) {
    }

    public void setDichroicLotNumber(String arg0, int arg1, int arg2) {
    }

    public void setDichroicManufacturer(String arg0, int arg1, int arg2) {
    }

    public void setDichroicModel(String arg0, int arg1, int arg2) {
    }

    public void setDisplayOptionsDisplay(String arg0, int arg1) {
    }

    public void setEllipseID(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setEllipseCx(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setEllipseCy(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setEllipseRx(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setEllipseRy(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setEllipseTransform(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setEmFilterLotNumber(String arg0, int arg1, int arg2) {
    }

    public void setEmFilterManufacturer(String arg0, int arg1, int arg2) {
    }

    public void setEmFilterModel(String arg0, int arg1, int arg2) {
    }

    public void setEmFilterType(String arg0, int arg1, int arg2) {
    }

    public void setExFilterLotNumber(String arg0, int arg1, int arg2) {
    }

    public void setExFilterManufacturer(String arg0, int arg1, int arg2) {
    }

    public void setExFilterModel(String arg0, int arg1, int arg2) {
    }

    public void setExFilterType(String arg0, int arg1, int arg2) {
    }

    public void setExperimentExperimenterRef(String arg0, int arg1) {
    }

    public void setExperimenterOMEName(String arg0, int arg1) {
    }

    public void setFilterFilterWheel(String arg0, int arg1, int arg2) {
    }

    public void setFilterLotNumber(String arg0, int arg1, int arg2) {
    }

    public void setFilterManufacturer(String arg0, int arg1, int arg2) {
    }

    public void setFilterModel(String arg0, int arg1, int arg2) {
    }

    public void setFilterSetDichroic(String arg0, int arg1, int arg2) {
    }

    public void setFilterSetEmFilter(String arg0, int arg1, int arg2) {
    }

    public void setFilterSetExFilter(String arg0, int arg1, int arg2) {
    }

    public void setFilterSetLotNumber(String arg0, int arg1, int arg2) {
    }

    public void setFilterSetManufacturer(String arg0, int arg1, int arg2) {
    }

    public void setFilterSetModel(String arg0, int arg1, int arg2) {
    }

    public void setFilterType(String arg0, int arg1, int arg2) {
    }

    public void setGreyChannelBlackLevel(Float arg0, int arg1) {
    }

    public void setGreyChannelChannelNumber(Integer arg0, int arg1) {
    }

    public void setGreyChannelGamma(Float arg0, int arg1) {
    }

    public void setGreyChannelMapColorMap(String arg0, int arg1) {
    }

    public void setGreyChannelWhiteLevel(Float arg0, int arg1) {
    }

    public void setGreyChannelisOn(Boolean arg0, int arg1) {
    }

    public void setGroupName(String arg0, int arg1) {
    }

    public void setImageAcquiredPixels(String arg0, int arg1) {
    }

    public void setImageExperimentRef(String arg0, int arg1) {
    }

    public void setImageExperimenterRef(String arg0, int arg1) {
    }

    public void setImageGroupRef(String arg0, int arg1) {
    }

    public void setImageObjective(String arg0, int arg1) {
    }

    public void setLaserPockelCell(Boolean arg0, int arg1, int arg2) {
    }

    public void setLaserRepetitionRate(Boolean arg0, int arg1, int arg2) {
    }

    public void setLightSourceRefAttenuation(Float arg0, int arg1, int arg2, int arg3) {
    }

    public void setLightSourceRefLightSource(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setLightSourceRefWavelength(Integer arg0, int arg1, int arg2, int arg3) {
    }

    public void setLineID(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setLineTransform(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setLineX1(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setLineX2(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setLineY1(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setLineY2(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setLogicalChannelDetector(String arg0, int arg1, int arg2) {
    }

    public void setLogicalChannelFilterSet(String arg0, int arg1, int arg2) {
    }

    public void setLogicalChannelLightSource(String arg0, int arg1, int arg2) {
    }

    public void setLogicalChannelSecondaryEmissionFilter(String arg0, int arg1, int arg2) {
    }

    public void setLogicalChannelSecondaryExcitationFilter(String arg0, int arg1, int arg2) {
    }

    public void setMaskID(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setMaskPixelsBigEndian(Boolean arg0, int arg1, int arg2, int arg3) {
    }

    public void setMaskPixelsBinData(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setMaskPixelsExtendedPixelType(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setMaskPixelsID(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setMaskPixelsSizeX(Integer arg0, int arg1, int arg2, int arg3) {
    }

    public void setMaskPixelsSizeY(Integer arg0, int arg1, int arg2, int arg3) {
    }

    public void setMaskHeight(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setMaskTransform(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setMaskWidth(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setMaskX(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setMaskY(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setMicrobeamManipulationExperimenterRef(String arg0, int arg1, int arg2) {
    }

    public void setMicrobeamManipulationID(String arg0, int arg1, int arg2) {
    }

    public void setMicrobeamManipulationRefID(String arg0, int arg1, int arg2) {
    }

    public void setMicrobeamManipulationType(String arg0, int arg1, int arg2) {
    }

    public void setMicroscopeID(String arg0, int arg1) {
    }

    public void setMicroscopeManufacturer(String arg0, int arg1) {
    }

    public void setMicroscopeModel(String arg0, int arg1) {
    }

    public void setMicroscopeSerialNumber(String arg0, int arg1) {
    }

    public void setMicroscopeType(String arg0, int arg1) {
    }

    public void setOTFBinaryFile(String arg0, int arg1, int arg2) {
    }

    public void setPlaneHashSHA1(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setPlaneID(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setPlateRefSample(Integer arg0, int arg1, int arg2) {
    }

    public void setPlateRefWell(String arg0, int arg1, int arg2) {
    }

    public void setPointID(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setPointCx(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setPointCy(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setPointR(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setPointTransform(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setPolygonID(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setPolygonPoints(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setPolygonTransform(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setPolylineID(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setPolylinePoints(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setPolylineTransform(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setProjectDescription(String arg0, int arg1) {
    }

    public void setProjectExperimenterRef(String arg0, int arg1) {
    }

    public void setProjectGroupRef(String arg0, int arg1) {
    }

    public void setProjectID(String arg0, int arg1) {
    }

    public void setProjectName(String arg0, int arg1) {
    }

    public void setProjectRefID(String arg0, int arg1, int arg2) {
    }

    public void setPumpLightSource(String arg0, int arg1, int arg2) {
    }

    public void setROIRefID(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setRectID(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setRectHeight(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setRectTransform(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setRectWidth(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setRectX(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setRectY(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setRegionID(String arg0, int arg1, int arg2) {
    }

    public void setRegionName(String arg0, int arg1, int arg2) {
    }

    public void setRegionTag(String arg0, int arg1, int arg2) {
    }

    public void setScreenDescription(String arg0, int arg1) {
    }

    public void setScreenExtern(String arg0, int arg1) {
    }

    public void setScreenReagentSetIdentifier(String arg0, int arg1) {
    }

    public void setScreenRefID(String arg0, int arg1, int arg2) {
    }

    public void setShapeID(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeTheT(Integer arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeTheZ(Integer arg0, int arg1, int arg2, int arg3) {
    }

    public void setThumbnailID(String arg0, int arg1) {
    }

    public void setThumbnailMIMEtype(String arg0, int arg1) {
    }

    public void setThumbnailHref(String arg0, int arg1) {
    }

    public void setTransmittanceRangeCutIn(Integer arg0, int arg1, int arg2) {
    }

    public void setTransmittanceRangeCutInTolerance(Integer arg0, int arg1, int arg2) {
    }

    public void setTransmittanceRangeCutOut(Integer arg0, int arg1, int arg2) {
    }

    public void setTransmittanceRangeCutOutTolerance(Integer arg0, int arg1, int arg2) {
    }

    public void setTransmittanceRangeTransmittance(Integer arg0, int arg1, int arg2) {
    }

    public void setWellReagent(String reagent, int plateIndex, int wellIndex) {
        LSID key = new LSID(Well.class, new int[]{plateIndex, wellIndex});
        this.referenceCache.put(key, new LSID(reagent));
    }

    public void setWellSampleImageRef(String image, int plateIndex, int wellIndex, int wellSampleIndex) {
        LSID key = new LSID(WellSample.class, new int[]{plateIndex, wellIndex, wellSampleIndex});
        this.referenceCache.put(key, new LSID(image));
    }

    public void setWellSampleRefID(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setPlateColumnNamingConvention(String arg0, int arg1) {
    }

    public void setPlateRowNamingConvention(String arg0, int arg1) {
    }

    public void setPlateWellOriginX(Double arg0, int arg1) {
    }

    public void setPlateWellOriginY(Double arg0, int arg1) {
    }

    public void setPathD(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setPathID(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeBaselineShift(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeDirection(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeFillColor(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeFillOpacity(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeFillRule(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeFontFamily(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeFontSize(Integer arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeFontStretch(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeFontStyle(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeFontVariant(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeFontWeight(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeG(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeGlyphOrientationVertical(Integer arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeLocked(Boolean arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeStrokeAttribute(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeStrokeColor(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeStrokeDashArray(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeStrokeLineCap(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeStrokeLineJoin(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeStrokeMiterLimit(Integer arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeStrokeOpacity(Float arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeStrokeWidth(Integer arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeText(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeTextAnchor(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeTextDecoration(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeTextFill(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeTextStroke(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeVectorEffect(String arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeVisibility(Boolean arg0, int arg1, int arg2, int arg3) {
    }

    public void setShapeWritingMode(String arg0, int arg1, int arg2, int arg3) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OMEXMLModelComparator
    implements Comparator<LSID> {
        private RuleBasedCollator stringComparator = (RuleBasedCollator)Collator.getInstance(Locale.ENGLISH);

        @Override
        public int compare(LSID x, LSID y) {
            int yVal;
            if (x.equals((Object)y)) {
                return 0;
            }
            Class xClass = x.getJavaClass();
            Class yClass = y.getJavaClass();
            int[] xIndexes = x.getIndexes();
            int[] yIndexes = y.getIndexes();
            if (xClass == null || yClass == null) {
                return this.stringComparator.compare(x.toString(), y.toString());
            }
            int xVal = this.getValue(xClass, xIndexes.length);
            int retval = xVal - (yVal = this.getValue(yClass, yIndexes.length));
            if (retval == 0) {
                if (!xClass.equals(yClass)) {
                    return this.stringComparator.compare(x.toString(), y.toString());
                }
                int i = 0;
                while (i < xIndexes.length) {
                    int difference = xIndexes[i] - yIndexes[i];
                    if (difference != 0) {
                        return difference;
                    }
                    ++i;
                }
                return 0;
            }
            return retval;
        }

        public int getValue(Class<? extends IObject> klass, int indexes) {
            if (klass.equals(Pixels.class)) {
                return 1;
            }
            if (klass.equals(DetectorSettings.class) || klass.equals(LightSettings.class)) {
                return 3;
            }
            return indexes;
        }
    }
}

