/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import org.apache.poi.ss.util.CellReference;

public abstract class CellRangeAddressBase {
    private static final int LAST_ROW_INDEX = 65535;
    private static final int LAST_COLUMN_INDEX = 255;
    private int _firstRow;
    private int _firstCol;
    private int _lastRow;
    private int _lastCol;

    protected CellRangeAddressBase(int firstRow, int lastRow, int firstCol, int lastCol) {
        if (!CellRangeAddressBase.isValid(firstRow, lastRow, firstCol, lastCol)) {
            throw new IllegalArgumentException("invalid cell range (" + firstRow + ", " + lastRow + ", " + firstCol + ", " + lastCol + ")");
        }
        this._firstRow = firstRow;
        this._lastRow = lastRow;
        this._firstCol = firstCol;
        this._lastCol = lastCol;
    }

    private static boolean isValid(int firstRow, int lastRow, int firstColumn, int lastColumn) {
        if (lastRow < 0 || lastRow > 65535) {
            return false;
        }
        if (firstRow < 0 || firstRow > 65535) {
            return false;
        }
        if (lastColumn < 0 || lastColumn > 255) {
            return false;
        }
        return firstColumn >= 0 && firstColumn <= 255;
    }

    public final boolean isFullColumnRange() {
        return this._firstRow == 0 && this._lastRow == 65535;
    }

    public final boolean isFullRowRange() {
        return this._firstCol == 0 && this._lastCol == 255;
    }

    public final int getFirstColumn() {
        return this._firstCol;
    }

    public final int getFirstRow() {
        return this._firstRow;
    }

    public final int getLastColumn() {
        return this._lastCol;
    }

    public final int getLastRow() {
        return this._lastRow;
    }

    public final void setFirstColumn(int firstCol) {
        this._firstCol = firstCol;
    }

    public final void setFirstRow(int firstRow) {
        this._firstRow = firstRow;
    }

    public final void setLastColumn(int lastCol) {
        this._lastCol = lastCol;
    }

    public final void setLastRow(int lastRow) {
        this._lastRow = lastRow;
    }

    public int getNumberOfCells() {
        return (this._lastRow - this._firstRow + 1) * (this._lastCol - this._firstCol + 1);
    }

    public final String toString() {
        CellReference crA = new CellReference(this._firstRow, this._firstCol);
        CellReference crB = new CellReference(this._lastRow, this._lastCol);
        return this.getClass().getName() + " [" + crA.formatAsString() + ":" + crB.formatAsString() + "]";
    }
}

