/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.ConcatPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.EqualPtg;
import org.apache.poi.hssf.record.formula.ExpPtg;
import org.apache.poi.hssf.record.formula.FuncPtg;
import org.apache.poi.hssf.record.formula.FuncVarPtg;
import org.apache.poi.hssf.record.formula.GreaterEqualPtg;
import org.apache.poi.hssf.record.formula.GreaterThanPtg;
import org.apache.poi.hssf.record.formula.LessEqualPtg;
import org.apache.poi.hssf.record.formula.LessThanPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.NotEqualPtg;
import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.PercentPtg;
import org.apache.poi.hssf.record.formula.PowerPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.RangePtg;
import org.apache.poi.hssf.record.formula.SubtractPtg;
import org.apache.poi.hssf.record.formula.UnaryMinusPtg;
import org.apache.poi.hssf.record.formula.UnaryPlusPtg;
import org.apache.poi.hssf.record.formula.eval.AddEval;
import org.apache.poi.hssf.record.formula.eval.ConcatEval;
import org.apache.poi.hssf.record.formula.eval.DivideEval;
import org.apache.poi.hssf.record.formula.eval.EqualEval;
import org.apache.poi.hssf.record.formula.eval.FuncVarEval;
import org.apache.poi.hssf.record.formula.eval.GreaterEqualEval;
import org.apache.poi.hssf.record.formula.eval.GreaterThanEval;
import org.apache.poi.hssf.record.formula.eval.LessEqualEval;
import org.apache.poi.hssf.record.formula.eval.LessThanEval;
import org.apache.poi.hssf.record.formula.eval.MultiplyEval;
import org.apache.poi.hssf.record.formula.eval.NotEqualEval;
import org.apache.poi.hssf.record.formula.eval.OperationEval;
import org.apache.poi.hssf.record.formula.eval.PercentEval;
import org.apache.poi.hssf.record.formula.eval.PowerEval;
import org.apache.poi.hssf.record.formula.eval.RangeEval;
import org.apache.poi.hssf.record.formula.eval.SubtractEval;
import org.apache.poi.hssf.record.formula.eval.UnaryMinusEval;
import org.apache.poi.hssf.record.formula.eval.UnaryPlusEval;

final class OperationEvaluatorFactory {
    private static final Class[] OPERATION_CONSTRUCTOR_CLASS_ARRAY = new Class[]{Ptg.class};
    private static final Map _constructorsByPtgClass = OperationEvaluatorFactory.initialiseConstructorsMap();
    private static final Map _instancesByPtgClass = OperationEvaluatorFactory.initialiseInstancesMap();

    private OperationEvaluatorFactory() {
    }

    private static Map initialiseConstructorsMap() {
        HashMap m = new HashMap(32);
        OperationEvaluatorFactory.add(m, ConcatPtg.class, ConcatEval.class);
        OperationEvaluatorFactory.add(m, FuncPtg.class, FuncVarEval.class);
        OperationEvaluatorFactory.add(m, FuncVarPtg.class, FuncVarEval.class);
        return m;
    }

    private static Map initialiseInstancesMap() {
        HashMap m = new HashMap(32);
        OperationEvaluatorFactory.add(m, EqualPtg.class, EqualEval.instance);
        OperationEvaluatorFactory.add(m, GreaterEqualPtg.class, GreaterEqualEval.instance);
        OperationEvaluatorFactory.add(m, GreaterThanPtg.class, GreaterThanEval.instance);
        OperationEvaluatorFactory.add(m, LessEqualPtg.class, LessEqualEval.instance);
        OperationEvaluatorFactory.add(m, LessThanPtg.class, LessThanEval.instance);
        OperationEvaluatorFactory.add(m, NotEqualPtg.class, NotEqualEval.instance);
        OperationEvaluatorFactory.add(m, AddPtg.class, AddEval.instance);
        OperationEvaluatorFactory.add(m, DividePtg.class, DivideEval.instance);
        OperationEvaluatorFactory.add(m, MultiplyPtg.class, MultiplyEval.instance);
        OperationEvaluatorFactory.add(m, PercentPtg.class, PercentEval.instance);
        OperationEvaluatorFactory.add(m, PowerPtg.class, PowerEval.instance);
        OperationEvaluatorFactory.add(m, SubtractPtg.class, SubtractEval.instance);
        OperationEvaluatorFactory.add(m, UnaryMinusPtg.class, UnaryMinusEval.instance);
        OperationEvaluatorFactory.add(m, UnaryPlusPtg.class, UnaryPlusEval.instance);
        OperationEvaluatorFactory.add(m, RangePtg.class, RangeEval.instance);
        return m;
    }

    private static void add(Map m, Class ptgClass, OperationEval evalInstance) {
        if (!Ptg.class.isAssignableFrom(ptgClass)) {
            throw new IllegalArgumentException("Expected Ptg subclass");
        }
        m.put(ptgClass, evalInstance);
    }

    private static void add(Map m, Class ptgClass, Class evalClass) {
        Constructor constructor;
        if (!Ptg.class.isAssignableFrom(ptgClass)) {
            throw new IllegalArgumentException("Expected Ptg subclass");
        }
        if (!OperationEval.class.isAssignableFrom(evalClass)) {
            throw new IllegalArgumentException("Expected OperationEval subclass");
        }
        if (!Modifier.isPublic(evalClass.getModifiers())) {
            throw new RuntimeException("Eval class must be public");
        }
        if (Modifier.isAbstract(evalClass.getModifiers())) {
            throw new RuntimeException("Eval class must not be abstract");
        }
        try {
            constructor = evalClass.getDeclaredConstructor(OPERATION_CONSTRUCTOR_CLASS_ARRAY);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Missing constructor");
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            throw new RuntimeException("Eval constructor must be public");
        }
        m.put(ptgClass, constructor);
    }

    public static OperationEval create(OperationPtg ptg) {
        if (ptg == null) {
            throw new IllegalArgumentException("ptg must not be null");
        }
        Class<?> ptgClass = ptg.getClass();
        Object result = _instancesByPtgClass.get(ptgClass);
        if (result != null) {
            return (OperationEval)result;
        }
        Constructor constructor = (Constructor)_constructorsByPtgClass.get(ptgClass);
        if (constructor == null) {
            if (ptgClass == ExpPtg.class) {
                throw new RuntimeException("ExpPtg currently not supported");
            }
            throw new RuntimeException("Unexpected operation ptg class (" + ptgClass.getName() + ")");
        }
        Object[] initargs = new Object[]{ptg};
        try {
            result = constructor.newInstance(initargs);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return (OperationEval)result;
    }
}

