/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.DataInputBlock;
import org.apache.poi.poifs.storage.ListManagedBlock;

public final class SmallDocumentBlock
implements BlockWritable,
ListManagedBlock {
    private static final int BLOCK_SHIFT = 6;
    private byte[] _data = new byte[64];
    private static final byte _default_fill = -1;
    private static final int _block_size = 64;
    private static final int BLOCK_MASK = 63;
    private static final int _blocks_per_big_block = 8;

    private SmallDocumentBlock(byte[] data, int index) {
        this();
        System.arraycopy(data, index * 64, this._data, 0, 64);
    }

    private SmallDocumentBlock() {
    }

    public static SmallDocumentBlock[] convert(byte[] array, int size) {
        SmallDocumentBlock[] rval = new SmallDocumentBlock[(size + 64 - 1) / 64];
        int offset = 0;
        for (int k = 0; k < rval.length; ++k) {
            rval[k] = new SmallDocumentBlock();
            if (offset < array.length) {
                int length = Math.min(64, array.length - offset);
                System.arraycopy(array, offset, rval[k]._data, 0, length);
                if (length != 64) {
                    Arrays.fill(rval[k]._data, length, 64, (byte)-1);
                }
            } else {
                Arrays.fill(rval[k]._data, (byte)-1);
            }
            offset += 64;
        }
        return rval;
    }

    public static int fill(List blocks) {
        int count;
        int big_block_count = (count + 8 - 1) / 8;
        int full_count = big_block_count * 8;
        for (count = blocks.size(); count < full_count; ++count) {
            blocks.add(SmallDocumentBlock.makeEmptySmallDocumentBlock());
        }
        return big_block_count;
    }

    public static SmallDocumentBlock[] convert(BlockWritable[] store, int size) throws IOException, ArrayIndexOutOfBoundsException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (int j = 0; j < store.length; ++j) {
            store[j].writeBlocks(stream);
        }
        byte[] data = stream.toByteArray();
        SmallDocumentBlock[] rval = new SmallDocumentBlock[SmallDocumentBlock.convertToBlockCount(size)];
        for (int index = 0; index < rval.length; ++index) {
            rval[index] = new SmallDocumentBlock(data, index);
        }
        return rval;
    }

    public static List extract(ListManagedBlock[] blocks) throws IOException {
        ArrayList<SmallDocumentBlock> sdbs = new ArrayList<SmallDocumentBlock>();
        for (int j = 0; j < blocks.length; ++j) {
            byte[] data = blocks[j].getData();
            for (int k = 0; k < 8; ++k) {
                sdbs.add(new SmallDocumentBlock(data, k));
            }
        }
        return sdbs;
    }

    public static DataInputBlock getDataInputBlock(SmallDocumentBlock[] blocks, int offset) {
        int firstBlockIndex = offset >> 6;
        int firstBlockOffset = offset & 0x3F;
        return new DataInputBlock(blocks[firstBlockIndex]._data, firstBlockOffset);
    }

    public static int calcSize(int size) {
        return size * 64;
    }

    private static SmallDocumentBlock makeEmptySmallDocumentBlock() {
        SmallDocumentBlock block = new SmallDocumentBlock();
        Arrays.fill(block._data, (byte)-1);
        return block;
    }

    private static int convertToBlockCount(int size) {
        return (size + 64 - 1) / 64;
    }

    public void writeBlocks(OutputStream stream) throws IOException {
        stream.write(this._data);
    }

    public byte[] getData() throws IOException {
        return this._data;
    }
}

