/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Name;

public final class HSSFName
implements Name {
    private HSSFWorkbook _book;
    private NameRecord _definedNameRec;

    HSSFName(HSSFWorkbook book, NameRecord name) {
        this._book = book;
        this._definedNameRec = name;
    }

    public String getSheetName() {
        int indexToExternSheet = this._definedNameRec.getExternSheetNumber();
        return this._book.getWorkbook().findSheetNameFromExternSheet(indexToExternSheet);
    }

    public String getNameName() {
        return this._definedNameRec.getNameText();
    }

    public void setNameName(String nameName) {
        this._definedNameRec.setNameText(nameName);
        Workbook wb = this._book.getWorkbook();
        for (int i = wb.getNumNames() - 1; i >= 0; --i) {
            NameRecord rec = wb.getNameRecord(i);
            if (rec == this._definedNameRec || !rec.getNameText().equalsIgnoreCase(this.getNameName())) continue;
            throw new IllegalArgumentException("The workbook already contains this name (case-insensitive)");
        }
    }

    public String getReference() {
        return this.getRefersToFormula();
    }

    public void setReference(String ref) {
        this.setRefersToFormula(ref);
    }

    public void setRefersToFormula(String formulaText) {
        Ptg[] ptgs = HSSFFormulaParser.parse(formulaText, this._book);
        this._definedNameRec.setNameDefinition(ptgs);
    }

    public String getRefersToFormula() {
        if (this._definedNameRec.isFunctionName()) {
            throw new IllegalStateException("Only applicable to named ranges");
        }
        return HSSFFormulaParser.toFormulaString(this._book, this._definedNameRec.getNameDefinition());
    }

    public boolean isDeleted() {
        String formulaText = this.getRefersToFormula();
        return formulaText.indexOf("#REF!") != -1;
    }

    public boolean isFunctionName() {
        return this._definedNameRec.isFunctionName();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this._definedNameRec.getNameText());
        sb.append("]");
        return sb.toString();
    }
}

