/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Arrays;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.StringUtil;

public final class WriteAccessRecord
extends StandardRecord {
    public static final short sid = 92;
    private static final byte PAD_CHAR = 32;
    private static final int DATA_SIZE = 112;
    private String field_1_username;
    private byte[] padding;

    public WriteAccessRecord() {
        this.setUsername("");
        this.padding = new byte[109];
    }

    public WriteAccessRecord(RecordInputStream in) {
        if (in.remaining() > 112) {
            throw new RecordFormatException("Expected data size (112) but got (" + in.remaining() + ")");
        }
        int nChars = in.readUShort();
        int is16BitFlag = in.readUByte();
        int expectedPadSize = 109;
        if ((is16BitFlag & 1) == 0) {
            this.field_1_username = StringUtil.readCompressedUnicode(in, nChars);
            expectedPadSize -= nChars;
        } else {
            this.field_1_username = StringUtil.readUnicodeLE(in, nChars);
            expectedPadSize -= nChars * 2;
        }
        this.padding = new byte[expectedPadSize];
        int padSize = in.remaining();
        in.readFully(this.padding, 0, padSize);
        if (padSize < expectedPadSize) {
            Arrays.fill(this.padding, padSize, expectedPadSize, (byte)32);
        }
    }

    public void setUsername(String username) {
        boolean is16bit = StringUtil.hasMultibyte(username);
        int encodedByteCount = 3 + username.length() * (is16bit ? 2 : 1);
        int paddingSize = 112 - encodedByteCount;
        if (paddingSize < 0) {
            throw new IllegalArgumentException("Name is too long: " + username);
        }
        this.padding = new byte[paddingSize];
        Arrays.fill(this.padding, (byte)32);
        this.field_1_username = username;
    }

    public String getUsername() {
        return this.field_1_username;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[WRITEACCESS]\n");
        buffer.append("    .name            = ").append(this.field_1_username.toString()).append("\n");
        buffer.append("[/WRITEACCESS]\n");
        return buffer.toString();
    }

    public void serialize(LittleEndianOutput out) {
        String username = this.getUsername();
        boolean is16bit = StringUtil.hasMultibyte(username);
        out.writeShort(username.length());
        out.writeByte(is16bit ? 1 : 0);
        if (is16bit) {
            StringUtil.putUnicodeLE(username, out);
        } else {
            StringUtil.putCompressedUnicode(username, out);
        }
        out.write(this.padding);
    }

    protected int getDataSize() {
        return 112;
    }

    public short getSid() {
        return 92;
    }
}

