/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianInputStream;

public final class RecordInputStream
extends InputStream
implements LittleEndianInput {
    public static final short MAX_RECORD_DATA_SIZE = 8224;
    private static final int INVALID_SID_VALUE = -1;
    private static final int DATA_LEN_NEEDS_TO_BE_READ = -1;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final LittleEndianInput _le;
    private int _currentSid;
    private int _currentDataLength;
    private int _nextSid;
    private int _currentDataOffset;

    public RecordInputStream(InputStream in) throws RecordFormatException {
        this._le = in instanceof LittleEndianInput ? (LittleEndianInput)((Object)in) : new LittleEndianInputStream(in);
        this._nextSid = this.readNextSid();
    }

    public int available() {
        return this.remaining();
    }

    public int read() {
        this.checkRecordPosition(1);
        ++this._currentDataOffset;
        return this._le.readUByte();
    }

    public int read(byte[] b, int off, int len) {
        int limit = Math.min(len, this.remaining());
        if (limit == 0) {
            return 0;
        }
        this.readFully(b, off, limit);
        return limit;
    }

    public short getSid() {
        return (short)this._currentSid;
    }

    public boolean hasNextRecord() {
        if (this._currentDataLength != -1 && this._currentDataLength != this._currentDataOffset) {
            System.out.println("WARN. Unread " + this.remaining() + " bytes of record 0x" + Integer.toHexString(this._currentSid));
            while (this._currentDataOffset < this._currentDataLength) {
                this.readByte();
            }
        }
        if (this._currentDataLength != -1) {
            this._nextSid = this.readNextSid();
        }
        return this._nextSid != -1;
    }

    private int readNextSid() {
        int nAvailable = this._le.available();
        if (nAvailable < 4) {
            if (nAvailable > 0) {
                // empty if block
            }
            return -1;
        }
        int result = this._le.readUShort();
        if (result == -1) {
            throw new RecordFormatException("Found invalid sid (" + result + ")");
        }
        this._currentDataLength = -1;
        return result;
    }

    public void nextRecord() throws RecordFormatException {
        if (this._nextSid == -1) {
            throw new IllegalStateException("EOF - next record not available");
        }
        if (this._currentDataLength != -1) {
            throw new IllegalStateException("Cannot call nextRecord() without checking hasNextRecord() first");
        }
        this._currentSid = this._nextSid;
        this._currentDataOffset = 0;
        this._currentDataLength = this._le.readUShort();
        if (this._currentDataLength > 8224) {
            throw new RecordFormatException("The content of an excel record cannot exceed 8224 bytes");
        }
    }

    private void checkRecordPosition(int requiredByteCount) {
        int nAvailable = this.remaining();
        if (nAvailable >= requiredByteCount) {
            return;
        }
        if (nAvailable == 0 && this.isContinueNext()) {
            this.nextRecord();
            return;
        }
        throw new RecordFormatException("Not enough data (" + nAvailable + ") to read requested (" + requiredByteCount + ") bytes");
    }

    public byte readByte() {
        this.checkRecordPosition(1);
        ++this._currentDataOffset;
        return this._le.readByte();
    }

    public short readShort() {
        this.checkRecordPosition(2);
        this._currentDataOffset += 2;
        return this._le.readShort();
    }

    public int readInt() {
        this.checkRecordPosition(4);
        this._currentDataOffset += 4;
        return this._le.readInt();
    }

    public long readLong() {
        this.checkRecordPosition(8);
        this._currentDataOffset += 8;
        return this._le.readLong();
    }

    public int readUByte() {
        return this.readByte() & 0xFF;
    }

    public int readUShort() {
        this.checkRecordPosition(2);
        this._currentDataOffset += 2;
        return this._le.readUShort();
    }

    public double readDouble() {
        this.checkRecordPosition(8);
        this._currentDataOffset += 8;
        long valueLongBits = this._le.readLong();
        double result = Double.longBitsToDouble(valueLongBits);
        if (Double.isNaN(result)) {
            throw new RuntimeException("Did not expect to read NaN");
        }
        return result;
    }

    public void readFully(byte[] buf) {
        this.readFully(buf, 0, buf.length);
    }

    public void readFully(byte[] buf, int off, int len) {
        this.checkRecordPosition(len);
        this._le.readFully(buf, off, len);
        this._currentDataOffset += len;
    }

    public String readString() {
        int requestedLength = this.readUShort();
        byte compressFlag = this.readByte();
        return this.readStringCommon(requestedLength, compressFlag == 0);
    }

    public String readUnicodeLEString(int requestedLength) {
        return this.readStringCommon(requestedLength, false);
    }

    public String readCompressedUnicode(int requestedLength) {
        return this.readStringCommon(requestedLength, true);
    }

    private String readStringCommon(int requestedLength, boolean pIsCompressedEncoding) {
        if (requestedLength < 0 || requestedLength > 0x100000) {
            throw new IllegalArgumentException("Bad requested string length (" + requestedLength + ")");
        }
        char[] buf = new char[requestedLength];
        boolean isCompressedEncoding = pIsCompressedEncoding;
        int curLen = 0;
        while (true) {
            char ch;
            int availableChars;
            int n = availableChars = isCompressedEncoding ? this.remaining() : this.remaining() / 2;
            if (requestedLength - curLen <= availableChars) {
                while (curLen < requestedLength) {
                    ch = isCompressedEncoding ? (char)this.readUByte() : (char)this.readShort();
                    buf[curLen] = ch;
                    ++curLen;
                }
                return new String(buf);
            }
            while (availableChars > 0) {
                ch = isCompressedEncoding ? (char)this.readUByte() : (char)this.readShort();
                buf[curLen] = ch;
                ++curLen;
                --availableChars;
            }
            if (!this.isContinueNext()) {
                throw new RecordFormatException("Expected to find a ContinueRecord in order to read remaining " + (requestedLength - curLen) + " of " + requestedLength + " chars");
            }
            if (this.remaining() != 0) {
                throw new RecordFormatException("Odd number of bytes(" + this.remaining() + ") left behind");
            }
            this.nextRecord();
            byte compressFlag = this.readByte();
            isCompressedEncoding = compressFlag == 0;
        }
    }

    public byte[] readRemainder() {
        int size = this.remaining();
        if (size == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[size];
        this.readFully(result);
        return result;
    }

    public byte[] readAllContinuedRemainder() {
        ByteArrayOutputStream out = new ByteArrayOutputStream(16448);
        while (true) {
            byte[] b = this.readRemainder();
            out.write(b, 0, b.length);
            if (!this.isContinueNext()) break;
            this.nextRecord();
        }
        return out.toByteArray();
    }

    public int remaining() {
        if (this._currentDataLength == -1) {
            return 0;
        }
        return this._currentDataLength - this._currentDataOffset;
    }

    private boolean isContinueNext() {
        if (this._currentDataLength != -1 && this._currentDataOffset != this._currentDataLength) {
            throw new IllegalStateException("Should never be called before end of current record");
        }
        if (!this.hasNextRecord()) {
            return false;
        }
        return this._nextSid == 60;
    }
}

