/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.dev;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.util.CellRangeAddress;

public class HSSF {
    private String filename = null;
    protected HSSFWorkbook hssfworkbook = null;

    public HSSF(String filename) throws IOException {
        this.filename = filename;
        POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(filename));
        this.hssfworkbook = new HSSFWorkbook(fs);
    }

    public HSSF(String filename, boolean write) throws IOException {
        short cellnum;
        int rownum = 0;
        FileOutputStream out = new FileOutputStream(filename);
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet s = wb.createSheet();
        HSSFRow r = null;
        HSSFCell c = null;
        HSSFCellStyle cs = wb.createCellStyle();
        HSSFCellStyle cs2 = wb.createCellStyle();
        HSSFCellStyle cs3 = wb.createCellStyle();
        HSSFFont f = wb.createFont();
        HSSFFont f2 = wb.createFont();
        f.setFontHeightInPoints((short)12);
        f.setColor((short)10);
        f.setBoldweight((short)700);
        f2.setFontHeightInPoints((short)10);
        f2.setColor((short)15);
        f2.setBoldweight((short)700);
        cs.setFont(f);
        cs.setDataFormat(HSSFDataFormat.getBuiltinFormat("($#,##0_);[Red]($#,##0)"));
        cs2.setBorderBottom((short)1);
        cs2.setFillPattern((short)1);
        cs2.setFillForegroundColor((short)10);
        cs2.setFont(f2);
        wb.setSheetName(0, "HSSF Test");
        for (rownum = 0; rownum < 300; rownum = (int)((short)(rownum + 1))) {
            r = s.createRow(rownum);
            if (rownum % 2 == 0) {
                r.setHeight((short)585);
            }
            for (cellnum = 0; cellnum < 50; cellnum = (short)(cellnum + 2)) {
                c = r.createCell(cellnum, 0);
                c.setCellValue((double)(rownum * 10000 + cellnum) + ((double)rownum / 1000.0 + (double)cellnum / 10000.0));
                if (rownum % 2 == 0) {
                    c.setCellStyle(cs);
                }
                c = r.createCell(cellnum + 1, 1);
                c.setCellValue(new HSSFRichTextString("TEST"));
                s.setColumnWidth(cellnum + 1, 8000);
                if (rownum % 2 != 0) continue;
                c.setCellStyle(cs2);
            }
        }
        rownum = (short)(rownum + 1);
        rownum = (short)(rownum + 1);
        r = s.createRow(rownum);
        cs3.setBorderBottom((short)5);
        for (cellnum = 0; cellnum < 50; cellnum = (short)(cellnum + 1)) {
            c = r.createCell(cellnum, 3);
            c.setCellStyle(cs3);
        }
        s.addMergedRegion(new CellRangeAddress(0, 3, 0, 3));
        s.addMergedRegion(new CellRangeAddress(100, 110, 100, 110));
        s = wb.createSheet();
        wb.setSheetName(1, "DeletedSheet");
        wb.removeSheetAt(1);
        wb.write(out);
        out.close();
    }

    public HSSF(String infile, String outfile, boolean write) throws IOException {
        this.filename = infile;
        POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(this.filename));
        this.hssfworkbook = new HSSFWorkbook(fs);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            try {
                HSSF hssf = new HSSF(args[0]);
                System.out.println("Data dump:\n");
                HSSFWorkbook wb = hssf.hssfworkbook;
                for (int k = 0; k < wb.getNumberOfSheets(); ++k) {
                    HSSFSheet sheet = wb.getSheetAt(k);
                    int rows = sheet.getPhysicalNumberOfRows();
                    System.out.println("Sheet " + k + " \"" + wb.getSheetName(k) + "\" has " + rows + " row(s).");
                    for (int r = 0; r < rows; ++r) {
                        int cells;
                        HSSFRow row = sheet.getRow(r);
                        int n = cells = row != null ? row.getPhysicalNumberOfCells() : 0;
                        if (row != null) {
                            System.out.println("\nROW " + row.getRowNum() + " has " + cells + " cell(s).");
                        }
                        for (int c = 0; c < cells; ++c) {
                            HSSFCell cell = row.getCell(c);
                            String value = null;
                            switch (cell.getCellType()) {
                                case 2: {
                                    value = "FORMULA value=" + cell.getCellFormula();
                                    break;
                                }
                                case 0: {
                                    value = "NUMERIC value=" + cell.getNumericCellValue();
                                    break;
                                }
                                case 1: {
                                    value = "STRING value=" + cell.getStringCellValue();
                                    break;
                                }
                            }
                            System.out.println("CELL col=" + cell.getCellNum() + " VALUE=" + value);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (args.length == 2) {
            if (args[1].toLowerCase().equals("write")) {
                System.out.println("Write mode");
                try {
                    long time = System.currentTimeMillis();
                    HSSF hssf = new HSSF(args[0], true);
                    System.out.println("" + (System.currentTimeMillis() - time) + " ms generation time");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("readwrite test");
                try {
                    HSSF hssf = new HSSF(args[0]);
                    HSSFWorkbook wb = hssf.hssfworkbook;
                    FileOutputStream stream = new FileOutputStream(args[1]);
                    wb.write(stream);
                    stream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (args.length == 3 && args[2].toLowerCase().equals("modify1")) {
            try {
                HSSFRow row;
                int k;
                HSSF hssf = new HSSF(args[0]);
                HSSFWorkbook wb = hssf.hssfworkbook;
                FileOutputStream stream = new FileOutputStream(args[1]);
                HSSFSheet sheet = wb.getSheetAt(0);
                for (k = 0; k < 25; ++k) {
                    row = sheet.getRow(k);
                    sheet.removeRow(row);
                }
                for (k = 74; k < 100; ++k) {
                    row = sheet.getRow(k);
                    sheet.removeRow(row);
                }
                HSSFRow row2 = sheet.getRow(39);
                HSSFCell cell = row2.getCell(3);
                cell.setCellType(1);
                cell.setCellValue("MODIFIED CELL!!!!!");
                wb.write(stream);
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

