/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import loci.common.CompressedRandomAccess;

public class RAGZip
extends CompressedRandomAccess {
    private String file;

    public RAGZip(String file) throws IOException {
        int skip;
        this.file = file;
        if (!RAGZip.isGZipFile(file)) {
            throw new IOException(file + " is not a gzip file.");
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file), 0x100000);
        this.stream = new DataInputStream(new GZIPInputStream(bis));
        this.length = 0L;
        while ((skip = this.stream.skipBytes(1024)) > 0) {
            this.length += (long)skip;
        }
        bis = new BufferedInputStream(new FileInputStream(file), 0x100000);
        this.stream = new DataInputStream(new GZIPInputStream(bis));
    }

    public static boolean isGZipFile(String file) {
        return file.toLowerCase().endsWith(".gz");
    }

    public void seek(long pos) throws IOException {
        long oldFP = this.fp;
        this.fp = pos;
        if (this.fp > oldFP) {
            long diff = this.fp - oldFP;
            this.stream.skipBytes((int)diff);
        } else if (this.fp < oldFP) {
            this.stream.close();
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.file), 0x100000);
            this.stream = new DataInputStream(new GZIPInputStream(bis));
            this.stream.skipBytes((int)this.fp);
        }
    }
}

