/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.EOFException;
import java.io.IOException;
import loci.common.DataTools;
import loci.common.IRandomAccess;

public class RABytes
implements IRandomAccess {
    protected static final int INITIAL_LENGTH = 1000000;
    protected byte[] array;
    protected int fp;
    protected long length;

    public RABytes(byte[] bytes) {
        this.array = bytes;
        this.fp = 0;
        this.length = bytes.length;
    }

    public RABytes() {
        this.fp = 0;
        this.length = 0L;
        this.array = new byte[1000000];
    }

    public byte[] getBytes() {
        byte[] file = new byte[(int)this.length];
        System.arraycopy(this.array, 0, file, 0, file.length);
        return file;
    }

    public void close() {
    }

    public long getFilePointer() {
        return this.fp;
    }

    public long length() {
        return this.length;
    }

    public int read() {
        return (long)this.fp < this.length() ? this.array[this.fp++] : 0;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if ((long)(this.fp + len) > this.length()) {
            len = (int)(this.length() - (long)this.fp);
        }
        if (len > 0) {
            System.arraycopy(this.array, this.fp, b, off, len);
        }
        this.fp += len;
        return len;
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("pos < 0");
        }
        if (pos > Integer.MAX_VALUE) {
            throw new IOException("pos is too large");
        }
        this.fp = (int)pos;
    }

    public void setLength(long newLength) throws IOException {
        byte[] bytes;
        if (newLength > Integer.MAX_VALUE) {
            throw new IOException("newLength is too large");
        }
        this.length = newLength;
        if (this.length < (long)this.array.length) {
            return;
        }
        System.arraycopy(this.array, 0, bytes, 0, this.array.length < (bytes = new byte[(int)(this.length * 2L)]).length ? this.array.length : bytes.length);
        this.array = bytes;
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public byte readByte() throws IOException {
        if ((long)(this.fp + 1) > this.length()) {
            throw new EOFException();
        }
        return this.array[this.fp++];
    }

    public char readChar() throws IOException {
        if ((long)(this.fp + 2) > this.length()) {
            throw new EOFException();
        }
        char c = (char)DataTools.bytesToShort(this.array, this.fp, false);
        this.fp += 2;
        return c;
    }

    public double readDouble() throws IOException {
        if ((long)(this.fp + 8) > this.length()) {
            throw new EOFException();
        }
        double d = Double.longBitsToDouble(DataTools.bytesToLong(this.array, this.fp, false));
        this.fp += 8;
        return d;
    }

    public float readFloat() throws IOException {
        if ((long)(this.fp + 4) > this.length()) {
            throw new EOFException();
        }
        float f = Float.intBitsToFloat(DataTools.bytesToInt(this.array, this.fp, false));
        this.fp += 4;
        return f;
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if ((long)(this.fp + len) > this.length()) {
            throw new EOFException();
        }
        System.arraycopy(this.array, this.fp, b, off, len);
        this.fp += len;
    }

    public int readInt() throws IOException {
        if ((long)(this.fp + 4) > this.length()) {
            throw new EOFException();
        }
        int i = DataTools.bytesToInt(this.array, this.fp, false);
        this.fp += 4;
        return i;
    }

    public String readLine() throws IOException {
        throw new IOException("Unimplemented");
    }

    public long readLong() throws IOException {
        if ((long)(this.fp + 8) > this.length()) {
            throw new EOFException();
        }
        long l = DataTools.bytesToLong(this.array, this.fp, false);
        this.fp += 8;
        return l;
    }

    public short readShort() throws IOException {
        if ((long)(this.fp + 2) > this.length()) {
            throw new EOFException();
        }
        short s = DataTools.bytesToShort(this.array, this.fp, false);
        this.fp += 2;
        return s;
    }

    public int readUnsignedByte() throws IOException {
        if ((long)(this.fp + 1) > this.length()) {
            throw new EOFException();
        }
        return DataTools.bytesToInt(this.array, this.fp++, 1, false);
    }

    public int readUnsignedShort() throws IOException {
        if ((long)(this.fp + 2) > this.length()) {
            throw new EOFException();
        }
        int i = DataTools.bytesToInt(this.array, this.fp, 2, false);
        this.fp += 2;
        return i;
    }

    public String readUTF() throws IOException {
        throw new IOException("Unimplemented");
    }

    public int skipBytes(int n) {
        if (n < 0) {
            n = 0;
        }
        if ((long)(this.fp + n) > this.length()) {
            n = (int)(this.length() - (long)this.fp);
        }
        this.fp += n;
        return n;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if ((long)(this.fp + len) > this.length()) {
            this.setLength(this.fp + len);
        }
        System.arraycopy(b, off, this.array, this.fp, len);
        this.fp += b.length;
    }

    public void write(int b) throws IOException {
        if ((long)(this.fp + 1) > this.length()) {
            this.setLength(this.fp + 1);
        }
        this.array[this.fp++] = (byte)b;
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public void writeBytes(String s) throws IOException {
        char[] c = s.toCharArray();
        byte[] b = new byte[c.length];
        for (int i = 0; i < c.length; ++i) {
            b[i] = (byte)c[i];
        }
        this.write(b);
    }

    public void writeChar(int v) throws IOException {
        if ((long)(this.fp + 2) > this.length()) {
            this.setLength(this.fp + 2);
        }
        this.array[this.fp++] = (byte)(0xFF & v >> 8);
        this.array[this.fp++] = (byte)(0xFF & v);
    }

    public void writeChars(String s) throws IOException {
        int len = 2 * s.length();
        if ((long)(this.fp + len) > this.length()) {
            this.setLength(this.fp + len);
        }
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            char v = c[i];
            this.array[this.fp++] = (byte)(0xFF & v >> 8);
            this.array[this.fp++] = (byte)(0xFF & v);
        }
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeInt(int v) throws IOException {
        if ((long)(this.fp + 4) > this.length()) {
            this.setLength(this.fp + 4);
        }
        for (int i = 0; i < 4; ++i) {
            this.array[this.fp++] = (byte)(0xFF & v >> (3 - i) * 8);
        }
    }

    public void writeLong(long v) throws IOException {
        if ((long)(this.fp + 8) > this.length()) {
            this.setLength(this.fp + 8);
        }
        for (int i = 0; i < 8; ++i) {
            this.array[this.fp++] = (byte)(0xFFL & v >> (7 - i) * 8);
        }
    }

    public void writeShort(int v) throws IOException {
        if ((long)(this.fp + 2) > this.length()) {
            this.setLength(this.fp + 2);
        }
        this.array[this.fp++] = (byte)(0xFF & v >> 8);
        this.array[this.fp++] = (byte)(0xFF & v);
    }

    public void writeUTF(String str) throws IOException {
        throw new IOException("Unimplemented");
    }
}

