/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import loci.common.CBZip2InputStream;
import loci.common.CompressedRandomAccess;

public class RABZip2
extends CompressedRandomAccess {
    private String file;

    public RABZip2(String file) throws IOException {
        int skip;
        this.file = file;
        if (!RABZip2.isBZip2File(file)) {
            throw new IOException(file + " is not a BZip2 file.");
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file), 0x100000);
        bis.skip(2L);
        this.stream = new DataInputStream(new CBZip2InputStream(bis));
        this.length = 0L;
        while ((skip = this.stream.skipBytes(1024)) > 0) {
            this.length += (long)skip;
        }
        bis = new BufferedInputStream(new FileInputStream(file), 0x100000);
        bis.skip(2L);
        this.stream = new DataInputStream(new CBZip2InputStream(bis));
    }

    public static boolean isBZip2File(String file) {
        return file.toLowerCase().endsWith(".bz2");
    }

    public void seek(long pos) throws IOException {
        long oldFP = this.fp;
        this.fp = pos;
        if (this.fp > oldFP) {
            long diff = this.fp - oldFP;
            this.stream.skipBytes((int)diff);
        } else if (this.fp < oldFP) {
            this.stream.close();
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.file), 0x100000);
            bis.skip(2L);
            this.stream = new DataInputStream(new CBZip2InputStream(bis));
            this.stream.skipBytes((int)this.fp);
        }
    }
}

