/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.DataInputStream;
import java.io.IOException;
import loci.common.IRandomAccess;

public abstract class CompressedRandomAccess
implements IRandomAccess {
    protected static final int MAX_OVERHEAD = 0x100000;
    protected DataInputStream stream;
    protected long length;
    protected long fp = 0L;

    public void close() throws IOException {
        this.fp = 0L;
        this.length = 0L;
        if (this.stream != null) {
            this.stream.close();
        }
        this.stream = null;
    }

    public long getFilePointer() throws IOException {
        return this.fp;
    }

    public long length() throws IOException {
        return this.length;
    }

    public int read() throws IOException {
        int v = this.stream.read();
        ++this.fp;
        return v;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int s;
        int n;
        this.fp += (long)n;
        for (n = this.stream.read(b, off, len); n < len && this.fp < this.length(); n += s) {
            s = this.stream.read(b, off + n, len - n);
            this.fp += (long)s;
        }
        return n;
    }

    public abstract void seek(long var1) throws IOException;

    public void setLength(long newLength) throws IOException {
        this.length = newLength;
    }

    public boolean readBoolean() throws IOException {
        ++this.fp;
        return this.stream.readBoolean();
    }

    public byte readByte() throws IOException {
        ++this.fp;
        return this.stream.readByte();
    }

    public char readChar() throws IOException {
        ++this.fp;
        return this.stream.readChar();
    }

    public double readDouble() throws IOException {
        this.fp += 8L;
        return this.stream.readDouble();
    }

    public float readFloat() throws IOException {
        this.fp += 4L;
        return this.stream.readFloat();
    }

    public void readFully(byte[] b) throws IOException {
        this.stream.readFully(b);
        this.fp += (long)b.length;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.stream.readFully(b, off, len);
        this.fp += (long)len;
    }

    public int readInt() throws IOException {
        this.fp += 4L;
        return this.stream.readInt();
    }

    public String readLine() throws IOException {
        throw new IOException("Unimplemented");
    }

    public long readLong() throws IOException {
        this.fp += 8L;
        return this.stream.readLong();
    }

    public short readShort() throws IOException {
        this.fp += 2L;
        return this.stream.readShort();
    }

    public int readUnsignedByte() throws IOException {
        ++this.fp;
        return this.stream.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        this.fp += 2L;
        return this.stream.readUnsignedShort();
    }

    public String readUTF() throws IOException {
        String s = this.stream.readUTF();
        this.fp += (long)s.length();
        return s;
    }

    public int skipBytes(int n) throws IOException {
        int s = this.stream.skipBytes(n);
        this.fp += (long)s;
        return s;
    }

    public void write(byte[] b) throws IOException {
        throw new IOException("Unimplemented");
    }

    public void write(byte[] b, int off, int len) throws IOException {
        throw new IOException("Unimplemented");
    }

    public void write(int b) throws IOException {
        throw new IOException("Unimplemented");
    }

    public void writeBoolean(boolean v) throws IOException {
        throw new IOException("Unimplemented");
    }

    public void writeByte(int v) throws IOException {
        throw new IOException("Unimplemented");
    }

    public void writeBytes(String s) throws IOException {
        throw new IOException("Unimplemented");
    }

    public void writeChar(int v) throws IOException {
        throw new IOException("Unimplemented");
    }

    public void writeChars(String s) throws IOException {
        throw new IOException("Unimplemented");
    }

    public void writeDouble(double v) throws IOException {
        throw new IOException("Unimplemented");
    }

    public void writeFloat(float v) throws IOException {
        throw new IOException("Unimplemented");
    }

    public void writeInt(int v) throws IOException {
        throw new IOException("Unimplemented");
    }

    public void writeLong(long v) throws IOException {
        throw new IOException("Unimplemented");
    }

    public void writeShort(int v) throws IOException {
        throw new IOException("Unimplemented");
    }

    public void writeUTF(String str) throws IOException {
        throw new IOException("Unimplemented");
    }
}

