function data = MT_ReactionDiffusionCytoplasmB_20121223( data, before )
    if nargin < 1, return; end
    %
    % extract factors from structure
    for i=1:size( data.factorprops.Concentration,2)
        factname=lower(data.factorprops.Index2Name{i});
        eval([[factname,'_p'],'=reshape(','data.factorprops.Concentration(:,i),[ data.cellprops.cellsize]);']);
        eval([[factname,'_i'],'=','data.factorprops.Name2Index.(factname);']);
    end
    % insert model in here
    %% To run on the cluster
    % MTtboxCommandGrace('Name','MT_Paper1_20121121','N_steps',[500:500:2000],...
    %       'ORTHO_TOP',1,'modelname',[1,2],'growth_rate',[1:7],'Rescue_rate',[1:4],'Use','Cluster');
    
    %%Begin cluster run stuff
    if (~isfield(data,'noGui') || data.noGui == 0) || data.iterations<0
        rng('shuffle'); % to seed from the same number each time use 1234 instead of 'shuffle'        
        data.userdata.ranges.modelname.range{1} = 'MODEL1'; %5
        data.userdata.ranges.modelname.range{2} = 'MODEL2'; %5
        data.userdata.ranges.modelname.index = 1;
    end
    % == Do not change the following
    fields=fieldnames(data.userdata.ranges);
    fprintf(1,'\n');
    titlestring=sprintf('%s -\n',data.projectname);
    for i=1:length(fields)
        fieldname=fields{i};
        eval(sprintf('%s=(data.userdata.ranges.(fieldname).range{data.userdata.ranges.(fieldname).index});',fieldname));
        if ischar(data.userdata.ranges.(fieldname).range{1})
            titlestring=[titlestring,' ',sprintf('%s: %s\n ',fieldname,data.userdata.ranges.(fieldname).range{data.userdata.ranges.(fieldname).index})];
        else
            titlestring=[titlestring,' ',sprintf('%s: %f\n ',fieldname,data.userdata.ranges.(fieldname).range{data.userdata.ranges.(fieldname).index})];
        end
    end
    fprintf(1,'%s\n',titlestring);
    if MT_haveGUI( data )
        singlestep=get(gcbo,'tag');
        if isfield(data,'view_steps') && rem(data.iterations,data.plotoptions.view_steps)==0 || strcmp(singlestep,'pushbutton_step')
            if isfield(data.plotprops,'TitleH') && ishandle( data.plotprops.TitleH)
                set(data.plotprops.TitleH,'String',titlestring,'Parent',data.plotprops.AxesH,'interpret','none');
            end
        end
    else % The following is for use on the cluster
        if rem(data.iterations,data.plotoptions.view_steps)==0
            set(data.plotprops.TitleH,'String',titlestring,'Parent',data.plotprops.AxesH,'interpret','none');
        end
    end
    % == End of do not change
    if data.iterations <= 0
        %%
        data=mtSETMTprops(data,...
            'nuclonMT',0.0,... % stop MTs from forming
            'nuclspont',0.00);  % stop MTs from forming
        %%
        %SET time per step
        data.cellprops.secondsPerStep=1; % frame rate in experimental data
        data.factorprops.DiffusionSecondsPerStep=0.001;
        % Factors overlaying side and top/bottom edges of cytoplasm
        midx=round(data.cellprops.cellsize(1)/2);
        midy=round(data.cellprops.cellsize(2)/2);
        midz=round(data.cellprops.cellsize(3)/2);
        cytoplasm_ind=find(data.cellprops.Vol==data.organelleprops.cytoplasm.Label);
        [xx,yy,zz]=ind2sub(data.cellprops.cellsize,cytoplasm_ind);
        max_cyt_x=max(xx);
        max_cyt_y=max(yy);
        max_cyt_z=max(zz);
        min_cyt_x=min(xx);
        min_cyt_y=min(yy);
        min_cyt_z=min(zz);
        
        %     % When USE_DIFFUSION is true, GFtbox's own diffusion calculation is
        %     % used.  When false, the weighted-average-neighbourhood approximation
        %     % is performed in the interaction function, and no GFtbox diffusion is
        %     % performed.
        [xnum,xmin,xstep,xsz,xclumpindex] = clumplinear( 1:size(data.cellprops.Vol,1) );
        [ynum,ymin,ystep,ysz,yclumpindex] = clumplinear( 1:size(data.cellprops.Vol,2) );
        dt= data.cellprops.secondsPerStep;
        % These parameters are from AIH's reaction-diffusion code.
        data.userdata = setFromStruct( data.userdata, ...
            struct( 'Da', 0.25, ... % Diffusion constant of a.
            'Db', 0.0625, ... % Diffusion constant of b.
            'speed', 0.03125, ... % Constant
            'BC', 4, ... % Boundary condition: edge cells are held to this value.
            'MinC', 0, ... % Values of a and b are forced to be at least this value.
            'MaxC', 10000, ... % Values of a and b are forced to be at most this value.
            'N', xnum*ynum, ... % Number of vertexes each way.
            'dt', dt, ... % Time step
            'mean_beta', 12, ... % Mean of a fixed distribution.
            'noise_beta', 0.001, ... 0.1, ... % Standard deviation of a fixed distribution.
            'init_a', 4, ... % Initial value of substance a
            'init_b', 4, ... % Initial value of substance b
            'xnum', xnum, ... % Number of X values.
            'ynum', ynum, ... % Number of Y values.
            'xstep', xstep, ... % X spacing
            'ystep', ystep ... % Y spacing
            ) );
        
      %
        %         % An initial noise perturbation to break the symmetry.
        id_beta_p = data.userdata.mean_beta + randn(size(id_a_p)) * data.userdata.noise_beta;
        %         % A and B are initially uniform.  Maybe we should set them to be
        %         % initially uniform plus some noise, instead of using BETA?
        id_a_p(:) = data.userdata.init_a;
        id_b_p(:) = data.userdata.init_b;
            FUDGE_FACTOR = 1/16;  % Because of confusion about factor of 4 in AIH's code.
            SPACE_SCALE = 10; %5;  % The scale of the pattern is proportional to this number.
            data.userdata.diffusionScale = FUDGE_FACTOR * SPACE_SCALE^2 * (data.userdata.xstep * data.userdata.ystep)^2;
            %         m = leaf_mgen_conductivity( m, 'A', m.userdata.Da * diffusionScale, ...
            %                                        'B', m.userdata.Db * diffusionScale, ...
            %                                        'S_LEFTRIGHT', m.userdata.Db * diffusionScale );
            
            % Diffusion is uniform over the whole cell
%             data=setupDiffusion(data,'Factorname','id_a','DiffK',[data.userdata.Da * data.userdata.diffusionScale],...
%                 'RegionLists',{{'cytoplasm','plasma_membrane','microtubules','vacuole','cell_wall'}});
%             data=setupDiffusion(data,'Factorname','id_b','DiffK',[data.userdata.Db * data.userdata.diffusionScale],...
%                 'RegionLists',{{'cytoplasm','plasma_membrane','microtubules','vacuole','cell_wall'}});
            data=setupDiffusion(data,'Factorname','id_a','DiffK',[data.userdata.Da * data.userdata.diffusionScale,0.0],...
                'RegionLists',{{'cytoplasm'},{'plasma_membrane','microtubules','vacuole','cell_wall'}});
            data=setupDiffusion(data,'Factorname','id_b','DiffK',[data.userdata.Db * data.userdata.diffusionScale,0.0],...
                'RegionLists',{{'cytoplasm'},{'plasma_membrane','microtubules','vacuole','cell_wall'}});
        id_btest_p(1:min_cyt_x+1,:,:)=1;
        id_btest_p(max_cyt_x-1:end,:,:)=1;
        id_atest_p(:,1:min_cyt_y+1,:)=1;
        id_atest_p(:,max_cyt_y-1:end,:)=1;
    else
        %         % Executed on every iteration after the first.
        %         % Reaction-diffusion equations.
        if data.iterations<50
            id_beta_p = data.userdata.mean_beta + randn(size(id_a_p)) * data.userdata.noise_beta;
        else
            id_beta_p = data.userdata.mean_beta*ones(size(id_a_p));
        end

        indCyto = region(data,1,'cytoplasm'); % indexes cytoplasm within the cell volume
        % CONSTRAIN REACTION DIFFUSION TO THE CYTOPLASMIC REGION
        ab=zeros(size(id_a_p));
        da=zeros(size(id_a_p));
        db=zeros(size(id_a_p));
        ab(indCyto) = id_a_p(indCyto) .* id_b_p(indCyto);
        ab(ab<0)=0;
        da(indCyto) = data.userdata.speed*(16 - ab(indCyto));
        db(indCyto) = data.userdata.speed*(ab(indCyto) - id_b_p(indCyto) - id_beta_p(indCyto));
        id_a_p(indCyto) = id_a_p(indCyto) + data.userdata.dt*da(indCyto);
        id_b_p(indCyto) = id_b_p(indCyto) + data.userdata.dt*db(indCyto);
        id_a_p(indCyto) = min( max( id_a_p(indCyto), data.userdata.MinC ), data.userdata.MaxC );
        id_b_p(indCyto) = min( max( id_b_p(indCyto), data.userdata.MinC ), data.userdata.MaxC );
        indPM = region(data,1,'plasma_membrane'); % indexes cytoplasm within the cell volume
        indWall = region(data,1,'cell_wall'); % indexes cell_wall within the cell volume
        indVac = region(data,1,'vacuole'); % indexes cell_wall within the cell volume
        id_a_p([indPM;indWall;indVac]) = data.userdata.BC;
        id_b_p([indPM;indWall;indVac]) = data.userdata.BC;
        id_a_p(id_a_p<0)=0;
        id_b_p(id_b_p<0)=0;
        %
        %         % The equations in more mathematical notation:
        %         % da = speed*(16 - a*b) + (Da/4)*Del2(a)
        %         % db = speed*(ab - b - beta) + (Db/4)*Del2(b)
        id_a_var_p(indCyto) = id_a_p(indCyto) - data.userdata.BC;
        id_b_var_p(indCyto) = id_b_p(indCyto) - data.userdata.BC;
    end
%     id_b_var_p = id_b_p - min(id_b_p(:)); % m.userdata.BC;
%     id_beta_var_p = id_beta_p - data.userdata.mean_beta;
    %m = leaf_setproperty( m, 'diffusionEnabled', USE_DIFFUSION );
    %
    % plot profiles of factors in the context of the cytoplasm region
    plotrows=2;
    plotcols=1;
    FactorProfilePlot(data,{'id_a_var','id_b_var'},'x',plotrows,plotcols,1);
    FactorProfilePlot(data,{'id_a','id_b'},'x',plotrows,plotcols,2);
    
    % s_a_p(region(data,id_a_p,'cytoplasm'))=1;% generate (clamp)
    % s_a_p=s_a_p*(1-0.01); % decay
    % s_b_p(region(data,id_b_p,'cytoplasm'))=1;% generate (clamp)
    % s_b_p=s_b_p*(1-0.01); % decay
    %
    %Make changes here
    
    %MTStats(data); % Plot distributions and other stats
    %%
    
    % put factors back into structure
    for i=1:size( data.factorprops.Concentration,2)
        factname=lower(data.factorprops.Index2Name{i});
        eval(['data.factorprops.Concentration(:,i)=',[factname,'_p(:);']]);
    end
    %%
    %%
    % _Parameters initialised when the project was first created._
    
end

% This space intentionally left blank.
%%% USER CODE: SUBFUNCTIONS
% Default factor parameters
% id_a
% id_b
% id_edge
% id_a_var
% id_b_var
% id_beta_var
% id_agrad
% id_beta
% id_atest
% id_btest
% Default organelle parameters

%      cell_wall.size          =0.000000
%      cell_wall.offset        =0.500000
%      cell_wall.micronthick   =0.100000
%      cell_wall.minvox        =1.000000
%      cell_wall.FaceColor     =[1.000000,0.000000,1.000000,]
%      cell_wall.FaceAlpha     =0.200000
%      cell_wall.Label         =-5.000000
%      cell_wall.isLayer       =1.000000
%      cell_wall.Static        =1.000000
%      cell_wall.InUse         =1.000000

%plasma_membrane.size          =0.000000
%plasma_membrane.offset        =0.500000
%plasma_membrane.micronthick   =0.010000
%plasma_membrane.minvox        =3.000000
%plasma_membrane.FaceColor     =[1.000000,1.000000,0.000000,]
%plasma_membrane.FaceAlpha     =0.200000
%plasma_membrane.Label         =-4.000000
%plasma_membrane.isLayer       =1.000000
%plasma_membrane.Static        =1.000000
%plasma_membrane.InUse         =1.000000

%      cytoplasm.size          =0.000000
%      cytoplasm.offset        =0.500000
%      cytoplasm.micronthick   =1.000000
%      cytoplasm.minvox        =3.000000
%      cytoplasm.FaceColor     =[0.000000,1.000000,0.000000,]
%      cytoplasm.FaceAlpha     =0.200000
%      cytoplasm.Label         =0.000000
%      cytoplasm.isLayer       =1.000000
%      cytoplasm.Static        =1.000000
%      cytoplasm.InUse         =1.000000

%   microtubules.thicknessMicrons=0.025000
%   microtubules.minvox        =0.025000
%   microtubules.growthrate    =0.500000
%   microtubules.shrinkrate    =0.000000
%   microtubules.shrinkheadrate=5.000000
%   microtubules.catastropherate=5.000000
%   microtubules.maxAlignToSurfAngle=40.000000
%   microtubules.maxZipToMTAngle=20.000000
%   microtubules.bendpriority  =[109.000000,101.000000,109.000000,98.000000,114.000000,97.000000,110.000000,101.000000,]
%   microtubules.maxSpawnAngle =40.000000
%   microtubules.maxAge        =0.000000
%   microtubules.nuclspont     =0.000000
%   microtubules.nuclonMT      =0.000000
%   microtubules.probCatastropheWhenHit=0.300000
%   microtubules.probPauseOnCollision=0.980000
%   microtubules.probSpontaneousCatastrophe=0.000000
%   microtubules.backwardBranching=0.000000
%   microtubules.parallelspawnprob=
%   microtubules.wraparound    =0.000000
%   microtubules.FaceColor     =[0.000000,0.000000,1.000000,]
%   microtubules.FaceAlpha     =0.400000
%   microtubules.Label         =-6.000000
%   microtubules.isLayer       =0.000000
%   microtubules.Static        =0.000000
%   microtubules.InUse         =1.000000

%        vacuole.size          =0.200000
%        vacuole.offset        =0.500000
%        vacuole.micronthick   =1.000000
%        vacuole.minvox        =0.000000
%        vacuole.FaceColor     =[1.000000,1.000000,0.000000,]
%        vacuole.FaceAlpha     =0.300000
%        vacuole.Label         =-3.000000
%        vacuole.isLayer       =0.000000
%        vacuole.Static        =1.000000
%        vacuole.InUse         =1.000000
% Default cell parameters
% cellprops.shape          ='Rect:1:0.5:0.0002'
% cellprops.sheetmodel     =1
% cellprops.sheetPlaneNormal=[0,0,1,]
% cellprops.secondsPerStep =1
% cellprops.maxLengthMicrons=20
% cellprops.widthMicrons   =10
% cellprops.heightMicrons  =2.333333
% cellprops.micronsPerVoxelEdge=0.166667
% cellprops.cubicMicronsPerVoxel=0.004630
% cellprops.cellsize       =[120,60,14,]
% cellprops.sheetLevel     =8
% cellprops.colourType     =1
% cellprops.Vol            =[-1,-1,-1,-1, ... ]
% cellprops.Smooth         ='None'
% cellprops.bound_distance =5
% cellprops.collide_distance=10
% cellprops.projectedCytAreaPixels=5341
% cellprops.% cell_wall.EdgeVol=struct
% cell_wall.plotsurface=struct
% cell_wall.plotnormals=struct
% cellprops.% plasma_membrane.EdgeVol=struct
% plasma_membrane.plotsurface=struct
% plasma_membrane.plotnormals=struct
% cellprops.% cytoplasm.EdgeVol=struct
% cytoplasm.plotsurface=struct
% cytoplasm.plotnormals=struct
% cytoplasm.Indexes=struct
% cellprops.% vacuole.EdgeVol=struct
% vacuole.plotsurface=struct
% vacuole.plotnormals=struct
% cellprops.slicenumber    =7
% cellprops.slicenumber2   =120
% cellprops.roundedCorners =0
