function data = MT_AllardFig1WrapNoWrap_20121210( data, before )
    if nargin < 1, return; end
% 
% extract factors from structure
    for i=1:size( data.factorprops.Concentration,2)
        factname=lower(data.factorprops.Index2Name{i});
        eval([[factname,'_p'],'=reshape(','data.factorprops.Concentration(:,i),[ data.cellprops.cellsize]);']);
        eval([[factname,'_i'],'=','data.factorprops.Name2Index.(factname);']);
    end
% insert model in here
%%
% To run on the cluster
% MTtboxCommandGrace('Name','MT_Paper1_20121121','N_steps',[500:500:2000],...
%       'ORTHO_TOP',1,'modelname',[1,2],'growth_rate',[1:7],'Rescue_rate',[1:4],'Use','Cluster');
%
%%Begin cluster run stuff
    if (~isfield(data,'noGui') || data.noGui == 0) || data.iterations<0
        data.userdata.ranges.growth_rate.range{1} = 0.1; %1
        data.userdata.ranges.growth_rate.range{2} = 0.2; %1
        data.userdata.ranges.growth_rate.range{3} = 0.3; %1
        data.userdata.ranges.growth_rate.range{4} = 0.4; %1
        data.userdata.ranges.growth_rate.range{5} = 0.5; %1
        data.userdata.ranges.growth_rate.range{6} = 0.6; %1
        data.userdata.ranges.growth_rate.range{7} = 0.7; %1
        data.userdata.ranges.growth_rate.index = 3;
        
        data.userdata.ranges.Rescue_rate.range{1} = 0.1; %2 % Andrews
        data.userdata.ranges.Rescue_rate.range{2} = 0.3; %2
        data.userdata.ranges.Rescue_rate.range{3} = 0.6; %2
        data.userdata.ranges.Rescue_rate.range{4} = 0.9; %2
        data.userdata.ranges.Rescue_rate.index = 3;
        
        data.userdata.ranges.modelname.range{1} = 'ALLARD_FIG1_WITH_WRAP'; %5
        data.userdata.ranges.modelname.range{2} = 'ALLARD_FIG1_NO_WRAP'; %5
        data.userdata.ranges.modelname.index = 2;
    end
    fields=fieldnames(data.userdata.ranges);
    fprintf(1,'\n');
    for i=1:length(fields)
        fieldname=fields{i};
        eval(sprintf('%s=(data.userdata.ranges.(fieldname).range{data.userdata.ranges.(fieldname).index});',fieldname));
        if ischar(data.userdata.ranges.(fieldname).range{1})
            fprintf(1,'%s: %s, ',fieldname,data.userdata.ranges.(fieldname).range{data.userdata.ranges.(fieldname).index})
        else
            fprintf(1,'%s: %f, ',fieldname,data.userdata.ranges.(fieldname).range{data.userdata.ranges.(fieldname).index})
        end
    end
    fprintf(1,'\n');
    if data.iterations==0
        %% 
        %%
        %SET time per step
        %Change MT properties (from those shown at the bottom of the file)
        %(For a full list of properties click on help for this function.)
        switch modelname
            case 'ALLARD_FIG1_WITH_WRAP'
                data=mtSETMTprops(data,...
                    'thicknessMicrons',0.0025,...
                    'growthrate',0.5,...
                    'shrinkrate',0.08,... 0.005,... %3,...
                    'nuclonMT',0.0,...
                    'nuclspont',0.8,...0.1,...18,...
                    'maxAlignToSurfAngle',0,...
                    'maxZipToMTAngle',0,...
                    'probPauseOnCollision',0.8, ...
                    'probCatastropheWhenHit',0.02,...
                    'maxSpawnAngle',40);
                % setup wrapping
                data=MT_wrap(data,'setup');                
            case 'ALLARD_FIG1_NO_WRAP'
                data=mtSETMTprops(data,...
                    'thicknessMicrons',0.00001,...0.025,...
                    'growthrate',0.3,... % rate
                    'shrinkrate',0.05,... 0.005,... %3,...
                    'nuclonMT',0.0,...
                    'nuclspont',1.9,...
                    'maxAlignToSurfAngle',0,...
                    'maxZipToMTAngle',0,...
                    'probPauseOnCollision',0, ...
                    'probCatastropheWhenHit',0,...
                    'maxSpawnAngle',0);
            otherwise
                error('modelname not recognised')
        end
    else
        %% 
        %Make changes here
        %  Wrap where needed by creating new MTs that form the wrap
        switch modelname
            case 'ALLARD_FIG1_WITH_WRAP'
                data=MT_wrap(data,'run');
            case 'ALLARD_FIG1_NO_WRAP'
                % no change
            otherwise
                error('modelname not recognised')
        end
        %
        % _Checking and changes to individual MTs_
        for i_MT=1:length(data.working.dyn.microtubules.Org)
            MT=data.working.dyn.microtubules.Org(i_MT);
            switch modelname
                case 'ALLARD_FIG1_WITH_WRAP'
                    hit=hasHit('MT',MT); % has the MT hit another MT?
                    if hit % pause
                        if rand<(1-Rescue_rate) %0.9 % pause
                            MT.Growing=false; % should already be false
                        else % cancel all previous hits and allow to grow again
                            MT.Hit=struct('hitmt',[],'hitstatic',[],'hitat',[],'hitwhen',[]);
                            MT.Growing=true;
                        end
                    end
                case 'ALLARD_FIG1_NO_WRAP'
                    if hasJustHit('MT',MT) && ~MT.Growing %MT.BoundMic && ~MT.Growing  % hit another microtubule and NOT aligned
                        if size(MT.Verts,1)>1
                            MT.Verts=MT.Verts(1:end-1,:);
                        else
                            MT.Alive=false;
                        end
                    end
                    if ~MT.Growing && MT.Alive && rand<Rescue_rate
                        MT.Growing=true;
                    end
                    if hasHit('Static',MT)
                        MT.Alive=false;
                    end
                otherwise
                    error('modelname not recognised')
            end      
            % _Keep the following_
            % Clear flags from collision detector
            MT.BoundPLM=false;
            MT.BoundMic=false;
            MT.BoundVac=false;
            MT.BoundWll=false;
            data.working.dyn.microtubules.Org(i_MT)=MT;
        end
        %MTStats(data); % Plot distributions and other stats
        %%
    end

% put factors back into structure
    for i=1:size( data.factorprops.Concentration,2)
        factname=lower(data.factorprops.Index2Name{i});
        eval(['data.factorprops.Concentration(:,i)=',[factname,'_p(:);']]);
    end    
%% 
%%
% _Parameters initialised when the project was first created._

end

% This space intentionally left blank.
% Default factor parameters
% Default organelle parameters

%      cell_wall.size          =0.000000
%      cell_wall.offset        =0.500000
%      cell_wall.micronthick   =0.100000
%      cell_wall.minvox        =1.000000
%      cell_wall.FaceColor     =[1.000000,0.000000,1.000000,]
%      cell_wall.FaceAlpha     =0.200000
%      cell_wall.Label         =-5.000000
%      cell_wall.isLayer       =1.000000
%      cell_wall.Static        =1.000000
%      cell_wall.InUse         =1.000000

%plasma_membrane.size          =0.000000
%plasma_membrane.offset        =0.500000
%plasma_membrane.micronthick   =0.010000
%plasma_membrane.minvox        =3.000000
%plasma_membrane.FaceColor     =[1.000000,1.000000,0.000000,]
%plasma_membrane.FaceAlpha     =0.200000
%plasma_membrane.Label         =-4.000000
%plasma_membrane.isLayer       =1.000000
%plasma_membrane.Static        =1.000000
%plasma_membrane.InUse         =1.000000

%      cytoplasm.size          =0.000000
%      cytoplasm.offset        =0.500000
%      cytoplasm.micronthick   =1.000000
%      cytoplasm.minvox        =3.000000
%      cytoplasm.FaceColor     =[0.000000,1.000000,0.000000,]
%      cytoplasm.FaceAlpha     =0.200000
%      cytoplasm.Label         =0.000000
%      cytoplasm.isLayer       =1.000000
%      cytoplasm.Static        =1.000000
%      cytoplasm.InUse         =1.000000

%   microtubules.thicknessMicrons=0.500000
%   microtubules.minvox        =0.000100
%   microtubules.growthrate    =0.100000
%   microtubules.shrinkrate    =0.030000
%   microtubules.catastropherate=0.500000
%   microtubules.maxAlignToSurfAngle=40.000000
%   microtubules.maxZipToMTAngle=50.000000
%   microtubules.maxSpawnAngle =50.000000
%   microtubules.maxAge        =0.000000
%   microtubules.nuclspont     =0.001200
%   microtubules.nuclonMT      =0.000120
%   microtubules.probCatastropheWhenHit=0.300000
%   microtubules.probPauseOnCollision=0.700000
%   microtubules.probSpontaneousCatastrophe=0.030000
%   microtubules.backwardBranching=0.500000
%   microtubules.parallelspawnprob=
%   microtubules.wraparound    =0.000000
%   microtubules.FaceColor     =[0.000000,0.000000,1.000000,]
%   microtubules.FaceAlpha     =0.400000
%   microtubules.Label         =-6.000000
%   microtubules.isLayer       =0.000000
%   microtubules.Static        =0.000000
%   microtubules.InUse         =1.000000

%        vacuole.size          =0.200000
%        vacuole.offset        =0.500000
%        vacuole.micronthick   =1.000000
%        vacuole.minvox        =0.000000
%        vacuole.FaceColor     =[1.000000,1.000000,0.000000,]
%        vacuole.FaceAlpha     =0.300000
%        vacuole.Label         =-3.000000
%        vacuole.isLayer       =0.000000
%        vacuole.Static        =1.000000
%        vacuole.InUse         =1.000000
% Default cell parameters
% cellprops.shape          ='Rect:1:0.5:0.0002'
% cellprops.sheetmodel     =1
% cellprops.secondsPerStep =1
% cellprops.maxLengthMicrons=20
% cellprops.widthMicrons   =10.212766
% cellprops.heightMicrons  =5.957447
% cellprops.micronsPerVoxelEdge=0.425532
% cellprops.cubicMicronsPerVoxel=0.077054
% cellprops.cellsize       =[47,24,14,]
% cellprops.sheetLevel     =7.500000
% cellprops.colourType     =1
% cellprops.Vol            =[-1,-1,-1,-1, ... ]
% cellprops.Smooth         ='None'
% cellprops.bound_distance =5
% cellprops.collide_distance=10
% cellprops.projectedCytAreaPixels=468
% cellprops.% cell_wall.EdgeVol=struct
% cell_wall.plotsurface=struct
% cell_wall.plotnormals=struct
% cellprops.% plasma_membrane.EdgeVol=struct
% plasma_membrane.plotsurface=struct
% plasma_membrane.plotnormals=struct
% cellprops.% cytoplasm.EdgeVol=struct
% cytoplasm.plotsurface=struct
% cytoplasm.plotnormals=struct
% cytoplasm.Indexes=struct
% cellprops.% vacuole.EdgeVol=struct
% vacuole.plotsurface=struct
% vacuole.plotnormals=struct
% cellprops.sheetPlaneNormal=[0,0,1,]
