/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.List;
import java.util.Stack;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.DeletedArea3DPtg;
import org.apache.poi.hssf.record.formula.DeletedRef3DPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.util.RangeAddress;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class NameRecord
extends Record {
    public static final short sid = 24;
    public static final byte BUILTIN_CONSOLIDATE_AREA = 1;
    public static final byte BUILTIN_AUTO_OPEN = 2;
    public static final byte BUILTIN_AUTO_CLOSE = 3;
    public static final byte BUILTIN_DATABASE = 4;
    public static final byte BUILTIN_CRITERIA = 5;
    public static final byte BUILTIN_PRINT_AREA = 6;
    public static final byte BUILTIN_PRINT_TITLE = 7;
    public static final byte BUILTIN_RECORDER = 8;
    public static final byte BUILTIN_DATA_FORM = 9;
    public static final byte BUILTIN_AUTO_ACTIVATE = 10;
    public static final byte BUILTIN_AUTO_DEACTIVATE = 11;
    public static final byte BUILTIN_SHEET_TITLE = 12;
    public static final short OPT_HIDDEN_NAME = 1;
    public static final short OPT_FUNCTION_NAME = 2;
    public static final short OPT_COMMAND_NAME = 4;
    public static final short OPT_MACRO = 8;
    public static final short OPT_COMPLEX = 16;
    public static final short OPT_BUILTIN = 32;
    public static final short OPT_BINDATA = 4096;
    private short field_1_option_flag;
    private byte field_2_keyboard_shortcut;
    private byte field_3_length_name_text;
    private short field_4_length_name_definition;
    private short field_5_index_to_sheet;
    private short field_6_equals_to_index_to_sheet;
    private byte field_7_length_custom_menu;
    private byte field_8_length_description_text;
    private byte field_9_length_help_topic_text;
    private byte field_10_length_status_bar_text;
    private byte field_11_compressed_unicode_flag;
    private byte field_12_builtIn_name;
    private String field_12_name_text;
    private Stack field_13_name_definition;
    private String field_14_custom_menu_text;
    private String field_15_description_text;
    private String field_16_help_topic_text;
    private String field_17_status_bar_text;

    public NameRecord() {
        this.field_13_name_definition = new Stack();
        this.field_12_name_text = new String();
        this.field_14_custom_menu_text = new String();
        this.field_15_description_text = new String();
        this.field_16_help_topic_text = new String();
        this.field_17_status_bar_text = new String();
    }

    public NameRecord(RecordInputStream in) {
        super(in);
    }

    public NameRecord(byte builtin, short index) {
        this();
        this.field_12_builtIn_name = builtin;
        this.setOptionFlag((short)(this.getOptionFlag() | 0x20));
        this.setNameTextLength((byte)1);
        this.setEqualsToIndexToSheet(index);
        this.setCustomMenuLength((byte)0);
        this.setDescriptionTextLength((byte)0);
        this.setHelpTopicLength((byte)0);
        this.setStatusBarLength((byte)0);
    }

    public void setOptionFlag(short flag) {
        this.field_1_option_flag = flag;
    }

    public void setKeyboardShortcut(byte shortcut) {
        this.field_2_keyboard_shortcut = shortcut;
    }

    public void setNameTextLength(byte length) {
        this.field_3_length_name_text = length;
    }

    public void setDefinitionTextLength(short length) {
        this.field_4_length_name_definition = length;
    }

    public void setUnused(short index) {
        this.field_5_index_to_sheet = index;
    }

    public short getEqualsToIndexToSheet() {
        return this.field_6_equals_to_index_to_sheet;
    }

    public short getIndexToSheet() {
        return this.getEqualsToIndexToSheet();
    }

    public byte getFnGroup() {
        int masked = this.field_1_option_flag & 0xFC0;
        return (byte)(masked >> 4);
    }

    public void setEqualsToIndexToSheet(short value) {
        this.field_6_equals_to_index_to_sheet = value;
    }

    public void setCustomMenuLength(byte length) {
        this.field_7_length_custom_menu = length;
    }

    public void setDescriptionTextLength(byte length) {
        this.field_8_length_description_text = length;
    }

    public void setHelpTopicLength(byte length) {
        this.field_9_length_help_topic_text = length;
    }

    public void setStatusBarLength(byte length) {
        this.field_10_length_status_bar_text = length;
    }

    public void setCompressedUnicodeFlag(byte flag) {
        this.field_11_compressed_unicode_flag = flag;
    }

    public void setNameText(String name) {
        this.field_12_name_text = name;
    }

    public void setCustomMenuText(String text) {
        this.field_14_custom_menu_text = text;
    }

    public void setDescriptionText(String text) {
        this.field_15_description_text = text;
    }

    public void setHelpTopicText(String text) {
        this.field_16_help_topic_text = text;
    }

    public void setStatusBarText(String text) {
        this.field_17_status_bar_text = text;
    }

    public short getOptionFlag() {
        return this.field_1_option_flag;
    }

    public byte getKeyboardShortcut() {
        return this.field_2_keyboard_shortcut;
    }

    public byte getNameTextLength() {
        return this.field_3_length_name_text;
    }

    public short getDefinitionLength() {
        return this.field_4_length_name_definition;
    }

    public short getUnused() {
        return this.field_5_index_to_sheet;
    }

    public byte getCustomMenuLength() {
        return this.field_7_length_custom_menu;
    }

    public byte getDescriptionTextLength() {
        return this.field_8_length_description_text;
    }

    public byte getHelpTopicLength() {
        return this.field_9_length_help_topic_text;
    }

    public byte getStatusBarLength() {
        return this.field_10_length_status_bar_text;
    }

    public byte getCompressedUnicodeFlag() {
        return this.field_11_compressed_unicode_flag;
    }

    public boolean isHiddenName() {
        return (this.field_1_option_flag & 1) != 0;
    }

    public boolean isFunctionName() {
        return (this.field_1_option_flag & 2) != 0;
    }

    public boolean isCommandName() {
        return (this.field_1_option_flag & 4) != 0;
    }

    public boolean isMacro() {
        return (this.field_1_option_flag & 8) != 0;
    }

    public boolean isComplexFunction() {
        return (this.field_1_option_flag & 0x10) != 0;
    }

    public boolean isBuiltInName() {
        return (this.getOptionFlag() & 0x20) != 0;
    }

    public String getNameText() {
        return this.isBuiltInName() ? this.translateBuiltInName(this.getBuiltInName()) : this.field_12_name_text;
    }

    public byte getBuiltInName() {
        return this.field_12_builtIn_name;
    }

    public List getNameDefinition() {
        return this.field_13_name_definition;
    }

    public void setNameDefinition(Stack nameDefinition) {
        this.field_13_name_definition = nameDefinition;
    }

    public String getCustomMenuText() {
        return this.field_14_custom_menu_text;
    }

    public String getDescriptionText() {
        return this.field_15_description_text;
    }

    public String getHelpTopicText() {
        return this.field_16_help_topic_text;
    }

    public String getStatusBarText() {
        return this.field_17_status_bar_text;
    }

    protected void validateSid(short id) {
        if (id != 24) {
            throw new RecordFormatException("NOT A valid Name RECORD");
        }
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)24);
        short size = (short)(15 + this.getTextsLength() + this.getNameDefinitionSize());
        LittleEndian.putShort(data, 2 + offset, size);
        LittleEndian.putShort(data, 4 + offset, this.getOptionFlag());
        data[6 + offset] = this.getKeyboardShortcut();
        data[7 + offset] = this.getNameTextLength();
        LittleEndian.putShort(data, 8 + offset, this.getDefinitionLength());
        LittleEndian.putShort(data, 10 + offset, this.getUnused());
        LittleEndian.putShort(data, 12 + offset, this.getEqualsToIndexToSheet());
        data[14 + offset] = this.getCustomMenuLength();
        data[15 + offset] = this.getDescriptionTextLength();
        data[16 + offset] = this.getHelpTopicLength();
        data[17 + offset] = this.getStatusBarLength();
        data[18 + offset] = this.getCompressedUnicodeFlag();
        int start_of_name_definition = 19 + this.field_3_length_name_text;
        if (this.isBuiltInName()) {
            data[19 + offset] = this.getBuiltInName();
        } else {
            StringUtil.putCompressedUnicode(this.getNameText(), data, 19 + offset);
        }
        Ptg.serializePtgStack(this.field_13_name_definition, data, start_of_name_definition + offset);
        int start_of_custom_menu_text = start_of_name_definition + this.field_4_length_name_definition;
        StringUtil.putCompressedUnicode(this.getCustomMenuText(), data, start_of_custom_menu_text + offset);
        int start_of_description_text = start_of_custom_menu_text + this.field_7_length_custom_menu;
        StringUtil.putCompressedUnicode(this.getDescriptionText(), data, start_of_description_text + offset);
        int start_of_help_topic_text = start_of_description_text + this.field_8_length_description_text;
        StringUtil.putCompressedUnicode(this.getHelpTopicText(), data, start_of_help_topic_text + offset);
        int start_of_status_bar_text = start_of_help_topic_text + this.field_9_length_help_topic_text;
        StringUtil.putCompressedUnicode(this.getStatusBarText(), data, start_of_status_bar_text + offset);
        return this.getRecordSize();
    }

    public int getTextsLength() {
        int result = this.getNameTextLength() + this.getDescriptionTextLength() + this.getHelpTopicLength() + this.getStatusBarLength();
        return result;
    }

    private int getNameDefinitionSize() {
        int result = 0;
        Stack list = this.field_13_name_definition;
        for (int k = 0; k < list.size(); ++k) {
            Ptg ptg = (Ptg)list.get(k);
            result += ptg.getSize();
        }
        return result;
    }

    public int getRecordSize() {
        int result = 19 + this.getTextsLength() + this.getNameDefinitionSize();
        return result;
    }

    public short getExternSheetNumber() {
        if (this.field_13_name_definition == null || this.field_13_name_definition.isEmpty()) {
            return 0;
        }
        Ptg ptg = (Ptg)this.field_13_name_definition.peek();
        short result = 0;
        if (ptg.getClass() == Area3DPtg.class) {
            result = ((Area3DPtg)ptg).getExternSheetIndex();
        } else if (ptg.getClass() == Ref3DPtg.class) {
            result = ((Ref3DPtg)ptg).getExternSheetIndex();
        }
        return result;
    }

    public void setExternSheetNumber(short externSheetNumber) {
        Ptg ptg;
        if (this.field_13_name_definition == null || this.field_13_name_definition.isEmpty()) {
            this.field_13_name_definition = new Stack();
            ptg = this.createNewPtg();
        } else {
            ptg = (Ptg)this.field_13_name_definition.peek();
        }
        if (ptg.getClass() == Area3DPtg.class) {
            ((Area3DPtg)ptg).setExternSheetIndex(externSheetNumber);
        } else if (ptg.getClass() == Ref3DPtg.class) {
            ((Ref3DPtg)ptg).setExternSheetIndex(externSheetNumber);
        }
    }

    private Ptg createNewPtg() {
        Area3DPtg ptg = new Area3DPtg();
        this.field_13_name_definition.push(ptg);
        return ptg;
    }

    public String getAreaReference(Workbook book) {
        if (this.field_13_name_definition == null || this.field_13_name_definition.isEmpty()) {
            return "Error";
        }
        Ptg ptg = (Ptg)this.field_13_name_definition.peek();
        String result = "";
        if (ptg.getClass() == Area3DPtg.class) {
            result = ptg.toFormulaString(book);
        } else if (ptg.getClass() == Ref3DPtg.class) {
            result = ptg.toFormulaString(book);
        } else if (ptg.getClass() == DeletedArea3DPtg.class || ptg.getClass() == DeletedRef3DPtg.class) {
            result = "#REF!";
        }
        return result;
    }

    public void setAreaReference(String ref) {
        Ptg ptg;
        Ptg oldPtg;
        RangeAddress ra = new RangeAddress(ref);
        if (this.field_13_name_definition == null || this.field_13_name_definition.isEmpty()) {
            this.field_13_name_definition = new Stack();
            oldPtg = this.createNewPtg();
        } else {
            oldPtg = (Ptg)this.field_13_name_definition.pop();
        }
        short externSheetIndex = 0;
        if (oldPtg.getClass() == Area3DPtg.class) {
            externSheetIndex = ((Area3DPtg)oldPtg).getExternSheetIndex();
        } else if (oldPtg.getClass() == Ref3DPtg.class) {
            externSheetIndex = ((Ref3DPtg)oldPtg).getExternSheetIndex();
        }
        if (ra.hasRange()) {
            ptg = new Area3DPtg();
            ((Area3DPtg)ptg).setExternSheetIndex(externSheetIndex);
            ((Area3DPtg)ptg).setArea(ref);
            this.setDefinitionTextLength((short)ptg.getSize());
        } else {
            ptg = new Ref3DPtg();
            ((Ref3DPtg)ptg).setExternSheetIndex(externSheetIndex);
            ((Ref3DPtg)ptg).setArea(ref);
            this.setDefinitionTextLength((short)ptg.getSize());
        }
        this.field_13_name_definition.push(ptg);
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_option_flag = in.readShort();
        this.field_2_keyboard_shortcut = in.readByte();
        this.field_3_length_name_text = in.readByte();
        this.field_4_length_name_definition = in.readShort();
        this.field_5_index_to_sheet = in.readShort();
        this.field_6_equals_to_index_to_sheet = in.readShort();
        this.field_7_length_custom_menu = in.readByte();
        this.field_8_length_description_text = in.readByte();
        this.field_9_length_help_topic_text = in.readByte();
        this.field_10_length_status_bar_text = in.readByte();
        this.field_11_compressed_unicode_flag = in.readByte();
        if (this.isBuiltInName()) {
            this.field_12_builtIn_name = in.readByte();
        } else {
            this.field_12_name_text = this.field_11_compressed_unicode_flag == 1 ? in.readCompressedUnicode(this.field_3_length_name_text) : in.readCompressedUnicode(this.field_3_length_name_text);
        }
        this.field_13_name_definition = Ptg.createParsedExpressionTokens(this.field_4_length_name_definition, in);
        this.field_14_custom_menu_text = in.readCompressedUnicode(LittleEndian.ubyteToInt(this.field_7_length_custom_menu));
        this.field_15_description_text = in.readCompressedUnicode(LittleEndian.ubyteToInt(this.field_8_length_description_text));
        this.field_16_help_topic_text = in.readCompressedUnicode(LittleEndian.ubyteToInt(this.field_9_length_help_topic_text));
        this.field_17_status_bar_text = in.readCompressedUnicode(LittleEndian.ubyteToInt(this.field_10_length_status_bar_text));
    }

    public short getSid() {
        return 24;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[NAME]\n");
        buffer.append("    .option flags         = ").append(HexDump.toHex(this.field_1_option_flag)).append("\n");
        buffer.append("    .keyboard shortcut    = ").append(HexDump.toHex(this.field_2_keyboard_shortcut)).append("\n");
        buffer.append("    .length of the name   = ").append(this.field_3_length_name_text).append("\n");
        buffer.append("    .size of the formula data = ").append(this.field_4_length_name_definition).append("\n");
        buffer.append("    .unused                   = ").append(this.field_5_index_to_sheet).append("\n");
        buffer.append("    .index to sheet (1-based, 0=Global)           = ").append(this.field_6_equals_to_index_to_sheet).append("\n");
        buffer.append("    .Length of menu text (character count)        = ").append(this.field_7_length_custom_menu).append("\n");
        buffer.append("    .Length of description text (character count) = ").append(this.field_8_length_description_text).append("\n");
        buffer.append("    .Length of help topic text (character count)  = ").append(this.field_9_length_help_topic_text).append("\n");
        buffer.append("    .Length of status bar text (character count)  = ").append(this.field_10_length_status_bar_text).append("\n");
        buffer.append("    .Name (Unicode flag)  = ").append(this.field_11_compressed_unicode_flag).append("\n");
        buffer.append("    .Name (Unicode text)  = ").append(this.getNameText()).append("\n");
        buffer.append("    .Menu text (Unicode string without length field)        = ").append(this.field_14_custom_menu_text).append("\n");
        buffer.append("    .Description text (Unicode string without length field) = ").append(this.field_15_description_text).append("\n");
        buffer.append("    .Help topic text (Unicode string without length field)  = ").append(this.field_16_help_topic_text).append("\n");
        buffer.append("    .Status bar text (Unicode string without length field)  = ").append(this.field_17_status_bar_text).append("\n");
        buffer.append("[/NAME]\n");
        return buffer.toString();
    }

    protected String translateBuiltInName(byte name) {
        switch (name) {
            case 10: {
                return "Auto_Activate";
            }
            case 3: {
                return "Auto_Close";
            }
            case 11: {
                return "Auto_Deactivate";
            }
            case 2: {
                return "Auto_Open";
            }
            case 1: {
                return "Consolidate_Area";
            }
            case 5: {
                return "Criteria";
            }
            case 4: {
                return "Database";
            }
            case 9: {
                return "Data_Form";
            }
            case 6: {
                return "Print_Area";
            }
            case 7: {
                return "Print_Titles";
            }
            case 8: {
                return "Recorder";
            }
            case 12: {
                return "Sheet_Title";
            }
        }
        return "Unknown";
    }
}

