/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.io.FileInfo;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.Location;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.ChannelMerger;
import loci.formats.ChannelSeparator;
import loci.formats.DimensionSwapper;
import loci.formats.FilePattern;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.StatusEvent;
import loci.formats.StatusListener;
import loci.formats.gui.XMLWindow;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.plugins.DataBrowser;
import loci.plugins.ImporterOptions;
import loci.plugins.LociImporter;
import loci.plugins.SearchableWindow;
import loci.plugins.Util;
import loci.plugins.VirtualImagePlus;
import org.xml.sax.SAXException;

public class Importer {
    private LociImporter plugin;
    private Vector imps = new Vector();
    private String stackOrder = null;

    public Importer(LociImporter plugin) {
        this.plugin = plugin;
    }

    public void run(String arg) {
        boolean windowless;
        ReflectedUniverse ru;
        ImporterOptions options = new ImporterOptions();
        options.loadPreferences();
        options.parseArg(arg);
        int status = options.promptLocation();
        if (!this.statusOk(status)) {
            return;
        }
        status = options.promptId();
        if (!this.statusOk(status)) {
            return;
        }
        String id = options.getId();
        boolean quiet = options.isQuiet();
        Location idLoc = options.getIdLocation();
        String idName = options.getIdName();
        String idType = options.getIdType();
        IFormatReader r = null;
        if (options.isLocal() || options.isHTTP()) {
            IJ.showStatus((String)("Identifying " + idName));
            ImageReader reader = Util.makeImageReader();
            try {
                r = reader.getReader(id);
            }
            catch (FormatException exc) {
                this.reportException(exc, quiet, "Sorry, there was an error reading the file.");
                return;
            }
            catch (IOException exc) {
                this.reportException(exc, quiet, "Sorry, there was a I/O problem reading the file.");
                return;
            }
        } else if (options.isOMERO()) {
            try {
                ru = new ReflectedUniverse();
                ru.exec("import loci.ome.io.OMEROReader");
                r = (IFormatReader)ru.exec("new OMEROReader()");
            }
            catch (ReflectException exc) {
                this.reportException(exc, options.isQuiet(), "Sorry, there was a problem constructing the OMERO I/O engine");
                return;
            }
        } else if (options.isOME()) {
            try {
                ru = new ReflectedUniverse();
                ru.exec("import loci.ome.io.OMEReader");
                r = (IFormatReader)ru.exec("new OMEReader()");
            }
            catch (ReflectException exc) {
                this.reportException(exc, options.isQuiet(), "Sorry, there was a problem constructing the OME I/O engine");
                return;
            }
        } else {
            this.reportException(null, options.isQuiet(), "Sorry, there has been an internal error: unknown data source");
        }
        IMetadata omexmlMeta = MetadataTools.createOMEXMLMetadata();
        r.setMetadataStore(omexmlMeta);
        IJ.showStatus((String)"");
        r.addStatusListener(new StatusEchoer());
        boolean bl = windowless = options.isWindowless() || Util.isWindowless(r);
        if (!windowless) {
            status = options.promptOptions();
        }
        if (!this.statusOk(status)) {
            return;
        }
        boolean mergeChannels = options.isMergeChannels();
        boolean colorize = options.isColorize();
        boolean showMetadata = options.isShowMetadata();
        boolean showOMEXML = options.isShowOMEXML();
        boolean groupFiles = options.isGroupFiles();
        boolean concatenate = options.isConcatenate();
        boolean specifyRanges = options.isSpecifyRanges();
        boolean cropOnImport = options.doCrop();
        boolean swapDimensions = options.isSwapDimensions();
        options.savePreferences();
        String a = id;
        if (options.isOME() || options.isOMERO()) {
            a = "...";
        }
        IJ.showStatus((String)("Analyzing " + a));
        try {
            int i;
            int i2;
            r.setMetadataFiltered(true);
            r.setNormalized(true);
            r.setId(id);
            int pixelType = r.getPixelType();
            String currentFile = r.getCurrentFile();
            if (groupFiles) {
                status = options.promptFilePattern();
                if (!this.statusOk(status)) {
                    return;
                }
                id = options.getId();
                if (id == null) {
                    id = currentFile;
                }
            }
            if (groupFiles) {
                r = new FileStitcher(r, true);
            }
            r = new VirtualReader(new ChannelSeparator(r));
            r.setId(id);
            int seriesCount = r.getSeriesCount();
            int[] num = new int[seriesCount];
            int[] sizeC = new int[seriesCount];
            int[] sizeZ = new int[seriesCount];
            int[] sizeT = new int[seriesCount];
            boolean[] certain = new boolean[seriesCount];
            int[] cBegin = new int[seriesCount];
            int[] cEnd = new int[seriesCount];
            int[] cStep = new int[seriesCount];
            int[] zBegin = new int[seriesCount];
            int[] zEnd = new int[seriesCount];
            int[] zStep = new int[seriesCount];
            int[] tBegin = new int[seriesCount];
            int[] tEnd = new int[seriesCount];
            int[] tStep = new int[seriesCount];
            boolean[] series = new boolean[seriesCount];
            for (int i3 = 0; i3 < seriesCount; ++i3) {
                r.setSeries(i3);
                num[i3] = r.getImageCount();
                sizeC[i3] = r.getEffectiveSizeC();
                sizeZ[i3] = r.getSizeZ();
                sizeT[i3] = r.getSizeT();
                certain[i3] = r.isOrderCertain();
                tBegin[i3] = 0;
                zBegin[i3] = 0;
                cBegin[i3] = 0;
                cEnd[i3] = sizeC[i3] - 1;
                zEnd[i3] = sizeZ[i3] - 1;
                tEnd[i3] = sizeT[i3] - 1;
                tStep[i3] = 1;
                zStep[i3] = 1;
                cStep[i3] = 1;
            }
            series[0] = true;
            String[] seriesLabels = new String[seriesCount];
            for (i2 = 0; i2 < seriesCount; ++i2) {
                r.setSeries(i2);
                StringBuffer sb = new StringBuffer();
                String name = omexmlMeta.getImageName(i2);
                if (name != null && name.length() > 0) {
                    sb.append(name);
                    sb.append(": ");
                }
                sb.append(r.getSizeX());
                sb.append(" x ");
                sb.append(r.getSizeY());
                sb.append("; ");
                sb.append(num[i2]);
                sb.append(" plane");
                if (num[i2] > 1) {
                    sb.append("s");
                    if (certain[i2]) {
                        sb.append(" (");
                        boolean first = true;
                        if (sizeC[i2] > 1) {
                            sb.append(sizeC[i2]);
                            sb.append("C");
                            first = false;
                        }
                        if (sizeZ[i2] > 1) {
                            if (!first) {
                                sb.append(" x ");
                            }
                            sb.append(sizeZ[i2]);
                            sb.append("Z");
                            first = false;
                        }
                        if (sizeT[i2] > 1) {
                            if (!first) {
                                sb.append(" x ");
                            }
                            sb.append(sizeT[i2]);
                            sb.append("T");
                            first = false;
                        }
                        sb.append(")");
                    }
                }
                seriesLabels[i2] = sb.toString();
            }
            if (seriesCount > 1 && !options.openAllSeries() && !this.statusOk(status = options.promptSeries(r, seriesLabels, series))) {
                return;
            }
            if (options.openAllSeries()) {
                Arrays.fill(series, true);
            }
            if (swapDimensions) {
                options.promptSwap((DimensionSwapper)r, series);
                for (i2 = 0; i2 < seriesCount; ++i2) {
                    r.setSeries(i2);
                    num[i2] = r.getImageCount();
                    sizeC[i2] = r.getEffectiveSizeC();
                    sizeZ[i2] = r.getSizeZ();
                    sizeT[i2] = r.getSizeT();
                    certain[i2] = r.isOrderCertain();
                    tBegin[i2] = 0;
                    zBegin[i2] = 0;
                    cBegin[i2] = 0;
                    cEnd[i2] = sizeC[i2] - 1;
                    zEnd[i2] = sizeZ[i2] - 1;
                    tEnd[i2] = sizeT[i2] - 1;
                    tStep[i2] = 1;
                    zStep[i2] = 1;
                    cStep[i2] = 1;
                }
            }
            if (specifyRanges) {
                boolean needRange = false;
                for (int i4 = 0; i4 < seriesCount; ++i4) {
                    if (!series[i4] || num[i4] <= 1) continue;
                    needRange = true;
                }
                if (needRange) {
                    IJ.showStatus((String)"");
                    status = options.promptRange(r, series, seriesLabels, cBegin, cEnd, cStep, zBegin, zEnd, zStep, tBegin, tEnd, tStep);
                    if (!this.statusOk(status)) {
                        return;
                    }
                }
            }
            int[] cCount = new int[seriesCount];
            int[] zCount = new int[seriesCount];
            int[] tCount = new int[seriesCount];
            for (int i5 = 0; i5 < seriesCount; ++i5) {
                cCount[i5] = (cEnd[i5] - cBegin[i5] + cStep[i5]) / cStep[i5];
                zCount[i5] = (zEnd[i5] - zBegin[i5] + zStep[i5]) / zStep[i5];
                tCount[i5] = (tEnd[i5] - tBegin[i5] + tStep[i5]) / tStep[i5];
            }
            Rectangle[] cropOptions = new Rectangle[seriesCount];
            for (i = 0; i < cropOptions.length; ++i) {
                if (!series[i] || !cropOnImport) continue;
                cropOptions[i] = new Rectangle();
            }
            if (cropOnImport && !this.statusOk(status = options.promptCropSize(r, seriesLabels, series, cropOptions))) {
                return;
            }
            if (showMetadata) {
                IJ.showStatus((String)"Populating metadata");
                Hashtable meta = r.getMetadata();
                meta.put(idType, currentFile);
                int digits = this.digits(seriesCount);
                for (int i6 = 0; i6 < seriesCount; ++i6) {
                    if (!series[i6]) continue;
                    r.setSeries(i6);
                    String s = omexmlMeta.getImageName(i6);
                    if ((s == null || s.trim().length() == 0) && seriesCount > 1) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("Series ");
                        int zeroes = digits - this.digits(i6 + 1);
                        for (int j = 0; j < zeroes; ++j) {
                            sb.append(0);
                        }
                        sb.append(i6 + 1);
                        sb.append(" ");
                        s = sb.toString();
                    } else {
                        s = s + " ";
                    }
                    String pad = " ";
                    meta.put(" " + s + "SizeX", new Integer(r.getSizeX()));
                    meta.put(" " + s + "SizeY", new Integer(r.getSizeY()));
                    meta.put(" " + s + "SizeZ", new Integer(r.getSizeZ()));
                    meta.put(" " + s + "SizeT", new Integer(r.getSizeT()));
                    meta.put(" " + s + "SizeC", new Integer(r.getSizeC()));
                    meta.put(" " + s + "IsRGB", new Boolean(r.isRGB()));
                    meta.put(" " + s + "PixelType", FormatTools.getPixelTypeString(r.getPixelType()));
                    meta.put(" " + s + "LittleEndian", new Boolean(r.isLittleEndian()));
                    meta.put(" " + s + "DimensionOrder", r.getDimensionOrder());
                    meta.put(" " + s + "IsInterleaved", new Boolean(r.isInterleaved()));
                }
                String metaString = this.getMetadataString(meta, "\t");
                SearchableWindow w = new SearchableWindow("Original Metadata - " + id, "Key\tValue", metaString, 400, 400);
                w.setVisible(true);
            }
            if (showOMEXML && !options.isViewBrowser()) {
                XMLWindow metaWindow = new XMLWindow("OME Metadata - " + id);
                try {
                    metaWindow.setXML(MetadataTools.getOMEXML(omexmlMeta));
                    Util.placeWindow(metaWindow);
                    metaWindow.setVisible(true);
                }
                catch (ParserConfigurationException exc) {
                    this.reportException(exc, options.isQuiet(), "Sorry, there was a problem displaying the OME metadata");
                }
                catch (SAXException exc) {
                    this.reportException(exc, options.isQuiet(), "Sorry, there was a problem displaying the OME metadata");
                }
            }
            if (options.isViewNone()) {
                return;
            }
            IJ.showStatus((String)("Reading " + currentFile));
            if (options.isVirtual()) {
                int totalSeries = 0;
                for (int i7 = 0; i7 < seriesCount; ++i7) {
                    if (!series[i7]) continue;
                    ++totalSeries;
                }
                ((VirtualReader)r).setRefCount(totalSeries);
            }
            for (i = 0; i < seriesCount; ++i) {
                long startTime;
                String idDir;
                if (!series[i]) continue;
                r.setSeries(i);
                boolean[] load = new boolean[num[i]];
                if (!options.isViewNone()) {
                    for (int c = cBegin[i]; c <= cEnd[i]; c += cStep[i]) {
                        for (int z = zBegin[i]; z <= zEnd[i]; z += zStep[i]) {
                            for (int t = tBegin[i]; t <= tEnd[i]; t += tStep[i]) {
                                int index = r.getIndex(z, c, t);
                                load[index] = true;
                            }
                        }
                    }
                }
                int total = 0;
                for (int j = 0; j < num[i]; ++j) {
                    if (!load[j]) continue;
                    ++total;
                }
                FileInfo fi = new FileInfo();
                String string = idDir = idLoc == null ? null : idLoc.getParent();
                if (idDir != null && !idDir.endsWith(File.separator)) {
                    idDir = idDir + File.separator;
                }
                fi.fileName = idName;
                fi.directory = idDir;
                String metadata = this.getMetadataString(r.getMetadata(), " = ");
                long time = startTime = System.currentTimeMillis();
                ImageStack stackB = null;
                ImageStack stackS = null;
                ImageStack stackF = null;
                ImageStack stackO = null;
                int w = cropOnImport ? cropOptions[i].width : r.getSizeX();
                int h = cropOnImport ? cropOptions[i].height : r.getSizeY();
                int c = r.getRGBChannelCount();
                int type = r.getPixelType();
                int q = 0;
                this.stackOrder = options.getStackOrder();
                if (this.stackOrder.equals("Default")) {
                    this.stackOrder = r.getDimensionOrder();
                }
                ((DimensionSwapper)r).setOutputOrder(this.stackOrder);
                omexmlMeta.setPixelsDimensionOrder(this.stackOrder, i, 0);
                fi.description = MetadataTools.getOMEXML(omexmlMeta);
                if (options.isVirtual()) {
                    int cSize = r.getSizeC();
                    int pt = r.getPixelType();
                    boolean doMerge = options.isMergeChannels();
                    boolean eight = pt != 1 && pt != 0;
                    boolean needComposite = doMerge && (cSize > 3 || eight);
                    int merge = needComposite || !doMerge ? 1 : cSize;
                    try {
                        int j;
                        ReflectedUniverse ru2 = new ReflectedUniverse();
                        ru2.exec("import loci.plugins.BFVirtualStack");
                        ru2.setVar("id", id);
                        ru2.setVar("r", r);
                        ru2.setVar("colorize", colorize);
                        ru2.setVar("merge", doMerge);
                        ru2.setVar("record", options.isRecord());
                        stackB = (ImageStack)ru2.exec("stackB = new BFVirtualStack(id, r, colorize, merge, record)");
                        if (doMerge) {
                            cCount[i] = 1;
                            for (j = 0; j < num[i]; ++j) {
                                int[] pos = r.getZCTCoords(j);
                                if (pos[1] > 0) continue;
                                String label = this.constructSliceLabel(new ChannelMerger(r).getIndex(pos[0], pos[1], pos[2]), r, omexmlMeta, i, zCount, cCount, tCount);
                                ru2.setVar("label", label);
                                ru2.exec("stackB.addSlice(label)");
                            }
                        }
                        for (j = 0; j < num[i]; ++j) {
                            String label = this.constructSliceLabel(j, r, omexmlMeta, i, zCount, cCount, tCount);
                            ru2.setVar("label", label);
                            ru2.exec("stackB.addSlice(label)");
                        }
                    }
                    catch (ReflectException exc) {
                        this.reportException(exc, options.isQuiet(), "Sorry, there was a problem constructing the virtual stack");
                        return;
                    }
                } else {
                    for (int j = 0; j < num[i]; ++j) {
                        if (!load[j]) continue;
                        long clock = System.currentTimeMillis();
                        if (clock - time >= 100L) {
                            IJ.showStatus((String)("Reading " + (seriesCount > 1 ? "series " + (i + 1) + ", " : "") + "plane " + (j + 1) + "/" + num[i]));
                            time = clock;
                        }
                        IJ.showProgress((double)((double)q++ / (double)total));
                        int ndx = j;
                        String label = this.constructSliceLabel(ndx, r, omexmlMeta, i, zCount, cCount, tCount);
                        ImageProcessor ip = Util.openProcessors(r, ndx, cropOptions[i])[0];
                        if (ip == null) {
                            this.plugin.canceled = true;
                            return;
                        }
                        if (ip instanceof ByteProcessor) {
                            if (stackB == null) {
                                stackB = new ImageStack(w, h);
                            }
                            stackB.addSlice(label, ip);
                            continue;
                        }
                        if (ip instanceof ShortProcessor) {
                            if (stackS == null) {
                                stackS = new ImageStack(w, h);
                            }
                            stackS.addSlice(label, ip);
                            continue;
                        }
                        if (ip instanceof FloatProcessor) {
                            if (stackB != null) {
                                ip = ip.convertToByte(true);
                                stackB.addSlice(label, ip);
                                continue;
                            }
                            if (stackS != null) {
                                ip = ip.convertToShort(true);
                                stackS.addSlice(label, ip);
                                continue;
                            }
                            if (stackF == null) {
                                stackF = new ImageStack(w, h);
                            }
                            stackF.addSlice(label, ip);
                            continue;
                        }
                        if (!(ip instanceof ColorProcessor)) continue;
                        if (stackO == null) {
                            stackO = new ImageStack(w, h);
                        }
                        stackO.addSlice(label, ip);
                    }
                }
                IJ.showStatus((String)"Creating image");
                IJ.showProgress((double)1.0);
                String seriesName = omexmlMeta.getImageName(i);
                this.showStack(stackB, currentFile, seriesName, omexmlMeta, cCount[i], zCount[i], tCount[i], sizeZ[i], sizeC[i], sizeT[i], fi, r, options, metadata, windowless);
                this.showStack(stackS, currentFile, seriesName, omexmlMeta, cCount[i], zCount[i], tCount[i], sizeZ[i], sizeC[i], sizeT[i], fi, r, options, metadata, windowless);
                this.showStack(stackF, currentFile, seriesName, omexmlMeta, cCount[i], zCount[i], tCount[i], sizeZ[i], sizeC[i], sizeT[i], fi, r, options, metadata, windowless);
                this.showStack(stackO, currentFile, seriesName, omexmlMeta, cCount[i], zCount[i], tCount[i], sizeZ[i], sizeC[i], sizeT[i], fi, r, options, metadata, windowless);
                long endTime = System.currentTimeMillis();
                double elapsed = (double)(endTime - startTime) / 1000.0;
                if (num[i] == 1) {
                    IJ.showStatus((String)("Bio-Formats: " + elapsed + " seconds"));
                    continue;
                }
                long average = (endTime - startTime) / (long)num[i];
                IJ.showStatus((String)("Bio-Formats: " + elapsed + " seconds (" + average + " ms per plane)"));
            }
            if (concatenate) {
                Vector<Integer> widths = new Vector<Integer>();
                Vector<Integer> heights = new Vector<Integer>();
                Vector<Integer> types = new Vector<Integer>();
                Vector<ImagePlus> newImps = new Vector<ImagePlus>();
                for (int j = 0; j < this.imps.size(); ++j) {
                    ImagePlus imp = (ImagePlus)this.imps.get(j);
                    int wj = imp.getWidth();
                    int hj = imp.getHeight();
                    int tj = imp.getBitDepth();
                    boolean append = false;
                    for (int k = 0; k < widths.size(); ++k) {
                        int wk = (Integer)widths.get(k);
                        int hk = (Integer)heights.get(k);
                        int tk = (Integer)types.get(k);
                        if (wj != wk || hj != hk || tj != tk) continue;
                        ImagePlus oldImp = (ImagePlus)newImps.get(k);
                        ImageStack is = oldImp.getStack();
                        ImageStack newStack = imp.getStack();
                        for (int s = 0; s < newStack.getSize(); ++s) {
                            is.addSlice(newStack.getSliceLabel(s + 1), newStack.getProcessor(s + 1));
                        }
                        oldImp.setStack(oldImp.getTitle(), is);
                        newImps.setElementAt(oldImp, k);
                        append = true;
                        k = widths.size();
                    }
                    if (append) continue;
                    widths.add(new Integer(wj));
                    heights.add(new Integer(hj));
                    types.add(new Integer(tj));
                    newImps.add(imp);
                }
                boolean splitC = options.isSplitChannels();
                boolean splitZ = options.isSplitFocalPlanes();
                boolean splitT = options.isSplitTimepoints();
                for (int j = 0; j < newImps.size(); ++j) {
                    ImagePlus imp = (ImagePlus)newImps.get(j);
                    imp.show();
                    if (!splitC && !splitZ && !splitT) continue;
                    IJ.runPlugIn((String)"loci.plugins.Slicer", (String)("slice_z=" + splitZ + " slice_c=" + splitC + " slice_t=" + splitT + " stack_order=" + this.stackOrder + " keep_original=false " + "hyper_stack=" + options.isViewHyperstack() + " "));
                }
            }
            try {
                if (!options.isVirtual()) {
                    r.close();
                }
            }
            catch (IOException exc) {
                this.reportException(exc, options.isQuiet(), "Sorry, there was a problem closing the file");
            }
            this.plugin.success = true;
        }
        catch (FormatException exc) {
            this.reportException(exc, quiet, "Sorry, there was a problem reading the data.");
        }
        catch (IOException exc) {
            this.reportException(exc, quiet, "Sorry, there was an I/O problem reading the data.");
        }
    }

    private void showStack(ImageStack stack, String file2, String series, MetadataRetrieve retrieve, int cCount, int zCount, int tCount, int sizeZ, int sizeC, int sizeT, FileInfo fi, IFormatReader r, ImporterOptions options, String metadata, boolean windowless) throws FormatException, IOException {
        if (stack == null) {
            return;
        }
        String title = this.getTitle(r, file2, series, options.isGroupFiles());
        VirtualImagePlus imp = null;
        if (options.isVirtual()) {
            imp = new VirtualImagePlus(title, stack);
            imp.setReader(r);
        } else {
            imp = new ImagePlus(title, stack);
        }
        imp.setProperty("Info", metadata);
        Util.applyCalibration(retrieve, imp, r.getSeries());
        imp.setFileInfo(fi);
        imp.setDimensions(cCount, zCount, tCount);
        this.displayStack(imp, r, options, windowless);
    }

    private void displayStack(ImagePlus imp, IFormatReader r, ImporterOptions options, boolean windowless) {
        ReflectedUniverse ru;
        boolean mergeChannels = options.isMergeChannels();
        boolean colorize = options.isColorize();
        boolean concatenate = options.isConcatenate();
        int nChannels = imp.getNChannels();
        int nSlices = imp.getNSlices();
        int nFrames = imp.getNFrames();
        if (options.isAutoscale() && !options.isVirtual()) {
            Util.adjustColorRange(imp);
        }
        boolean splitC = options.isSplitChannels();
        boolean splitZ = options.isSplitFocalPlanes();
        boolean splitT = options.isSplitTimepoints();
        int z = r.getSizeZ();
        int c = r.getSizeC();
        int t = r.getSizeT();
        if (!concatenate && mergeChannels) {
            imp.show();
        }
        if (!options.isVirtual()) {
            if (mergeChannels && windowless) {
                IJ.runPlugIn((String)"loci.plugins.Colorizer", (String)("stack_order=" + this.stackOrder + " merge=true merge_option=[" + options.getMergeOption() + "] " + "hyper_stack=" + options.isViewHyperstack() + " "));
            } else if (mergeChannels) {
                IJ.runPlugIn((String)"loci.plugins.Colorizer", (String)("stack_order=" + this.stackOrder + " merge=true hyper_stack=" + options.isViewHyperstack() + " "));
            }
        }
        imp.setDimensions(imp.getStackSize() / (nSlices * nFrames), nSlices, nFrames);
        if (options.isViewVisBio()) {
            ru = new ReflectedUniverse();
            try {
                ru.exec("import loci.visbio.data.Dataset");
                ru.exec("dataset = new Dataset(name, pattern)");
            }
            catch (ReflectException exc) {
                this.reportException(exc, options.isQuiet(), "Sorry, there was a problem interfacing with VisBio");
                return;
            }
        }
        if (options.isViewImage5D()) {
            ru = new ReflectedUniverse();
            try {
                ru.exec("import i5d.Image5D");
                ru.setVar("title", imp.getTitle());
                ru.setVar("stack", imp.getStack());
                ru.setVar("sizeC", c);
                ru.setVar("sizeZ", z);
                ru.setVar("sizeT", t);
                ru.exec("i5d = new Image5D(title, stack, sizeC, sizeZ, sizeT)");
                ru.setVar("cal", imp.getCalibration());
                ru.setVar("fi", imp.getOriginalFileInfo());
                ru.exec("i5d.setCalibration(cal)");
                ru.exec("i5d.setFileInfo(fi)");
                ru.exec("i5d.show()");
            }
            catch (ReflectException exc) {
                this.reportException(exc, options.isQuiet(), "Sorry, there was a problem interfacing with Image5D");
                return;
            }
        } else if (options.isViewView5D()) {
            WindowManager.setTempCurrentImage((ImagePlus)imp);
            IJ.run((String)"View5D ", (String)"");
        } else if (!options.isViewNone()) {
            if (IJ.getVersion().compareTo("1.39l") >= 0) {
                boolean hyper = options.isViewHyperstack() || options.isViewBrowser();
                imp.setOpenAsHyperStack(hyper);
            }
            if (!concatenate) {
                if (options.isViewBrowser()) {
                    DataBrowser dataBrowser = new DataBrowser(imp, null, r.getChannelDimTypes(), r.getChannelDimLengths());
                    if (options.isShowOMEXML()) {
                        dataBrowser.showMetadataWindow();
                    }
                } else {
                    imp.show();
                }
                if ((splitC || splitZ || splitT) && !options.isVirtual()) {
                    IJ.runPlugIn((String)"loci.plugins.Slicer", (String)("slice_z=" + splitZ + " slice_c=" + splitC + " slice_t=" + splitT + " stack_order=" + this.stackOrder + " keep_original=false " + "hyper_stack=" + options.isViewHyperstack() + " "));
                    if (colorize) {
                        int[] openImages = WindowManager.getIDList();
                        int nOpenImages = WindowManager.getImageCount();
                        for (int i = 0; i < nOpenImages; ++i) {
                            ImagePlus p = WindowManager.getImage((int)WindowManager.getNthImageID((int)1));
                            String title = p.getTitle();
                            if (!title.startsWith(imp.getTitle()) || title.indexOf("C=") == -1) continue;
                            int channel = Integer.parseInt(title.substring(title.indexOf("C=") + 2));
                            WindowManager.setCurrentWindow((ImageWindow)p.getWindow());
                            IJ.runPlugIn((String)"loci.plugins.Colorizer", (String)("stack_order=" + this.stackOrder + " merge=false colorize=true" + " ndx=" + channel % 3 + " hyper_stack=" + options.isViewHyperstack() + " "));
                        }
                    }
                } else if (colorize && !options.isVirtual()) {
                    IJ.runPlugIn((String)"loci.plugins.Colorizer", (String)("stack_order=" + this.stackOrder + " merge=false colorize=true ndx=0 hyper_stack=" + options.isViewHyperstack() + " "));
                }
            } else {
                this.imps.add(imp);
            }
        }
    }

    private int digits(int value) {
        int digits = 0;
        while (value > 0) {
            value /= 10;
            ++digits;
        }
        return digits;
    }

    private String getTitle(IFormatReader r, String file2, String series, boolean groupFiles) {
        FilePattern fp;
        String[] used = r.getUsedFiles();
        String title = file2.substring(file2.lastIndexOf(File.separator) + 1);
        if (used.length > 1 && groupFiles && (fp = new FilePattern(new Location(file2))) != null) {
            title = fp.getPattern();
            if (title == null && (title = file2).indexOf(".") != -1) {
                title = title.substring(0, title.lastIndexOf("."));
            }
            title = title.substring(title.lastIndexOf(File.separator) + 1);
        }
        if (series != null && !file2.endsWith(series) && r.getSeriesCount() > 1) {
            title = title + " - " + series;
        }
        if (title.length() > 128) {
            String a = title.substring(0, 62);
            String b = title.substring(title.length() - 62);
            title = a + "..." + b;
        }
        return title;
    }

    private String constructSliceLabel(int ndx, IFormatReader r, MetadataRetrieve retrieve, int series, int[] zCount, int[] cCount, int[] tCount) {
        String imageName;
        r.setSeries(series);
        int[] zct = r.getZCTCoords(ndx);
        int[] subC = r.getChannelDimLengths();
        String[] subCTypes = r.getChannelDimTypes();
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if (cCount[series] > 1) {
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            int[] subCPos = FormatTools.rasterToPosition(subC, zct[1]);
            for (int i = 0; i < subC.length; ++i) {
                boolean ch = subCTypes[i].equals("Channel");
                sb.append(ch ? "c" : subCTypes[i]);
                sb.append(":");
                sb.append(subCPos[i] + 1);
                sb.append("/");
                sb.append(subC[i]);
                if (i >= subC.length - 1) continue;
                sb.append(", ");
            }
        }
        if (zCount[series] > 1) {
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            sb.append("z:");
            sb.append(zct[0] + 1);
            sb.append("/");
            sb.append(r.getSizeZ());
        }
        if (tCount[series] > 1) {
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            sb.append("t:");
            sb.append(zct[2] + 1);
            sb.append("/");
            sb.append(r.getSizeT());
        }
        if ((imageName = retrieve.getImageName(series)) != null && !imageName.trim().equals("")) {
            sb.append(" - ");
            sb.append(imageName);
        }
        return sb.toString();
    }

    private boolean statusOk(int status) {
        if (status == 1) {
            this.plugin.canceled = true;
        }
        return status == 0;
    }

    private void reportException(Throwable t, boolean quiet, String msg) {
        IJ.showStatus((String)"");
        if (!quiet) {
            if (t != null) {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                t.printStackTrace(new PrintStream(buf));
                String s = new String(buf.toByteArray());
                StringTokenizer st = new StringTokenizer(s, "\n\r");
                while (st.hasMoreTokens()) {
                    IJ.write((String)st.nextToken());
                }
            }
            IJ.error((String)"Bio-Formats Importer", (String)msg);
        }
    }

    private String getMetadataString(Hashtable meta, String separator) {
        Enumeration e = meta.keys();
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            v.add(e.nextElement());
        }
        Object[] keys = new String[v.size()];
        v.copyInto(keys);
        Arrays.sort(keys);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < keys.length; ++i) {
            sb.append((String)keys[i]);
            sb.append(separator);
            sb.append(meta.get(keys[i]));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        new ImageJ(null);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(args[i]);
        }
        new LociImporter().run(sb.toString());
    }

    private class VirtualReader
    extends DimensionSwapper {
        private int refCount;

        public VirtualReader(IFormatReader r) {
            super(r);
            this.refCount = 0;
        }

        public void setRefCount(int refCount) {
            this.refCount = refCount;
        }

        public void close() throws IOException {
            if (this.refCount > 0) {
                --this.refCount;
            }
            if (this.refCount == 0) {
                super.close();
            }
        }
    }

    private static class StatusEchoer
    implements StatusListener {
        private StatusEchoer() {
        }

        public void statusUpdated(StatusEvent e) {
            IJ.showStatus((String)e.getStatusMessage());
        }
    }
}

