/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.io.IOException;
import java.util.Vector;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.TiffTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.out.TiffWriter;

public class OMETiffWriter
extends TiffWriter {
    private static final String WARNING_COMMENT = "<!-- Warning: this comment is an OME-XML metadata block, which contains crucial dimensional parameters and other important metadata. Please edit cautiously (if at all), and back up the original data before doing so. For more information, see the OME-TIFF web site: http://loci.wisc.edu/ome/ome-tiff.html. -->";
    private Vector seriesMap;

    public OMETiffWriter() {
        super("OME-TIFF", new String[]{"ome.tif", "ome.tiff"});
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        if (this.currentId != null) {
            MetadataRetrieve retrieve = this.getMetadataRetrieve();
            String xml = MetadataTools.getOMEXML(retrieve);
            String prefix = xml.substring(0, xml.indexOf(">") + 1);
            String suffix = xml.substring(xml.indexOf(">") + 1);
            xml = prefix + WARNING_COMMENT + suffix;
            int previousPixelsIndex = 0;
            for (int series = 0; series < retrieve.getImageCount(); ++series) {
                String dimensionOrder = retrieve.getPixelsDimensionOrder(series, 0);
                int sizeZ = retrieve.getPixelsSizeZ(series, 0);
                int sizeC = retrieve.getPixelsSizeC(series, 0);
                int sizeT = retrieve.getPixelsSizeT(series, 0);
                int imageCount = 0;
                for (int q = 0; q < this.seriesMap.size(); ++q) {
                    if ((Integer)this.seriesMap.get(q) != series) continue;
                    ++imageCount;
                }
                if (imageCount < sizeZ * sizeC * sizeT) {
                    sizeC = imageCount / (sizeZ * sizeT);
                }
                StringBuffer tiffData = new StringBuffer();
                tiffData.append(">");
                int num = 0;
                for (int q = 0; q < imageCount; ++q) {
                    while ((Integer)this.seriesMap.get(num) != series) {
                        ++num;
                    }
                    int[] coordinates = FormatTools.getZCTCoords(dimensionOrder, sizeZ, sizeC, sizeT, imageCount, q);
                    tiffData.append("<TiffData IFD=\"");
                    tiffData.append(num);
                    tiffData.append("\" FirstZ=\"");
                    tiffData.append(coordinates[0]);
                    tiffData.append("\" FirstC=\"");
                    tiffData.append(coordinates[1]);
                    tiffData.append("\" FirstT=\"");
                    tiffData.append(coordinates[2]);
                    tiffData.append("\" />");
                    ++num;
                }
                tiffData.append("</Pixels>");
                int pix = xml.indexOf("<Pixels ", previousPixelsIndex);
                int end = xml.indexOf("</Pixels", pix);
                int len = 9;
                if (end == -1) {
                    end = xml.indexOf("/>", pix);
                    len = 2;
                }
                prefix = xml.substring(0, end);
                suffix = xml.substring(end + len);
                xml = prefix + tiffData.toString() + suffix;
                previousPixelsIndex = pix + 8;
            }
            try {
                TiffTools.overwriteComment(this.currentId, xml);
            }
            catch (FormatException exc) {
                IOException io = new IOException("Unable to append OME-XML comment");
                io.initCause(exc);
                throw io;
            }
        }
        super.close();
        this.seriesMap = null;
    }

    public void saveImage(Image image, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        if (this.seriesMap == null) {
            this.seriesMap = new Vector();
        }
        this.seriesMap.add(new Integer(series));
        super.saveImage(image, series, lastInSeries, last);
    }
}

