/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.Point;
import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class InCellReader
extends FormatReader {
    private Vector tiffs;
    private MinimalTiffReader tiffReader;
    private int seriesCount;
    private Vector emWaves;
    private Vector exWaves;
    private Vector timings;
    private int totalImages;
    private String creationDate;
    private int startRow;
    private int startCol;
    private int fieldCount;
    private int zCount;
    private int wellRows;
    private int wellCols;
    private Vector wellCoordinates;

    public InCellReader() {
        super("InCell 1000", "xdce");
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReader.get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReader.get16BitLookupTable();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        this.tiffReader.setId((String)this.tiffs.get(this.series * this.getImageCount() + no));
        return this.tiffReader.openBytes(0, buf, x, y, w, h);
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> v = new Vector<String>();
        v.add(this.currentId);
        for (int i = 0; i < this.tiffs.size(); ++i) {
            v.add((String)this.tiffs.get(i));
        }
        return v.toArray(new String[0]);
    }

    public void close() throws IOException {
        super.close();
        this.tiffs = null;
        if (this.tiffReader != null) {
            this.tiffReader.close();
        }
        this.tiffReader = null;
        this.seriesCount = 0;
        this.totalImages = 0;
        this.exWaves = null;
        this.emWaves = null;
        this.wellCoordinates = null;
        this.timings = null;
        this.creationDate = null;
        this.wellCols = 0;
        this.wellRows = 0;
        this.startCol = 0;
        this.startRow = 0;
        this.zCount = 0;
        this.fieldCount = 0;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int q;
        int i;
        if (debug) {
            this.debug("InCellReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.tiffs = new Vector();
        this.emWaves = new Vector();
        this.exWaves = new Vector();
        this.timings = new Vector();
        this.wellCoordinates = new Vector();
        byte[] b = new byte[(int)this.in.length()];
        this.in.read(b);
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        DefaultHandler handler = new MinimalInCellHandler();
        DataTools.parseXML(b, handler);
        this.core[0].sizeZ = this.fieldCount * this.zCount;
        this.seriesCount = this.totalImages / (this.getSizeZ() * this.getSizeC() * this.getSizeT());
        int z = this.getSizeZ();
        int c = this.getSizeC();
        int t = this.getSizeT();
        this.core = new CoreMetadata[this.seriesCount];
        for (int i2 = 0; i2 < this.seriesCount; ++i2) {
            this.core[i2] = new CoreMetadata();
            this.core[i2].sizeZ = z;
            this.core[i2].sizeC = c;
            this.core[i2].sizeT = t;
            this.core[i2].imageCount = z * c * t;
            this.core[i2].dimensionOrder = "XYZCT";
        }
        this.tiffReader = new MinimalTiffReader();
        int nextTiming = 0;
        for (i = 0; i < this.seriesCount; ++i) {
            this.tiffReader.setId((String)this.tiffs.get(i * (this.tiffs.size() / this.seriesCount)));
            this.core[i].sizeX = this.tiffReader.getSizeX();
            this.core[i].sizeY = this.tiffReader.getSizeY();
            this.core[i].interleaved = this.tiffReader.isInterleaved();
            this.core[i].indexed = this.tiffReader.isIndexed();
            this.core[i].rgb = this.tiffReader.isRGB();
            this.core[i].pixelType = this.tiffReader.getPixelType();
            this.core[i].littleEndian = this.tiffReader.isLittleEndian();
        }
        MetadataTools.populatePixels(store, this, true);
        handler = new InCellHandler(store);
        DataTools.parseXML(b, handler);
        for (i = 0; i < this.seriesCount; ++i) {
            store.setImageName("", i);
            store.setImageCreationDate(this.creationDate, i);
        }
        for (i = 0; i < this.seriesCount; ++i) {
            for (q = 0; q < this.core[i].imageCount; ++q) {
                store.setPlaneTimingDeltaT((Float)this.timings.get(nextTiming++), i, 0, q);
                store.setPlaneTimingExposureTime(new Float(0.0f), i, 0, q);
            }
        }
        for (i = 0; i < this.seriesCount; ++i) {
            for (q = 0; q < this.emWaves.size(); ++q) {
                store.setLogicalChannelEmWave((Integer)this.emWaves.get(q), i, q);
                store.setLogicalChannelExWave((Integer)this.exWaves.get(q), i, q);
            }
        }
        for (i = 0; i < this.seriesCount; ++i) {
            int row = ((Point)this.wellCoordinates.get((int)i)).x - this.startRow;
            int col = ((Point)this.wellCoordinates.get((int)i)).y - this.startCol;
            store.setWellSampleIndex(new Integer(i), 0, row * this.wellCols + col, 0);
        }
    }

    class InCellHandler
    extends DefaultHandler {
        private String currentQName;
        private int nextEmWave = 0;
        private int nextExWave = 0;
        private MetadataStore store;
        private int nextPlate = 0;
        private int currentRow = -1;
        private int currentCol = -1;

        public InCellHandler(MetadataStore store) {
            this.store = store;
        }

        public void characters(char[] ch, int start, int length) {
            String value = new String(ch, start, length);
            if (this.currentQName.equals("UserComment")) {
                this.store.setImageDescription(value, 0);
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("Image")) {
                Point p = new Point(this.currentRow, this.currentCol);
                if (!InCellReader.this.wellCoordinates.contains(p)) {
                    InCellReader.this.wellCoordinates.add(p);
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentQName = qName;
            for (int i = 0; i < attributes.getLength(); ++i) {
                InCellReader.this.addMeta(qName + " - " + attributes.getQName(i), attributes.getValue(i));
            }
            if (qName.equals("Image")) {
                InCellReader.this.timings.add(new Float(attributes.getValue("acquisition_time_ms")));
            } else if (qName.equals("Creation")) {
                String date = attributes.getValue("date");
                String time = attributes.getValue("time");
                InCellReader.this.creationDate = date + "T" + time;
            } else if (qName.equals("ObjectiveCalibration")) {
                this.store.setObjectiveCalibratedMagnification(new Float(attributes.getValue("magnification")), 0, 0);
                this.store.setObjectiveModel(attributes.getValue("objective_name"), 0, 0);
                this.store.setObjectiveLensNA(new Float(attributes.getValue("numerical_aperture")), 0, 0);
                this.store.setObjectiveID("Objective:0", 0, 0);
                this.store.setObjectiveSettingsObjective("Objective:0", 0);
            } else if (qName.equals("ExcitationFilter")) {
                String wave = attributes.getValue("wavelength");
                if (wave != null) {
                    InCellReader.this.exWaves.add(new Integer(wave));
                }
            } else if (qName.equals("EmissionFilter")) {
                String wave = attributes.getValue("wavelength");
                if (wave != null) {
                    InCellReader.this.emWaves.add(new Integer(wave));
                }
            } else if (qName.equals("Plate")) {
                this.store.setPlateName(new Location(InCellReader.this.getCurrentFile()).getName(), this.nextPlate);
                InCellReader.this.wellRows = Integer.parseInt(attributes.getValue("rows"));
                InCellReader.this.wellCols = Integer.parseInt(attributes.getValue("columns"));
                for (int r = 0; r < InCellReader.this.wellRows; ++r) {
                    for (int c = 0; c < InCellReader.this.wellCols; ++c) {
                        this.store.setWellRow(new Integer(r), this.nextPlate, r * InCellReader.this.wellCols + c);
                        this.store.setWellColumn(new Integer(c), this.nextPlate, r * InCellReader.this.wellCols + c);
                    }
                }
                ++this.nextPlate;
            } else if (qName.equals("Row")) {
                this.currentRow = Integer.parseInt(attributes.getValue("number"));
            } else if (qName.equals("Column")) {
                this.currentCol = Integer.parseInt(attributes.getValue("number"));
            } else if (qName.equals("NamingRows")) {
                String row = attributes.getValue("begin");
                try {
                    InCellReader.this.startRow = Integer.parseInt(row);
                }
                catch (NumberFormatException e) {
                    InCellReader.this.startRow = row.charAt(0) - 65 + 1;
                }
            } else if (qName.equals("NamingColumns")) {
                String col = attributes.getValue("begin");
                try {
                    InCellReader.this.startCol = Integer.parseInt(col);
                }
                catch (NumberFormatException e) {
                    InCellReader.this.startCol = col.charAt(0) - 65 + 1;
                }
            }
        }
    }

    class MinimalInCellHandler
    extends DefaultHandler {
        MinimalInCellHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("Images")) {
                InCellReader.this.totalImages = Integer.parseInt(attributes.getValue("number"));
            } else if (qName.equals("Image")) {
                String file2 = attributes.getValue("filename");
                String thumb = attributes.getValue("thumbnail");
                Location current = new Location(InCellReader.this.currentId).getAbsoluteFile();
                if (new Location(current.getParentFile(), file2).exists()) {
                    InCellReader.this.tiffs.add(new Location(current.getParentFile(), file2).getAbsolutePath());
                } else {
                    InCellReader.this.tiffs.add(file2);
                }
            } else if (qName.equals("Identifier")) {
                int field = Integer.parseInt(attributes.getValue("field_index")) + 1;
                int z = Integer.parseInt(attributes.getValue("z_index")) + 1;
                int c = Integer.parseInt(attributes.getValue("wave_index")) + 1;
                int t = Integer.parseInt(attributes.getValue("time_index")) + 1;
                InCellReader.this.fieldCount = Math.max(InCellReader.this.fieldCount, field);
                InCellReader.this.zCount = Math.max(InCellReader.this.zCount, z);
                ((InCellReader)InCellReader.this).core[0].sizeC = Math.max(InCellReader.this.getSizeC(), c);
                ((InCellReader)InCellReader.this).core[0].sizeT = Math.max(InCellReader.this.getSizeT(), t);
            }
        }
    }
}

