/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import loci.common.RandomAccessStream;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;

public class JPEGCodec
extends BaseCodec {
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        if (options.bitsPerSample > 8) {
            throw new FormatException("> 8 bit data cannot be compressed with JPEG.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedImage img = AWTImageTools.makeImage(data, options.width, options.height, options.channels, options.interleaved, options.bitsPerSample / 8, options.littleEndian);
        try {
            ImageIO.write((RenderedImage)img, "jpeg", out);
        }
        catch (IOException e) {
            throw new FormatException("Could not write JPEG data", e);
        }
        return out.toByteArray();
    }

    public byte[] decompress(RandomAccessStream in, CodecOptions options) throws FormatException, IOException {
        BufferedImage b;
        long fp = in.getFilePointer();
        try {
            try {
                while (in.read() != -1 || in.read() != -40) {
                }
                in.seek(in.getFilePointer() - 2L);
            }
            catch (EOFException e) {
                in.seek(fp);
            }
            Iterator<ImageReader> it = ImageIO.getImageReadersBySuffix("jpg");
            ImageReader r = null;
            String cname = "com.sun.imageio.plugins.jpeg.JPEGImageReader";
            while (it.hasNext()) {
                ImageReader tmp = it.next();
                if (!tmp.getClass().getName().equals(cname)) continue;
                r = tmp;
            }
            if (r == null) {
                throw new IOException("");
            }
            ImageInputStream ii = ImageIO.createImageInputStream(new BufferedInputStream(in));
            r.setInput(ii);
            b = r.read(0);
            ii.close();
            r.dispose();
        }
        catch (IOException exc) {
            exc.printStackTrace();
            try {
                Class<?> jpegSpi = Class.forName("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReaderSpi");
                IIORegistry registry = IIORegistry.getDefaultInstance();
                Object jpeg = registry.getServiceProviderByClass(jpegSpi);
                if (jpeg == null) {
                    throw new FormatException("Cannot locate JPEG decoder");
                }
                ImageReader r = ((ImageReaderSpi)jpeg).createReaderInstance();
                in.seek(fp);
                while (in.read() != -1 || in.read() != -40) {
                }
                in.seek(in.getFilePointer() - 2L);
                ImageInputStream ii = ImageIO.createImageInputStream(new BufferedInputStream(in));
                r.setInput(ii);
                b = r.read(0);
                ii.close();
                r.dispose();
            }
            catch (ClassNotFoundException e) {
                throw new FormatException("An I/O error occurred while decompressing the image", e);
            }
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        byte[][] buf = AWTImageTools.getPixelBytes(b, options.littleEndian);
        byte[] rtn = new byte[buf.length * buf[0].length];
        if (buf.length == 1) {
            rtn = buf[0];
        } else if (options.interleaved) {
            int next = 0;
            for (int i = 0; i < buf[0].length; ++i) {
                for (int j = 0; j < buf.length; ++j) {
                    rtn[next++] = buf[j][i];
                }
            }
        } else {
            for (int i = 0; i < buf.length; ++i) {
                System.arraycopy(buf[i], 0, rtn, i * buf[0].length, buf[i].length);
            }
        }
        return rtn;
    }
}

