/*
 * Decompiled with CFR 0.152.
 */
package thredds.datamodel.gis;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import thredds.datamodel.gis.GisFeature;
import thredds.datamodel.gis.GisPart;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;

public abstract class AbstractGisFeature
implements GisFeature {
    public abstract Rectangle2D getBounds2D();

    public abstract int getNumPoints();

    public abstract int getNumParts();

    public abstract Iterator getGisParts();

    public Shape getShape() {
        int npts = this.getNumPoints();
        GeneralPath path = new GeneralPath(0, npts);
        Iterator pi = this.getGisParts();
        while (pi.hasNext()) {
            GisPart gp = (GisPart)pi.next();
            double[] xx = gp.getX();
            double[] yy = gp.getY();
            int np = gp.getNumPoints();
            if (np > 0) {
                path.moveTo((float)xx[0], (float)yy[0]);
            }
            for (int i = 1; i < np; ++i) {
                path.lineTo((float)xx[i], (float)yy[i]);
            }
        }
        return path;
    }

    public Shape getProjectedShape(ProjectionImpl displayProject) {
        LatLonPointImpl workL = new LatLonPointImpl();
        ProjectionPointImpl lastW = new ProjectionPointImpl();
        GeneralPath path = new GeneralPath(0, this.getNumPoints());
        boolean showPts = false;
        Iterator pi = this.getGisParts();
        while (pi.hasNext()) {
            GisPart gp = (GisPart)pi.next();
            double[] xx = gp.getX();
            double[] yy = gp.getY();
            for (int i = 0; i < gp.getNumPoints(); ++i) {
                workL.set(yy[i], xx[i]);
                ProjectionPoint pt = displayProject.latLonToProj(workL);
                if (showPts) {
                    System.out.println("getProjectedShape 1 " + xx[i] + " " + yy[i] + " === " + pt.getX() + " " + pt.getY());
                    if (displayProject.crossSeam(pt, lastW)) {
                        System.out.println("***cross seam");
                    }
                }
                if (i == 0 || displayProject.crossSeam(pt, lastW)) {
                    path.moveTo((float)pt.getX(), (float)pt.getY());
                } else {
                    path.lineTo((float)pt.getX(), (float)pt.getY());
                }
                lastW.setLocation(pt);
            }
        }
        return path;
    }

    public Shape getProjectedShape(ProjectionImpl dataProject, ProjectionImpl displayProject) {
        ProjectionPointImpl pt1 = new ProjectionPointImpl();
        ProjectionPointImpl lastW = new ProjectionPointImpl();
        GeneralPath path = new GeneralPath(0, this.getNumPoints());
        boolean showPts = false;
        Iterator pi = this.getGisParts();
        while (pi.hasNext()) {
            GisPart gp = (GisPart)pi.next();
            double[] xx = gp.getX();
            double[] yy = gp.getY();
            for (int i = 0; i < gp.getNumPoints(); ++i) {
                pt1.setLocation(xx[i], yy[i]);
                LatLonPoint llpt = dataProject.projToLatLon(pt1);
                ProjectionPoint pt2 = displayProject.latLonToProj(llpt);
                if (showPts) {
                    System.out.println("getProjectedShape 2 " + xx[i] + " " + yy[i] + " === " + pt2.getX() + " " + pt2.getY());
                    if (displayProject.crossSeam(pt2, lastW)) {
                        System.out.println("***cross seam");
                    }
                }
                if (i == 0 || displayProject.crossSeam(pt2, lastW)) {
                    path.moveTo((float)pt2.getX(), (float)pt2.getY());
                } else {
                    path.lineTo((float)pt2.getX(), (float)pt2.getY());
                }
                lastW.setLocation(pt2);
            }
        }
        return path;
    }
}

