/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.FormatTools;
import loci.plugins.ImporterOptions;
import loci.plugins.Util;

public class Colorizer
implements PlugInFilter {
    private static ReflectedUniverse r = Colorizer.createReflectedUniverse();
    public boolean canceled;
    private String arg;
    private ImagePlus imp;
    private String stackOrder;
    private boolean merge;
    private boolean color;
    private boolean hyperstack;
    private int colorNdx;
    private String mergeOption;

    private static ReflectedUniverse createReflectedUniverse() {
        r = null;
        try {
            r = new ReflectedUniverse();
            r.exec("import ij.CompositeImage");
        }
        catch (ReflectException reflectException) {
            // empty catch block
        }
        return r;
    }

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.stackOrder = "XYCZT";
        if (this.arg == null || this.arg.trim().equals("")) {
            GenericDialog gd = new GenericDialog("Colorizing options...");
            gd.addCheckbox("Merge to RGB", false);
            gd.addCheckbox("Colorize", false);
            gd.addChoice("Stack order", new String[]{"XYCZT", "XYCTZ", "XYZCT", "XYZTC", "XYTCZ", "XYTZC"}, "XYCZT");
            gd.addCheckbox("Open as HyperStack", false);
            gd.showDialog();
            if (gd.wasCanceled()) {
                this.canceled = true;
                return;
            }
            this.merge = gd.getNextBoolean();
            this.color = gd.getNextBoolean();
            this.stackOrder = gd.getNextChoice();
            this.hyperstack = gd.getNextBoolean();
            if (this.color) {
                gd = new GenericDialog("Choose color...");
                gd.addChoice("Color", new String[]{"Red", "Green", "Blue"}, "Red");
                gd.showDialog();
                this.colorNdx = gd.getNextChoiceIndex();
            }
        } else {
            this.stackOrder = Macro.getValue((String)this.arg, (String)"stack_order", (String)"XYCZT");
            this.merge = Boolean.valueOf(Macro.getValue((String)this.arg, (String)"merge", (String)"true"));
            this.color = Boolean.valueOf(Macro.getValue((String)this.arg, (String)"colorize", (String)"false"));
            this.colorNdx = Integer.parseInt(Macro.getValue((String)this.arg, (String)"ndx", (String)"0"));
            this.mergeOption = Macro.getValue((String)this.arg, (String)"merge_option", null);
            this.hyperstack = Boolean.valueOf(Macro.getValue((String)this.arg, (String)"hyper_stack", (String)"false"));
        }
        ImageStack stack = this.imp.getImageStack();
        if (stack.isVirtual()) {
            IJ.error((String)"Colorizer plugin cannot be used with virtual stacks.\nPlease convert the virtual stack using Image>Duplicate.");
            return;
        }
        Calibration calibration = this.imp.getCalibration();
        int nChannels = this.imp.getNChannels();
        int nTimes = this.imp.getNFrames();
        int nSlices = this.imp.getNSlices();
        Class<?> c = null;
        try {
            c = Class.forName("ij.CompositeImage");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (this.imp.getClass().equals(c) || stack.isRGB() || nChannels == 1 && !this.color) {
            return;
        }
        ImagePlus newImp = new ImagePlus();
        boolean closeOriginal = true;
        if (this.color) {
            if (Util.checkVersion("1.39l", "ImageJ 1.39l or later is required to merge >8 bit or >3 channel data") && nChannels > 1) {
                try {
                    r.setVar("imp", Util.reorder(this.imp, this.stackOrder, "XYCZT"));
                    newImp = (ImagePlus)r.exec("new CompositeImage(imp, CompositeImage.COLOR)");
                }
                catch (ReflectException exc) {
                    ByteArrayOutputStream s = new ByteArrayOutputStream();
                    exc.printStackTrace(new PrintStream(s));
                    IJ.error((String)s.toString());
                }
            } else {
                ImageStack newStack = new ImageStack(stack.getWidth(), stack.getHeight());
                for (int i = 1; i <= stack.getSize(); ++i) {
                    newStack.addSlice(stack.getSliceLabel(i), stack.getProcessor(i));
                }
                byte[] lut = new byte[256];
                byte[] blank = new byte[256];
                Arrays.fill(blank, (byte)0);
                for (int i = 0; i < lut.length; ++i) {
                    lut[i] = (byte)i;
                }
                IndexColorModel model = new IndexColorModel(8, 256, this.colorNdx == 0 ? lut : blank, this.colorNdx == 1 ? lut : blank, this.colorNdx == 2 ? lut : blank);
                newStack.setColorModel((ColorModel)model);
                newImp.setStack(this.imp.getTitle(), newStack);
            }
        } else {
            int type = this.imp.getType();
            if (nChannels < 4 && type == 0) {
                newImp = this.makeRGB(newImp, stack, nChannels);
            } else if (nChannels <= 7 && type != 3) {
                if (Util.checkVersion("1.39l", "ImageJ 1.39l or later is required to merge >8 bit or >3 channel data")) {
                    try {
                        r.setVar("imp", Util.reorder(this.imp, this.stackOrder, "XYCZT"));
                        newImp = (ImagePlus)r.exec("new CompositeImage(imp, CompositeImage.COMPOSITE)");
                    }
                    catch (ReflectException exc) {
                        ByteArrayOutputStream s = new ByteArrayOutputStream();
                        exc.printStackTrace(new PrintStream(s));
                        IJ.error((String)s.toString());
                    }
                } else {
                    closeOriginal = false;
                    newImp = null;
                }
            } else if (nChannels > 7) {
                boolean spectral;
                int planes3;
                int planes2;
                int planes1 = stack.getSize() / 2;
                if (planes1 * 2 < stack.getSize()) {
                    ++planes1;
                }
                if ((planes2 = stack.getSize() / 3) * 3 < stack.getSize()) {
                    ++planes2;
                }
                if ((planes3 = stack.getSize() / 4) * 4 < stack.getSize()) {
                    ++planes3;
                }
                int[] num = new int[6];
                for (int i = 0; i < num.length; ++i) {
                    num[i] = stack.getSize() / (i + 2);
                    if (num[i] * (i + 2) >= stack.getSize()) continue;
                    int n = i;
                    num[n] = num[n] + 1;
                }
                ImporterOptions options = new ImporterOptions();
                boolean bl = spectral = stack.getSliceLabel(1).indexOf("Spectra") != -1;
                if (this.mergeOption == null) {
                    int status = options.promptMergeOption(num, spectral);
                    if (status == 0) {
                        this.mergeOption = options.getMergeOption();
                    }
                    while (this.mergeOption.equals("Spectral projection")) {
                        IJ.error((String)"Spectral projection has not been implemented.");
                        status = options.promptMergeOption(num, spectral);
                        if (status != 0) continue;
                        this.mergeOption = options.getMergeOption();
                    }
                }
                try {
                    if (this.mergeOption != null) {
                        int ndx = this.mergeOption.indexOf("channels");
                        if (ndx != -1) {
                            int n = Integer.parseInt(this.mergeOption.substring(ndx - 2, ndx - 1));
                            if (stack.getSize() % n != 0) {
                                int toAdd = n - stack.getSize() % n;
                                ImageProcessor blank = stack.getProcessor(stack.getSize()).duplicate();
                                blank.setValue(0.0);
                                blank.fill();
                                for (int i = 0; i < toAdd; ++i) {
                                    stack.addSlice("", blank);
                                }
                                this.imp.setStack(this.imp.getTitle(), stack);
                            }
                            if (this.imp.getType() == 0 && n < 4) {
                                newImp = this.makeRGB(newImp, stack, n);
                            } else if (Util.checkVersion("1.39l", "ImageJ 1.39l or later is required to merge >8 bit or >3 channel data")) {
                                this.imp.setDimensions(n, this.imp.getNSlices() * num[n - 2], this.imp.getNFrames());
                                r.setVar("imp", Util.reorder(this.imp, this.stackOrder, "XYCZT"));
                                r.exec("mode = CompositeImage.COMPOSITE");
                                r.exec("newImp = new CompositeImage(imp, mode)");
                                newImp = (ImagePlus)r.getVar("newImp");
                            } else {
                                closeOriginal = false;
                                newImp = null;
                            }
                        } else if (!this.mergeOption.equals("Spectral projection")) {
                            closeOriginal = false;
                        }
                    }
                }
                catch (ReflectException e) {
                    ByteArrayOutputStream s = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(s));
                    IJ.error((String)s.toString());
                }
            }
        }
        if (newImp != null) {
            newImp.setTitle(this.imp.getTitle());
            newImp.setProperty("Info", this.imp.getProperty("Info"));
            if (!newImp.getClass().equals(c)) {
                newImp.setDimensions(newImp.getStackSize() / (nSlices * nTimes), nSlices, nTimes);
            }
            newImp.setCalibration(calibration);
            newImp.setFileInfo(this.imp.getOriginalFileInfo());
            if (IJ.getVersion().compareTo("1.39l") >= 0 && !(newImp instanceof CompositeImage)) {
                newImp.setOpenAsHyperStack(this.hyperstack);
            }
            newImp.show();
        }
        if (closeOriginal) {
            this.imp.close();
        }
    }

    private ImagePlus makeRGB(ImagePlus ip, ImageStack s, int c) {
        int i;
        ImageStack newStack = new ImageStack(s.getWidth(), s.getHeight());
        int z = this.imp.getNSlices();
        int t = this.imp.getNFrames();
        t *= this.imp.getNChannels() / c;
        int[][] indices = new int[c][s.getSize() / c];
        ImageProcessor[][] processors = new ImageProcessor[s.getSize() / c][c];
        int[] pt = new int[c];
        Arrays.fill(pt, 0);
        for (i = 0; i < s.getSize(); ++i) {
            int[] zct = FormatTools.getZCTCoords(this.stackOrder, z, c, t, s.getSize(), i);
            indices[zct[1]][pt[zct[1]]] = i + 1;
            int n = zct[1];
            int n2 = pt[n];
            pt[n] = n2 + 1;
            processors[n2][zct[1]] = s.getProcessor(i + 1);
        }
        for (i = 0; i < indices[0].length; ++i) {
            newStack.addSlice(s.getSliceLabel(indices[indices.length - 1][i]), Util.makeRGB(processors[i]).getProcessor());
        }
        ip.setStack(ip.getTitle(), newStack);
        return ip;
    }
}

