uniform int channel;
uniform sampler3D volumeTexture;
uniform sampler2D RGBlookupTexture;
uniform sampler2D RAGABAlookupTexture;

void main()
{		
	float texValue = 0.0;
	vec3 RGBlookupValue = vec3(0.0);
	vec3 RAGABAlookupValue = vec3(0.0);
	vec4 finalColour = vec4(0.0);

	if(channel==0)
	{
		//get the texture rgb data
		texValue = texture3D(volumeTexture, gl_TexCoord[0].stp).x;

		//get lookup table values
		//r,g,b,ra,ga,ba
		RGBlookupValue.x = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).x;
		RAGABAlookupValue.x = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).x;

		if(RAGABAlookupValue.x == 0.0) discard;
		finalColour = vec4(RGBlookupValue.x, 0.0, 0.0, RAGABAlookupValue.x);
	}
	if(channel==1)
	{
		//get the texture rgb data
		texValue = texture3D(volumeTexture, gl_TexCoord[0].stp).x;

		//get lookup table values
		//r,g,b,ra,ga,ba
		RGBlookupValue.y = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).y;
		RAGABAlookupValue.y = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).y;
		
		if(RAGABAlookupValue.y == 0.0) discard;

		finalColour = vec4(0.0,RGBlookupValue.y,0.0, RAGABAlookupValue.y);
	}
	if(channel==2)
	{
		//get the texture rgb data
		texValue = texture3D(volumeTexture, gl_TexCoord[0].stp).x;

		//get lookup table values
		//r,g,b,ra,ga,ba
		RGBlookupValue.z = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).z;
		RAGABAlookupValue.z = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).z;

		if(RAGABAlookupValue.z == 0.0) discard;

		finalColour = vec4(0.0, 0.0, RGBlookupValue.z, RAGABAlookupValue.z);
	}
	if(channel==3)
	{		
		//get the texture rgb data
		texValue = texture3D(volumeTexture, gl_TexCoord[0].stp).x;

		//get lookup table values
		//r,g,b,ra,ga,ba
		RGBlookupValue.x = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).x;
		RAGABAlookupValue.x = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).x;

		if(RAGABAlookupValue.x == 0.0) discard;

		finalColour = vec4(RGBlookupValue.x,RGBlookupValue.x,RGBlookupValue.x, RAGABAlookupValue.x);
	}

	//assing the colour to our final colour
	gl_FragColor = finalColour;	
}