import omero.scripts as scripts
import omero.util.script_utils as scriptUtil
from omero.rtypes import *
import omero.gateway
import omero_api_Gateway_ice
import omero.util.imageUtil as imgUtil
import subprocess
from os import environ
import numpy

#-------------------------------------------------
#keep these global saves parsing them all the time	
#-------------------------------------------------
gateway = None
session = None
rawPixelStore = None
pixelsService = None
updateService = None
rawFileStore = None
queryService = None
volviewcmd = '/opt/VolViewer/VolViewer'

#-------------------------------------------------
#helper	function to log messages/debug
#-------------------------------------------------
logLines = []
def log(text):
	""" Adds lines of text to the logLines list"""
	print text
	logLines.append(text)
    
def doSomething(images, xang, yang, zang):
	
	log("---")
	for image in images:		
		
		log("SessionID: %s ImageID: %s" % (client.getSessionId(), image.getId().getValue())) 
			
		#-------------------------------------------------
		#call volviewer and render the image
		#-------------------------------------------------
		envarg = environ.copy()
		envarg["DISPLAY"] = ":0.0"
		#cmd = './VolViewer auto_close=1'
		cmd = volviewcmd + ' omero_server="localhost" omero_sessionid="' + str(client.getSessionId()) + '" omero_imageid=' + str(image.getId().getValue()) + ' set_view\('+str(xang)+','+str(yang)+','+str(zang)+'\) render=1 auto_hide=1 auto_close=1'
		run = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE, env=envarg)
		returncode = run.wait()
		stdout = run.stdout.readlines()
		stderr = run.stderr.readlines()		
		log("stdout: %s stderr: %s" % (stdout,stderr) )
				
		#-------------------------------------------------
		# uploads the file to the server, attaching it to the 'parent' Project/Dataset as an OriginalFile annotation,
		# with the figLegend as the description. Returns the id of the originalFileLink child. (ID object, not value)
		#-------------------------------------------------
		format = "image/png"
		output = "/opt/VolViewer/Render.png"
		fileAnnotation = scriptUtil.uploadAndAttachFile(queryService, updateService, rawFileStore, image, output, format, "Volume rendering.")

		#-------------------------------------------------
		#be clean and delete the *.png
		#-------------------------------------------------
		cmd = 'rm -f ./*.png'
		run = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE, env=envarg)
		returncode = run.wait()
		stdout = run.stdout.readlines()
		stderr = run.stderr.readlines()		
		log("stdout: %s stderr: %s" % (stdout,stderr) )

	log("---")

def parseCommandArguments(commandArgs):    
	log("---")

	parent = None
	imageIds = []
	datasetIds = []
	projectIds = []

	#-------------------------------------------------
	#parse IDs for projects, datasets, images 
	#-------------------------------------------------
	dataType = commandArgs["Data_Type"]
	log("dataType: %s" % dataType);

	zang = commandArgs["Z-angle"]
	yang = commandArgs["Y-angle"]
	xang = commandArgs["X-angle"]

	log("---");
	if dataType == "Image": 						#IMAGES
		for imageId in commandArgs["IDs"]:
			try:
				iId = long(imageId.getValue())
				imageIds.append(iId)
			except: pass
	elif dataType == "Dataset": 					#DATASETS
		for datasetId in commandArgs["IDs"]:
			try:
				dId = long(datasetId.getValue())
				datasetIds.append(dId)
			except: pass
	else: 											#PROJECTS
		for projectId in commandArgs["IDs"]:
			try:
				pId = long(projectId.getValue())
				projectIds.append(pId)
			except: pass
	log("---")
	
	#-------------------------------------------------
	#check actually we have something
	#-------------------------------------------------
	if len(imageIds) == 0 and len(datasetIds) == 0 and len(projectIds) == 0:
		print "No image IDs, dataset IDs found or proeject IDs found."       
	log("Found: %d projects, %d datasets, %d images" % (len(projectIds), len(datasetIds), len(imageIds)))
	
	#-------------------------------------------------
	#now retrieve all the imageIDs we wish to process
	#-------------------------------------------------
	
	#PROJECTS
	projects = []
	if len(projectIds) != 0:
		projects = gateway.getProjects(projectIds, False)

	for project in projects:
		if project == None:
			print "No project found for ID: %s" % projectId
			continue
		projectName = project.getName().getValue()
		images = gateway.getImages(omero.api.ContainerClass.Project, [project.getId().getValue()])
		log("Project: %s     ID: %d     Images: %d" % (projectName, project.getId().getValue(), len(images)))
		#-------------------------------------------------
		doSomething(images, xang, yang, zang)
		
	#DATASETS
	for datasetId in datasetIds:
		dataset = gateway.getDataset(datasetId, False)
		if dataset == None: 
			print "No dataset found for ID: %s" % datasetId
			continue
		datasetName = dataset.getName().getValue()
		images = gateway.getImages(omero.api.ContainerClass.Dataset, [datasetId])
		log("Dataset: %s     ID: %d     Images: %d" % (datasetName, datasetId, len(images)))
		#-------------------------------------------------
		doSomething(images, xang, yang, zang)

	#IMAGES
	if len(datasetIds) == 0:
		images = []
		for imageId in imageIds:
			images.append(gateway.getImage(imageId))
		#-------------------------------------------------
		doSomething(images, xang, yang, zang)
	
if __name__ == '__main__':
	dataTypes = [rstring('Project'),rstring('Dataset'),rstring('Image')]

	client = scripts.client('Volume_Render', """Volume renders all image(s) selected, in a dataset or in a project""",
	
	scripts.String("Data_Type", optional=False, grouping="1",
		description="The data you want to work with.", values=dataTypes, default="Image"),
	
	scripts.List("IDs", optional=False, grouping="2",
		description="List of Project IDs, Dataset IDs or Image IDs").ofType(rlong(0)),
	
	scripts.Float("X-angle", optional=False, grouping="3",
		description="The X viewing angle", default=0.0),	
	scripts.Float("Y-angle", optional=False, grouping="4",
		description="The Y viewing angle", default=0.0),	
	scripts.Float("Z-angle", optional=False, grouping="5",
		description="The Z viewing angle", default=0.0),	

	version = "4.2.1",
	authors = ["Jerome Avondo", "JIC"],
	institutions = ["John Innes Centre"],
	contact = "jerome.avondo@bbsrc.ac.uk",
	)

	try:
	
		session = client.getSession()
	
		gateway = session.createGateway()
		rawPixelStore= session.createRawPixelsStore()
		pixelsService= session.getPixelsService()
		queryService = session.getQueryService()
		updateService = session.getUpdateService()
		rawFileStore = session.createRawFileStore()
		
		commandArgs = {}
		
		for key in client.getInputKeys():
			if client.getInput(key):
				commandArgs[key] = client.getInput(key).getValue()
		
		log("---");
		log("commands: %s" % commandArgs)
		
		parseCommandArguments(commandArgs)
		
		client.setOutput("Message", rstring("Script was successfull"))
		
	finally:	
		client.closeSession()
