
uniform sampler3D volumeTexture;
uniform sampler3D volumeTexture2;
uniform sampler2D RGBlookupTexture;
uniform sampler2D RAGABAlookupTexture;

uniform int channel;

uniform vec3 gooch_warmCol;
uniform vec3 gooch_coolCol;
uniform float silhCont;
uniform float silhExp;
uniform float degenthresh;
uniform float alphathresh;
	
varying vec3 V;
varying vec3 V1;
varying vec3 L;

vec3 eval_normal(void)
{
	vec3 normal;
	//==============================================
	//EVALUATE OUR NORMAL BY CENTRAL DIFFERENCE
	//==============================================
	float stepsize	= 1.0/512.0;
	vec3 sample1,sample2,sample3,sample4;
	sample1.x = texture3D(volumeTexture, gl_TexCoord[0].stp-vec3(stepsize,0,0)).x;
	sample2.x = texture3D(volumeTexture, gl_TexCoord[0].stp+vec3(stepsize,0,0)).x;
	sample1.y = texture3D(volumeTexture, gl_TexCoord[0].stp-vec3(0,stepsize,0)).x;
	sample2.y = texture3D(volumeTexture, gl_TexCoord[0].stp+vec3(0,stepsize,0)).x;
	sample1.z = texture3D(volumeTexture, gl_TexCoord[0].stp-vec3(0,0,stepsize)).x;
	sample2.z = texture3D(volumeTexture, gl_TexCoord[0].stp+vec3(0,0,stepsize)).x;

	normal = sample2-sample1;
	return normal;
}

//GOOCH LIGHTING
vec3 shading_func(vec3 N, vec3 V, vec3 L)
{
	vec3 colour; 
		
	//Calculate the correct color according to the Gooch shading model.
	//toneLight ranges from -1 to 1
	float dotLight = dot(vec3(N),L);
	
	vec3 warm = vec3(gooch_warmCol[0], gooch_warmCol[1], gooch_warmCol[2]);
	vec3 cool = vec3(gooch_coolCol[0], gooch_coolCol[1], gooch_coolCol[2]);

	colour.rgb = (((1.0+dotLight)*0.25)*warm + (1.0-((1.0+dotLight)*0.5))*cool);
	return colour;
}

void main()
{	
	//get the texture rgb data
	float texValue = texture3D(volumeTexture, gl_TexCoord[0].stp).x;
	//if(texValue==0.0) discard;

	//==============================
	//APLY OUR TRANSFER FUNCTION
	//==============================
	//make sure we sample from centre of lookup table
	//float lookup_offset = (1.0/256.0/2.0);
	//texValue += lookup_offset;

	//get lookup table values
	//r,g,b,ra,ga,ba
	vec3 RGBlookupValue, RAGABAlookupValue;
	RGBlookupValue = RAGABAlookupValue = vec3(0.0);
	vec4 finalColour = vec4(0.0);

	if(channel==0)
	{
		RGBlookupValue.x = texture2D(RGBlookupTexture, vec2(texValue, 0.0)).x;
		RAGABAlookupValue.x = texture2D(RAGABAlookupTexture, vec2(texValue, 0.0)).x;
		finalColour = vec4(RGBlookupValue.x,0.0,0.0, RAGABAlookupValue.x);
	}
	else if(channel==1)
	{
		RGBlookupValue.y = texture2D(RGBlookupTexture, vec2(texValue, 0.0)).y;
		RAGABAlookupValue.y = texture2D(RAGABAlookupTexture, vec2(texValue, 0.0)).y;
		finalColour = vec4(0.0,RGBlookupValue.y,0.0, RAGABAlookupValue.y);
	}
	else if(channel==2)
	{
		RGBlookupValue.z = texture2D(RGBlookupTexture, vec2(texValue, 0.0)).z;
		RAGABAlookupValue.z = texture2D(RAGABAlookupTexture, vec2(texValue, 0.0)).z;		
		finalColour = vec4(0.0,0.0,RGBlookupValue.z, RAGABAlookupValue.z);
	}
	else if(channel==3)
	{
		RGBlookupValue.x = texture2D(RGBlookupTexture, vec2(texValue, 0.0)).x;
		RAGABAlookupValue.x = texture2D(RAGABAlookupTexture, vec2(texValue, 0.0)).x;
		finalColour = vec4(RGBlookupValue.x,RGBlookupValue.x,RGBlookupValue.x, RAGABAlookupValue.x);
	}
	else if(channel==4)
	{
		float texValue2 = texture3D(volumeTexture2, gl_TexCoord[0].stp).x;
		
		RGBlookupValue.x = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).x;
		RAGABAlookupValue.x = texture2D(RAGABAlookupTexture, vec2(texValue2, 0.5)).x;
		finalColour = vec4(RGBlookupValue.x,RGBlookupValue.x,RGBlookupValue.x, RAGABAlookupValue.x);	
	}
	
	vec3 N = eval_normal();
	vec3 shading;

	bool degenerate = false;
	float length = sqrt(N.x*N.x+N.y*N.y+N.z*N.z);//length(N);
	if(length<degenthresh) degenerate = true;

	//We have to scale the gradient between 0 and 1
	N = normalize(N);

	//L = normalize(V1 - (gl_TextureMatrix[0]*gl_LightSource[0].position).xyz);	//gl_LightSource[0].position.xyz - V
	shading = shading_func(N,V1,L);
	finalColour += vec4(shading,0.0);

	//========
	//silhouettes
	//========
	//If we want to enhance silhoutte edges, we can make sure the gradient
	//is not degenerate and change the opacity based on the voxel's
	//perpendicularity relative to the viewer.		
	float dotView = dot(N, (gl_TextureMatrix[0]*vec4(0,0,-1,0)).xyz);
	
	vec4 silhouette = vec4(0.0);

	if(!degenerate)
	{
		silhouette =  vec4(silhCont*pow(1.0-abs(dotView),silhExp));
		finalColour.xyz -= silhouette.xyz;
		if(silhouette.w>alphathresh) finalColour.w = 1.0;
	}

	//assing the colour to our final colour
	gl_FragColor = finalColour;
}
