
uniform int channel;
uniform sampler3D volumeTexture;
uniform sampler2D RGBlookupTexture;
uniform sampler2D RAGABAlookupTexture;
varying vec3 V;
varying vec3 V1;


vec3 eval_normal(void)
{
	vec3 normal;
	//==============================================
	//EVALUATE OUR NORMAL BY CENTRAL DIFFERENCE
	//==============================================
	float stepsize	= 1.0/256.0;
	vec3 sample1,sample2,sample3,sample4;
	sample1.x = texture3D(volumeTexture, gl_TexCoord[0].stp-vec3(stepsize,0,0)).x;
	sample2.x = texture3D(volumeTexture, gl_TexCoord[0].stp+vec3(stepsize,0,0)).x;
	sample1.y = texture3D(volumeTexture, gl_TexCoord[0].stp-vec3(0,stepsize,0)).x;
	sample2.y = texture3D(volumeTexture, gl_TexCoord[0].stp+vec3(0,stepsize,0)).x;
	sample1.z = texture3D(volumeTexture, gl_TexCoord[0].stp-vec3(0,0,stepsize)).x;
	sample2.z = texture3D(volumeTexture, gl_TexCoord[0].stp+vec3(0,0,stepsize)).x;

	normal = sample2-sample1;
//	normal.rgb = normal.rgb*2.0 - 1.0;
//	normal = normalize(normal);

	return normal;
}
 
//BLING-PHONG LIGHTING MODEL
vec3 shading_func(vec3 N, vec3 VV, vec3 L)
{
	vec3 Ka = gl_LightSource[0].ambient.xyz; //vec3(0.1, 0.1, 0.1);
	vec3 Kd = gl_LightSource[0].diffuse.xyz; //vec3(0.6, 0.6, 0.6);
	vec3 Ks = gl_LightSource[0].specular.xyz; //vec3(0.2, 0.2, 0.2);
	float n = 16.0;

	vec3 H = normalize(L+VV);

	vec3 ambient = Ka ;

	float diffuseLight = max(dot(L,N),0.0);
	vec3 diffuse = Kd * diffuseLight;

	float specularLight = pow(max(dot(H,N),0.0), n);
	if(diffuseLight<=0.0) specularLight = 0.0;
	vec3 specular = Ks * specularLight;

	return ambient+diffuse+specular;
}
vec3 getNormal(vec3 v1, vec3 v2, vec3 v3)
{
	vec3 N, n0, n1;
	
	n0 = v1 - v2;
	n1 = v2 - v3;
	
	N = cross(n0, n1);
	N = normalize(N);
		
	return N;
}

void main()
{	
	vec3 texcoord = gl_TexCoord[0].stp; //+ texture2D(noiseTexture, dir*V/32);

	//get the texture rgb data
	float texValue;
	texValue = texture3D(volumeTexture, texcoord).x;

	//==============================
	//APLY OUR TRANSFER FUNCTION
	//==============================
	//make sure we sample from centre of lookup table
	float lookup_offset = (1.0/256.0/2.0);
	texValue += lookup_offset;

	//get lookup table values
	//r,g,b,ra,ga,ba
	vec3 RGBlookupValue, RAGABAlookupValue;
	RGBlookupValue = RAGABAlookupValue = vec3(0.0);
	vec4 finalColour;
	finalColour = vec4(0.0, 0.0, 0.0, 0.0);

	if(channel==0)
	{
		RGBlookupValue.x = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).x;
		RAGABAlookupValue.x = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).x;
		finalColour = vec4(RGBlookupValue.x,0.0,0.0, RAGABAlookupValue.x);
	}
	else if(channel==1)
	{
		RGBlookupValue.y = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).y;
		RAGABAlookupValue.y = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).y;
		finalColour = vec4(0.0,RGBlookupValue.y,0.0, RAGABAlookupValue.y);
	}
	else if(channel==2)
	{
		RGBlookupValue.z = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).z;
		RAGABAlookupValue.z = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).z;
		finalColour = vec4(0.0,0.0,RGBlookupValue.z, RAGABAlookupValue.z);
	}
	else if(channel==3)
	{
		RGBlookupValue.x = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).x;
		RAGABAlookupValue.x = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).x;
		finalColour = vec4(RGBlookupValue.x,RGBlookupValue.x,RGBlookupValue.x, RAGABAlookupValue.x);
	}
	
	vec3 L = normalize(V1 - (gl_TextureMatrix[0]*gl_LightSource[0].position).xyz);	//gl_LightSource[0].position.xyz - V
	
	//===========================
	//toon
	//===========================
	//...create a set of 4 colors that go from bright
	//to the specified toon color
	vec3 toonCol = vec3(0.0);
	if(channel==0) toonCol = vec3(1.0,0.0,0.0);
	if(channel==1) toonCol = vec3(0.0,1.0,0.0);
	if(channel==2) toonCol = vec3(0.0,0.0,1.0);
	if(channel==3) toonCol = vec3(1.0,0.0,0.0);

	vec3 col = toonCol - vec3(1.0, 1.0, 1.0);
	vec4 color1 = vec4(toonCol - 0.75*col, finalColour.a);
	vec4 color2 = vec4(toonCol - 0.50*col, finalColour.a);
	vec4 color3 = vec4(toonCol - 0.25*col, finalColour.a);
	vec4 color4 = vec4(toonCol, finalColour.a);
	
	vec3 N = eval_normal();
	float dotLight = dot(normalize(N), L);
	dotLight =  clamp(dotLight, 0.0, 1.0);,
	//and then assign different ranges of the diffuse
	//coefficient to one of the 4 colors
	if (dotLight > 0.95)
		finalColour += color1;
	else if (dotLight > 0.75)
		finalColour += color2;
	else if (dotLight > 0.5)
		finalColour += color3;
	else
		finalColour += color4;	

	//===========================
	//Silhouettes
	//===========================
	/*bool degenerate = false;
	float length = sqrt(N.x*N.x+N.y*N.y+N.z*N.z);//length(N);
	if(length<0.25) degenerate = true;

	if(degenerate==false)
	{
		float dotView = dot(N, (gl_TextureMatrix[0]*vec4(0,0,1,0)).xyz);	
		vec4 silhouette = vec4(0.0);

		silhouette =  vec4(2.0*pow(1.0-abs(dotView),8.0));
		finalColour.xyz -= silhouette.xyz;
		finalColour.xyz = clamp(finalColour.xyz, 0.0, 1.0); 
		//if(silhouette.w>0.9) finalColour.w -= finalColour.w;
	}*/
	
	//assing the colour to our final colour
	gl_FragColor = finalColour;	
}
