//
//	Copyright (c)2004 GE Medical Systems
//
//	Helper comment to enable syntax coloring in InterDev: <script>

var _wlpresetlist	= null;
var _wndPopup		= window.createPopup();

//
// onload
//
function window.onload()
{
	SetButtonChecked(btnShowViewportAnnot, parent.GetShowAnnotations());
		
	OnCineSpeedChange();

	var settings = GetISettings();
	if (settings == null)
		return;

	Feed2PresentationStateListbox(GetApp().GetLocaleString('strEmptyPresentationState'), 0);

	_wlpresetlist = new WLPresetListControl(listWindowPreset);
	_wlpresetlist.Initialize(GetApp().GetConfig().GetWindowLevelPresetNode());
}

//
// onresize
//
function window.onresize()
{
	parent.frmsetViewing.rows = (document.body.scrollHeight + 2).toString() + ', *';
}

//
// OnViewportLayoutChange
//
function OnViewportLayoutChange(value)
{
	_wndPopup.hide();
	var nRows = parseInt(value.substr(0,1));
	var nColumns = parseInt(value.substr(2,1));
	parent.SetViewportLayout(nRows, nColumns);
}

//
// OnSeriesLayoutChange
//
function OnSeriesLayoutChange(value)
{
	_wndPopup.hide();
	var nRows = parseInt(value.substr(0,1));
	var nColumns = parseInt(value.substr(2,1));
	parent.SetSeriesLayout(nRows, nColumns);
}

//
// HasErrors
//
function HasErrors()
{
	return false;
}


//
// GetErrorText
//
function GetErrorText()
{
	return '';
}


//
// OnButtonBrowseClick
//
function OnButtonBrowseClick()
{
	parent.BrowseForFile();
}


//
// OnPageBack
//
function OnPageBack(keyevent)
{
	parent.PageBack(keyevent);
}


//
// OnPageForward
//
function OnPageForward(keyevent)
{
	parent.PageForward(keyevent);
}

//
// OnImageBack
//
function OnImageBack()
{
	parent.ImageBack();
}


//
// OnImageForward
//
function OnImageForward()
{
	parent.ImageForward();
}


//
// OnSeriesBack
//
function OnSeriesBack()
{
	parent.SeriesBack();
}


//
// OnSeriesForward
//
function OnSeriesForward()
{
	parent.SeriesForward();
}


//
// OnCineSpeedDown
//
function OnCineSpeedDown()
{
	parent.CineSpeedDecrease();
}


//
// OnCineSpeedUp
//
function OnCineSpeedUp()
{
	parent.CineSpeedIncrease();
}


//
// OnCinePlayPause
//
function OnCinePlayPause()
{
	parent.OnCinePlayPause();
}


//
// OnCineStop
//
function OnCineStop()
{
	parent.OnCineStop();
}


//
// OnButtonPropagateClick
//
function OnButtonPropagateClick()
{
	parent.OnPropagateClicked();
}


//
// OnButtonShowViewportAnnotClick
//
function OnButtonShowViewportAnnotClick()
{
	SetButtonChecked(btnShowViewportAnnot, !IsButtonChecked(btnShowViewportAnnot))
	parent.SetShowAnnotations(IsButtonChecked(btnShowViewportAnnot));
}


//
// OnButtonPetCtModeClick()
//
function OnButtonPetCtModeClick()
{
	SetButtonChecked(btnPetCtMode, !IsButtonChecked(btnPetCtMode));
	parent.SetViewMode(IsButtonChecked(btnPetCtMode) ? VIEWMODE_PETCT : VIEWMODE_DEFAULT);
}


//
// OnButtonReportClick
//
function OnButtonReportClick()
{
	SetButtonChecked(btnShowReport, !IsButtonChecked(btnShowReport))
	IsButtonChecked(btnShowReport) ? parent.ShowReportFrame() : parent.HideReportFrame();
}


//
// SetButtonState
//
function SetButtonState(btn, bDisable, bCheck)
{
	if (bCheck == null)
	{
		bCheck = IsButtonChecked(btn);
	}
	
	btn.disabled		= bDisable;
	var strClassName	= bDisable == true ? 'disabled' : 'enabled';
	btn.className		= bCheck ? strClassName + ' selected' : strClassName;
}


//
// SetButtonChecked
//
function SetButtonChecked(btn, bCheck)
{
	SetButtonState(btn, btn.disabled, bCheck);
}


//
// IsButtonChecked()
//
function IsButtonChecked(btn)
{
	return btn.className.indexOf('selected') >= 0;
}


//
// NotifyPlayMode
//
// Purpose: Handle the 'play mode' event by disabling/enabling buttons
//          that can/cannot be used in play/stop mode.
//
function NotifyPlayMode(bPlaying)
{
	SetButtonState(btnPetCtMode,	bPlaying || !parent._dicomdirframe.IsPetCtStudy());
	SetButtonState(btnPrevImage,	bPlaying);
	SetButtonState(btnNextImage,	bPlaying);
	SetButtonState(btnPrevSeries,	bPlaying);
	SetButtonState(btnNextSeries,	bPlaying);
	SetButtonState(btnPropagate,	bPlaying);
	SetButtonState(btnCineStop,		!bPlaying);

	// Change the image on the button to indicate the play state.
	if (bPlaying)
	{
		divCinePlayPauseImage.className = 'classCinePauseImage';
	}
	else
	{
		divCinePlayPauseImage.className = 'classCinePlayImage';
	}
}


//
// OnCineSpeedChange
//
function OnCineSpeedChange(nCineSpeedMin, nCineSpeed, nCineSpeedMax)
{
	if (nCineSpeed == nCineSpeedMin)
	{
		SetButtonState(btnCineSpeedDown, true);
	}
	else if (nCineSpeed == nCineSpeedMax)
	{
		SetButtonState(btnCineSpeedUp, true);
	}
	else
	{
		SetButtonState(btnCineSpeedDown, false);
		SetButtonState(btnCineSpeedUp, false);
	}
	spanSpeedValue.innerText = nCineSpeed;
}


//
// UpdateControls
//
function UpdateControls(dicomdirframe, bIsPetCtMode)
{
	var bCineRunning = parent.IsCineRunning();

	SetButtonState(btnPetCtMode, bCineRunning || !dicomdirframe.IsPetCtStudy());

	var bSingleImage	= dicomdirframe.GetActiveSeriesIndex() == -1;
	var bImageSelected	= dicomdirframe.IsImageSelected();

	if (bImageSelected)
	{
		var bHasPrevImages	= dicomdirframe.HasPreviousImageInSeries();
		var bHasNextImages	= dicomdirframe.HasNextImageInSeries();
		var bMultiFrame		= parent.IsSelectedImageMultiFrame();

		if (bIsPetCtMode)
		{
			SetButtonState(btnPrevImage,		!bHasPrevImages);
			SetButtonState(btnNextImage,		!bHasNextImages);
			SetButtonState(btnPrevPage,			!bHasPrevImages || bMultiFrame);
			SetButtonState(btnNextPage,			!bHasNextImages || bMultiFrame);
			SetButtonState(btnCinePlayPause,	!dicomdirframe.HasMIPSeries());
			SetButtonState(btnCineStop,			!bCineRunning);
		}
		else
		{	
			if (bMultiFrame)
			{
				SetButtonState(btnPrevImage,		false);
				SetButtonState(btnNextImage,		false);
				SetButtonState(btnPrevPage,			true);
				SetButtonState(btnNextPage,			true);
				SetButtonState(btnCinePlayPause,	false);
				SetButtonState(btnCineStop,			!bCineRunning);
			}
			else
			{
				var bMultipleViewports = parent.viewlayout.GetViewportLayout() != '1x1';
				
				SetButtonState(btnPrevImage,		!bHasPrevImages);
				SetButtonState(btnNextImage,		!bHasNextImages);
				SetButtonState(btnPrevPage,			!(bHasPrevImages && bMultipleViewports));
				SetButtonState(btnNextPage,			!(bHasNextImages && bMultipleViewports));
				SetButtonState(btnCinePlayPause,	!(bHasPrevImages || bHasNextImages));
				SetButtonState(btnCineStop,			!bCineRunning);
			}
		}
		
		SetButtonState(btnNextSeries,		bIsPetCtMode || !dicomdirframe.HasNextSeries());
		SetButtonState(btnPrevSeries,		bIsPetCtMode || !dicomdirframe.HasPreviousSeries());
		SetButtonState(btnPropagate,		bSingleImage);
		SetButtonState(btnViewportLayout,	bIsPetCtMode || bSingleImage);
		SetButtonState(btnSeriesLayout,		bIsPetCtMode || bSingleImage);
	}
	else
	{
		// No image is selected: disable all image control buttons.
		SetButtonState(btnPrevImage,		true);
		SetButtonState(btnNextImage,		true);
		SetButtonState(btnPrevPage,			true);
		SetButtonState(btnNextPage,			true);
		SetButtonState(btnNextSeries,		true);
		SetButtonState(btnPrevSeries,		true);
		SetButtonState(btnCinePlayPause,	true);
		SetButtonState(btnCineStop,			true);
		SetButtonState(btnPropagate,		true);
		SetButtonState(btnViewportLayout,	true);
		SetButtonState(btnSeriesLayout,		true);
	}
	
	listPresentationStates.disabled = !bImageSelected || bSingleImage;
	
	var series		= parent.viewlayout.GetActiveSeries();
	var viewport	= series != null ? series.GetActiveViewport() : null;
	
	_wlpresetlist.Update(bIsPetCtMode, dicomdirframe, viewport);
}


//
// Feed2PresentationStateListbox
//
function Feed2PresentationStateListbox(str, val)
{
	var oOption		= document.createElement("OPTION");
	oOption.text	= str;
	oOption.value	= new String(val);
	
	listPresentationStates.options.add(oOption);
}


//
// ClearPresentationStateListbox
function ClearPresentationStateListbox()
{
	var cpr = listPresentationStates.options.length;
	for (var ipr = 0; ipr < cpr; ipr++)
	{
		listPresentationStates.options.remove(0);
	}
}


//
// OnPresentationStateChange
//
function OnPresentationStateChange(value)
{
	parent.OnPresentationStateChange(value);
}


//
// SelectPresentationState
//
function SelectPresentationState(cnt)
{
	listPresentationStates.selectedIndex = cnt;
}


//
// OnSeriesLayout
//
function OnSeriesLayout()
{
    _wndPopup.document.createStyleSheet('popup.css');
	_wndPopup.document.body.innerHTML = divSerieslayoutPopup.innerHTML; 
	_wndPopup.show(2, btnSeriesLayout.offsetHeight, 130, 45, btnSeriesLayout);
}


//
// OnViewportLayout
//
function OnViewportLayout()
{
    _wndPopup.document.createStyleSheet('popup.css');
	_wndPopup.document.body.innerHTML = divViewportLayoutPopup.innerHTML; 
	_wndPopup.show(2, btnViewportLayout.offsetHeight, 172, 130, btnViewportLayout);
}


//
// OnAboutClick
//
function OnAboutClick()
{
	parent.ShowAboutDialog();
}
