
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:sr="http://www.applicare.com/sr.xsd"
	version="1.0">

	<xsl:output method="html" encoding="UTF-8" indent="yes"/>

	<xsl:template match="/">
		<xsl:apply-templates select="//report"/>
	</xsl:template>

	<xsl:template match="report">
			<div style="text-align:center; position: relative;"><xsl:value-of select="//sr:ContentDate"/> - <xsl:value-of select="//sr:ContentTime"/></div>
			<xsl:apply-templates select="sr:Document"/>
	</xsl:template>

	<xsl:template match="sr:Document">
		<xsl:apply-templates select="sr:CONTAINER_ROOT"/>
	</xsl:template>

	<xsl:template match="sr:CONTAINER_ROOT">
		<h2 style="width:100%;"><xsl:value-of select="sr:ConceptNameCodeSequence/sr:ContextCode/@CodeMeaning"/></h2>
		<xsl:apply-templates select="sr:ContentSequence"/>
	</xsl:template>

	<xsl:template match="sr:CONTAINER">
		<h3><xsl:value-of select="sr:ConceptNameCodeSequence/sr:ContextCode/@CodeMeaning"/></h3>			
		<xsl:apply-templates select="sr:ContentSequence"/>
	</xsl:template>

	<xsl:template match="sr:ContentSequence">
		<div  style="width:100%; position:relative; margin-left: 20px;"><xsl:apply-templates /></div>
	</xsl:template>

	<xsl:template match="sr:TEXT|sr:DATE|sr:PNAME|sr:NUM|sr:CODE|sr:UIDREF|sr:IMAGE|sr:COMPOSITE">
		<div style="position:relative; height:1px;">
			<span style="float:left; position:relative; width:15%;"><xsl:value-of select="sr:ConceptNameCodeSequence/sr:ContextCode/@CodeMeaning"/> :</span>
			<span style="position:relative; width:100%;"><xsl:apply-templates select="sr:TextValue|sr:DateValue|sr:PersonName|sr:MeasuredValueSequence|sr:ConceptCodeSequence|sr:UID|sr:ReferencedImageSequence|sr:ReferencedSOPSequence"/></span>
		</div>
		<xsl:apply-templates select="sr:ContentSequence"/>
	</xsl:template>

	<xsl:template match="sr:TextValue">
		<pre style="word-wrap:break-word;margin-right:20px;"><xsl:value-of select="."/></pre>
	</xsl:template>

	<xsl:template match="sr:DateValue|sr:PersonName">
		<xsl:value-of select="."/>
	</xsl:template>

	<xsl:template match="sr:MeasuredValueSequence">
		<xsl:value-of select="sr:NumericValue"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="sr:MeasurementUnitSequence/sr:ContextCode/@CodeMeaning"/>
	</xsl:template>

	<xsl:template match="sr:ConceptCodeSequence">
		<xsl:value-of select="sr:ContextCode/@CodeValue"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="sr:ContextCode/@CodeMeaning"/>
	</xsl:template>

	<xsl:template match="sr:UID">
		<xsl:element name="a">
			<xsl:attribute name="href">javascript:NotifyClick("frameref:" + "<xsl:value-of select="."/>")</xsl:attribute>
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="sr:ReferencedImageSequence">
		<xsl:if test="./sr:ReferencedImage/sr:ReferencedSOPInstanceUID[. != '']">
			<xsl:choose >
				<xsl:when test="./sr:ReferencedImage/sr:ReferencedFrameNumber[. != '']">
					<xsl:element name="a">
						<xsl:attribute name="href">javascript:NotifyClick("frameref:" + "<xsl:value-of select="./sr:ReferencedImage/sr:ReferencedSOPInstanceUID"/>" + ":" + 
							"<xsl:value-of select="./sr:ReferencedImage/sr:ReferencedFrameNumber"/>")</xsl:attribute>
						<xsl:value-of select="./sr:ReferencedImage/sr:ReferencedSOPInstanceUID"/>: 
						<xsl:value-of select="./sr:ReferencedImage/sr:ReferencedFrameNumber"/>
					</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:element name="a">
						<xsl:attribute name="href">javascript:NotifyClick("frameref:" + "<xsl:value-of select="./sr:ReferencedImage/sr:ReferencedSOPInstanceUID"/>")</xsl:attribute>
						<xsl:value-of select="./sr:ReferencedImage/sr:ReferencedSOPInstanceUID"/>
					</xsl:element>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template match="sr:ReferencedSOPSequence">
		<xsl:element name="a">
			<xsl:attribute name="href">javascript:NotifyClick("frameref:" + "<xsl:value-of select="./sr:ReferencedSOP/sr:ReferencedSOPInstanceUID"/>")</xsl:attribute>
			<xsl:value-of select="./sr:ReferencedSOP/sr:ReferencedSOPInstanceUID"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="*">
		<xsl:message terminate="no">
			Unmatched node at <xsl:value-of select="name()"/>
		</xsl:message>
	</xsl:template>

</xsl:stylesheet>
