//
//	Copyright (c)2004 GE Medical Systems
//
//	Helper comment to enable syntax coloring in InterDev: <script>

var _activexDicomTreeView	= null;
var _rgreport				= new Array;

///////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////

//
// onload
//
function window.onload()
{
	if (GetApp().IsInViewerExe())
	{
		_activexDicomTreeView = external.CreateObjectInPlace('{D22E56FD-B901-4567-B404-0179E937E89C}', document.all.DicomTreeView);
	}
	else
	{
		if ((typeof(DicomTreeView) == 'object') && DicomTreeView.object != null && DicomTreeView.readyState == 4)
		{
			_activexDicomTreeView = DicomTreeView;
		}
	}

	if (HasErrors())
		return;
		
	try
	{
		var strCols = GetUserDataAttribute(parent.framesetAll, "framesetApp_strCols");
		if (strCols != null && strCols != '')
		{
			parent.framesetApp.cols = strCols;
		}
	
		var config = GetApp().GetConfig();
		_activexDicomTreeView.strApplicationDataURL = GetApp().GetApplicationDataUrl(location);
		_activexDicomTreeView.SetLocaleDbAndId(GetApp().GetLocaleDB().GetXMLDb(), config.LocaleId());
		_activexDicomTreeView.SetSupportedAppUIDs(CreateXmlDoc4('appuid.xml'));
		_activexDicomTreeView.PETThresholdParameters = config.GetPETThresholdParameters();
		
		_activexDicomTreeView.AttachEvent('OnImageChanged', FireOnImageChanged);
		_activexDicomTreeView.AttachEvent('OnDicomDirChanged', FireOnDicomDirChanged);
		_activexDicomTreeView.AttachEvent('OnStudyChanged', FireOnStudyChanged);
		_activexDicomTreeView.AttachEvent('OnSeriesChanged', FireOnSeriesChanged);
		
	}
	catch(e)
	{
	}
}


//
// onunload
//
function window.onunload()
{
	try
	{
		if (GetApp().IsInViewerExe())
		{
			external.DisposeObject(DicomTreeView);
		}
		SetUserDataAttribute(parent.framesetAll, "framesetApp_strCols", parent.framesetApp.cols);
	}
	catch(e)
	{
	}
}


//
// HasErrors
//
function HasErrors()
{
	try
	{
		return _activexDicomTreeView == null;
	}
	catch (e)
	{
		return true;
	}
}


//
// GetErrorText
//
// Purpose: Return the error description or an empty string when there is no error.
//
function GetErrorText()
{
	if (HasErrors())
	{
		return GetApp().GetLocaleString('msgCannotLoadDicomDirTreeView');
	}
	else
	{
		return '';
	}
}


//
// GetImagePath
//
function GetImagePath(index)
{
	return _activexDicomTreeView.ImagePath(index);
}


//
// FireOnImageChanged();
//
function FireOnImageChanged()
{
	if (window.OnImageChanged != null) 
		OnImageChanged();
}


//
// FireOnBrowseMode
//
function FireOnBrowseMode()
{
	if (window.onbrowsemode != null) 
		onbrowsemode();
}


//
// FireOnDicomDirChanged
//
function FireOnDicomDirChanged()
{
	if (window.OnDicomDirChanged != null) 
		OnDicomDirChanged();

	_activexDicomTreeView.SelectFirstImageInDicomDir();
}


//
// FireOnStudyChanged
//
function FireOnStudyChanged()
{
	if (window.OnStudyChanged != null) 
		OnStudyChanged();
}


//
// FireOnSeriesChanged
//
function FireOnSeriesChanged()
{
	if (window.OnSeriesChanged != null) 
		OnSeriesChanged();
}

//
// BrowseForFile
//
function BrowseForFile()
{
	FireOnBrowseMode();
	_activexDicomTreeView.Browse();
}


//
// SetDicomDirPath
//
function SetDicomDirPath(strPath)
{
	_activexDicomTreeView.DicomDirPath = strPath;
	_activexDicomTreeView.SelectFirstImageInDicomDir();
}


//
// SelectNextImagesInSeries
//
function SelectNextImagesInSeries(nCount)
{
	_activexDicomTreeView.SelectNextImagesInSeries(nCount);
}


//
// SelectPreviousImagesInSeries
//
function SelectPreviousImagesInSeries(nCount)
{
	_activexDicomTreeView.SelectPreviousImagesInSeries(nCount);
}


//
// IsImageSelected
//
function IsImageSelected()
{
	return _activexDicomTreeView.IsImageSelected;
}


//
// HasMIPSeries
//
function HasMIPSeries()
{
	return _activexDicomTreeView.HasMIPSeries;
}


//
// IsPetCtStudy
//
var f_bIsPetCtStudy = null; // cache for performance reasons
function IsPetCtStudy()
{
	if (f_bIsPetCtStudy == null)
	{
		f_bIsPetCtStudy = _activexDicomTreeView.IsPetCtStudy;
	}
	return f_bIsPetCtStudy;
}


//
// ResetIsPetCtStudyFlag
//
function ResetIsPetCtStudyFlag()
{
	f_bIsPetCtStudy = null;
}


//
// HasNextImageInSeries
//
function HasNextImageInSeries()
{
	return _activexDicomTreeView.HasNextImageInSeries;
}


//
// HasPreviousImageInSeries
//
function HasPreviousImageInSeries()
{
	return _activexDicomTreeView.HasPreviousImageInSeries;
}


//
// SelectFirstImageInSeries
//
function SelectFirstImageInSeries()
{
	return _activexDicomTreeView.SelectFirstImageInSeries();
}


//
// GetSeriesCount
//
function GetSeriesCount()
{
	return _activexDicomTreeView.SeriesCount;
}


//
// GetRealSeriesIndex
//
function GetRealSeriesIndex(nIndex)
{
	return _activexDicomTreeView.SeriesIndex(nIndex);
}


//
// GetActiveSeriesIndex
//
function GetActiveSeriesIndex()
{
	return _activexDicomTreeView.ActiveSeriesIndex;
}


//
// GetPresentationStateCount
//
function GetPresentationStateCount()
{
	return _activexDicomTreeView.PresentationStateCount;
}


//
// GetPresentationStateLabel
//
function GetPresentationStateLabel(index)
{
	return _activexDicomTreeView.GetPresentationStateLabel(index);
}


//
// GetPresentationStateDescription
//
function GetPresentationStateDescription(index)
{
	return _activexDicomTreeView.GetPresentationStateDescription(index);
}


//
// GetPresentationStateFilename
//
function GetPresentationStateFilename(index, strUID)
{
	return _activexDicomTreeView.GetPresentationStateFilename(index, strUID);
}


//
// GetImageInstanceUID
//
function GetImageInstanceUID(index)
{
	return _activexDicomTreeView.ImageInstanceUID(index);
}


//
// GetSeriesInstanceUID
//
function GetSeriesInstanceUID(index)
{
	return _activexDicomTreeView.SeriesInstanceUID(index);
}


//
// SetActiveImages
//
function SetActiveImages(nSeriesIndex, nImageIndex, nViewports)
{
	if (nSeriesIndex != -1)
	{
		_activexDicomTreeView.SetActiveImages(nSeriesIndex, nImageIndex, nViewports);
	}
}

//
// GetActiveImageIndex
//
function GetActiveImageIndex()
{
	return _activexDicomTreeView.ActiveImageIndex;
}


//
// GetActiveModality
//
function GetActiveModality()
{
	return _activexDicomTreeView.ActiveModality;
}


//
// SelectPreviousSeries
//
function SelectPreviousSeries()
{
	_activexDicomTreeView.SelectPreviousSeriesInStudy();
}


//
// SelectNextSeries
//
function SelectNextSeries()
{
	_activexDicomTreeView.SelectNextSeriesInStudy();
}


//
// HasPreviousSeries
//
function HasPreviousSeries()
{
	return _activexDicomTreeView.HasPreviousSeriesInStudy;
}


//
// HasNextSeries
//
function HasNextSeries()
{
	return _activexDicomTreeView.HasNextSeriesInStudy;
}


//
// GetViewMode
// 
function GetViewMode()
{
	return _activexDicomTreeView.ViewMode;
}


//
// SetViewMode
// 
function SetViewMode(nViewMode)
{
	_activexDicomTreeView.ViewMode = nViewMode;
}


//
//	InitReports()
//
function InitReports()
{
	_rgreport = new Array;

	InitReportsSR();
	InitReportsDMS();
}


//
//	InitReportsSR()
//
function InitReportsSR()
{
	var creportSR	= _activexDicomTreeView.StructuredReportCount;
	for (var ireport = 0; ireport < creportSR; ireport++)
	{
		_rgreport.push(new CReportSR(ireport));		
	}
}


//
//	InitReportsDMS()
//
function InitReportsDMS()
{
	var strPathImage	= GetImagePath(0);
	var iPos			= strPathImage.indexOf("SDY");
	
	if (iPos == -1)
		return;

	var strPathReport	= strPathImage.substr(0, iPos - 1) + "/EXAMDATA/" + strPathImage.substr(iPos, 8);
	strPathReport = strPathReport.replace("DICOMDAT/EXAMDATA/", "EXAMDATA/");
	
	try
	{
		var xmldoc	= CreateXmlDoc4();
		xmldoc.load(strPathReport + "/index.xml");
		
		var rgnode	= xmldoc.selectNodes("reports/report");
		for (var ireport = 0; ireport < rgnode.length; ireport++)
		{
			_rgreport.push(new CReportDMS(rgnode[ireport].getAttribute("description"),
								strPathReport + "/" + rgnode[ireport].getAttribute("filename")));
		}
	}
	catch (excep)
	{
		// ignore exception: path does not exist so there are no reports
	}
}


//
//	GetReportCount()
//
function GetReportCount()
{
	return _rgreport.length;
}


//
//	GetReportLabel()
//
function GetReportLabel(index)
{
	return _rgreport[index].GetLabel();
}

//
//	GetReportDcmInfo()
//
function GetReportDcmInfo(index)
{
	return _rgreport[index].GetDcmInfo();
}

//
//	GetReportHtml()
//
function GetReportHtml(index)
{
	return _rgreport[index].GetHtml();
}


//
// GetPETWindowLevel
//
function GetPETWindowLevel(nSeriesIndex)
{
	return _activexDicomTreeView.GetPETWindowLevel(nSeriesIndex);
}


//
// GetModality
//
function GetModality(nSeriesIndex)
{
	return _activexDicomTreeView.Modality(nSeriesIndex);
}
