//
//	Copyright (c)2004 GE Medical Systems
//
//	Helper comment to enable syntax coloring in InterDev: <script>


//
// oncontextmenu
//
// Purpose: Forward the oncontextmenu event to the parent document.
//
function document.oncontextmenu()
{
	if (parent != null && parent != this)
	{
		return parent.document.oncontextmenu();
	}
	return false;
}


//
// ShowHelp
//
// Purpose: Forward the onhelp event to the parent window.
//          If the window has no parent the event bubbles as usual.
//
function ShowHelp()
{
	if (parent != null && parent.ShowHelp != null)
	{
		return parent.ShowHelp();
	}
}


//
// onhelp
//
// Purpose: Catch the onhelp event and forward it to 'ShowHelp'.
//          This helper function is needed to trap the 'F1' key.
//
function window.onhelp()
{
	return ShowHelp();
}


//
// GetISettings()
//
function GetISettings()
{
	if (parent == null || parent.GetISettings == null)
		return null;

	return parent.GetISettings();
}


var app = null;

//
// GetApp()
//
function GetApp()
{
	if (app == null && parent != null)
	{
		var p = parent;
		while (p != null && p.GetApp == null)
		{
			p = p.parent;
		}
		app = p.GetApp();
	}
	return app;
}


//
//	NotifyClick()
//
function NotifyClick(arg)
{
	// called by image link in Structured Report
	alert(GetApp().GetLocaleString('msgCannotOpenImageLink'));
}
